/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.modules;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.DropDownList;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.managers.interfaces.IStatisticsManager;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import com.minecolonies.core.colony.buildings.moduleviews.BuildingStatisticsModuleView;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class WindowStatsModule
extends AbstractModuleWindow {
    private static final LinkedHashMap<String, Integer> INTERVAL = new LinkedHashMap();
    private static final String TAG_BUTTON_HIDEZERO = "hidezero";
    private static final ResourceLocation TEXTURE_ASSIGN_ON_NORMAL = ResourceLocation.parse((String)"minecolonies:textures/gui/builderhut/builder_button_mini_check.png");
    private static final ResourceLocation TEXTURE_ASSIGN_ON_DISABLED = ResourceLocation.parse((String)"minecolonies:textures/gui/builderhut/builder_button_mini_disabled_check.png");
    private static final ResourceLocation TEXTURE_ASSIGN_OFF_NORMAL = ResourceLocation.parse((String)"minecolonies:textures/gui/builderhut/builder_button_mini.png");
    private static final ResourceLocation TEXTURE_ASSIGN_OFF_DISABLED = ResourceLocation.parse((String)"minecolonies:textures/gui/builderhut/builder_button_mini_disabled.png");
    private DropDownList intervalDropdown;
    public String selectedInterval = "com.minecolonies.coremod.gui.interval.yesterday";
    private static final String HUT_RESOURCE_SUFFIX = ":gui/layouthuts/layoutstatsmodule.xml";
    private BuildingStatisticsModuleView moduleView = null;
    private boolean hideZeroStats = false;

    public WindowStatsModule(IBuildingView building, BuildingStatisticsModuleView moduleView) {
        super(building, "minecolonies:gui/layouthuts/layoutstatsmodule.xml");
        this.moduleView = moduleView;
        this.registerButton(TAG_BUTTON_HIDEZERO, this::hideZeroClicked);
    }

    public void onOpened() {
        super.onOpened();
        this.updateStats();
    }

    private void updateStats() {
        final IStatisticsManager statisticsManager = this.moduleView.getBuildingStatisticsManager();
        final @NotNull ArrayList<String> stats = new ArrayList<String>(statisticsManager.getStatTypes());
        ((ScrollingList)this.findPaneOfTypeByID("stats", ScrollingList.class)).setDataProvider(new ScrollingList.DataProvider(){
            private List<String> filteredStats = new ArrayList<String>();
            {
                int interval = INTERVAL.get(WindowStatsModule.this.selectedInterval);
                if (WindowStatsModule.this.hideZeroStats) {
                    for (int i = 0; i < stats.size(); ++i) {
                        if (interval > 0) {
                            if (statisticsManager.getStatsInPeriod((String)stats.get(i), WindowStatsModule.this.buildingView.getColony().getDay() - interval, WindowStatsModule.this.buildingView.getColony().getDay()) <= 0) continue;
                            this.filteredStats.add((String)stats.get(i));
                            continue;
                        }
                        if (statisticsManager.getStatTotal((String)stats.get(i)) <= 0) continue;
                        this.filteredStats.add((String)stats.get(i));
                    }
                } else {
                    this.filteredStats.addAll(stats);
                }
            }

            public int getElementCount() {
                return this.filteredStats.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                int stat = statisticsManager.getStatTotal(this.filteredStats.get(index));
                int interval = INTERVAL.get(WindowStatsModule.this.selectedInterval);
                if (interval > 0) {
                    stat = statisticsManager.getStatsInPeriod(this.filteredStats.get(index), WindowStatsModule.this.buildingView.getColony().getDay() - interval, WindowStatsModule.this.buildingView.getColony().getDay());
                }
                Text resourceLabel = (Text)rowPane.findPaneOfTypeByID("desc", Text.class);
                String id = this.filteredStats.get(index);
                if (id.contains(";")) {
                    String[] split = id.split(";");
                    resourceLabel.setText(Component.translatableEscape((String)("com.minecolonies.coremod.gui.townhall.stats." + split[0]), (Object[])new Object[]{stat, Component.translatableEscape((String)split[1], (Object[])new Object[0])}));
                } else {
                    resourceLabel.setText(Component.translatableEscape((String)("com.minecolonies.coremod.gui.townhall.stats." + id), (Object[])new Object[]{stat}));
                }
                PaneBuilders.tooltipBuilder().hoverPane((Pane)resourceLabel).build().setText(resourceLabel.getText());
            }
        });
        this.intervalDropdown = (DropDownList)this.findPaneOfTypeByID("intervals", DropDownList.class);
        this.intervalDropdown.setHandler(this::onDropDownListChanged);
        this.intervalDropdown.setDataProvider(new DropDownList.DataProvider(this){

            public int getElementCount() {
                return INTERVAL.size();
            }

            public MutableComponent getLabel(int index) {
                return Component.translatableEscape((String)((String)INTERVAL.keySet().toArray()[index]), (Object[])new Object[0]);
            }
        });
        this.intervalDropdown.setSelectedIndex(new ArrayList<String>(INTERVAL.keySet()).indexOf(this.selectedInterval));
    }

    private void onDropDownListChanged(DropDownList dropDownList) {
        String temp = (String)INTERVAL.keySet().toArray()[dropDownList.getSelectedIndex()];
        if (!temp.equals(this.selectedInterval)) {
            this.selectedInterval = temp;
            this.updateStats();
        }
    }

    private void hideZeroClicked(@NotNull Button button) {
        ButtonImage hideButton = (ButtonImage)this.findPaneOfTypeByID(TAG_BUTTON_HIDEZERO, ButtonImage.class);
        boolean bl = this.hideZeroStats = !this.hideZeroStats;
        if (this.hideZeroStats) {
            hideButton.setImage(TEXTURE_ASSIGN_ON_NORMAL);
            hideButton.setImageDisabled(TEXTURE_ASSIGN_ON_DISABLED);
        } else {
            hideButton.setImage(TEXTURE_ASSIGN_OFF_NORMAL);
            hideButton.setImageDisabled(TEXTURE_ASSIGN_OFF_DISABLED);
        }
        this.updateStats();
    }

    static {
        INTERVAL.put("com.minecolonies.coremod.gui.interval.yesterday", 1);
        INTERVAL.put("com.minecolonies.coremod.gui.interval.lastweek", 7);
        INTERVAL.put("com.minecolonies.coremod.gui.interval.100days", 100);
        INTERVAL.put("com.minecolonies.coremod.gui.interval.alltime", -1);
    }
}

