/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.modules;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildingextensions.IBuildingExtension;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import com.minecolonies.core.colony.buildingextensions.FarmField;
import com.minecolonies.core.colony.buildings.moduleviews.FieldsModuleView;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class FarmFieldsModuleWindow
extends AbstractModuleWindow {
    private static final String HUT_FIELDS_RESOURCE_SUFFIX = ":gui/layouthuts/layoutfarmfields.xml";
    private static final String LIST_FIELDS = "fields";
    private static final String TAG_DISTANCE = "dist";
    private static final String TAG_STAGE_TEXT = "nextstagetext";
    private static final String TAG_STAGE_ICON = "nextstageicon";
    private static final String TAG_BUTTON_ASSIGN = "assign";
    private static final String TAG_BUTTON_ASSIGNMENT_MODE = "assignmentMode";
    private static final String TAG_FIELD_COUNT = "fieldCount";
    private static final String TAG_ICON = "icon";
    private static final String TEXTURE_ASSIGN_ON_NORMAL = "minecolonies:textures/gui/builderhut/builder_button_mini_check.png";
    private static final String TEXTURE_ASSIGN_ON_DISABLED = "minecolonies:textures/gui/builderhut/builder_button_mini_disabled_check.png";
    private static final String TEXTURE_ASSIGN_OFF_NORMAL = "minecolonies:textures/gui/builderhut/builder_button_mini.png";
    private static final String TEXTURE_ASSIGN_OFF_DISABLED = "minecolonies:textures/gui/builderhut/builder_button_mini_disabled.png";
    private final FieldsModuleView moduleView;
    private ScrollingList fieldList;

    public FarmFieldsModuleWindow(IBuildingView building, FieldsModuleView moduleView) {
        super(building, "minecolonies:gui/layouthuts/layoutfarmfields.xml");
        this.moduleView = moduleView;
        this.registerButton(TAG_BUTTON_ASSIGNMENT_MODE, this::assignmentModeClicked);
        this.registerButton(TAG_BUTTON_ASSIGN, this::assignClicked);
    }

    private void assignmentModeClicked(@NotNull Button button) {
        this.moduleView.setAssignFieldManually(!this.moduleView.assignFieldManually());
        this.updateUI();
    }

    private void assignClicked(@NotNull Button button) {
        int row = this.fieldList.getListElementIndexByPane((Pane)button);
        IBuildingExtension field = this.moduleView.getFields().get(row);
        if (field.isTaken()) {
            this.moduleView.freeField(field);
        } else {
            this.moduleView.assignField(field);
        }
        this.updateUI();
    }

    private void updateUI() {
        ((Button)this.findPaneOfTypeByID(TAG_BUTTON_ASSIGNMENT_MODE, Button.class)).setText(Component.translatableEscape((String)(this.moduleView.assignFieldManually() ? "com.minecolonies.coremod.gui.hiring.on" : "com.minecolonies.coremod.gui.hiring.off"), (Object[])new Object[0]));
        ((Text)this.findPaneOfTypeByID(TAG_FIELD_COUNT, Text.class)).setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.fields.fieldcount", (Object[])new Object[]{this.moduleView.getOwnedFields().size(), this.moduleView.getMaxFieldCount()}));
    }

    public void onOpened() {
        super.onOpened();
        this.fieldList = (ScrollingList)this.findPaneOfTypeByID(LIST_FIELDS, ScrollingList.class);
        this.fieldList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return FarmFieldsModuleWindow.this.moduleView.getFields().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                FarmField farmField;
                IBuildingExtension field = FarmFieldsModuleWindow.this.moduleView.getFields().get(index);
                if (field instanceof FarmField && !(farmField = (FarmField)field).getSeed().isEmpty()) {
                    ((ItemIcon)rowPane.findPaneOfTypeByID(FarmFieldsModuleWindow.TAG_ICON, ItemIcon.class)).setItem(farmField.getSeed());
                    ((Text)rowPane.findPaneOfTypeByID(FarmFieldsModuleWindow.TAG_STAGE_TEXT, Text.class)).setText(Component.translatable((String)"com.minecolonies.coremod.gui.field.status"));
                    ((Image)rowPane.findPaneOfTypeByID(FarmFieldsModuleWindow.TAG_STAGE_ICON, Image.class)).setImage(farmField.getFieldStage().getNextStage().getStageIcon(), true);
                }
                String distance = Integer.toString(field.getSqDistance(FarmFieldsModuleWindow.this.buildingView));
                BlockPosUtil.DirectionResult direction = BlockPosUtil.calcDirection(FarmFieldsModuleWindow.this.buildingView.getPosition(), field.getPosition());
                Component directionText = switch (direction) {
                    case BlockPosUtil.DirectionResult.UP, BlockPosUtil.DirectionResult.DOWN -> direction.getLongText();
                    default -> Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.fields.distance", (Object[])new Object[]{Component.literal((String)(distance + "m")), direction.getShortText()});
                };
                ((Text)rowPane.findPaneOfTypeByID(FarmFieldsModuleWindow.TAG_DISTANCE, Text.class)).setText(directionText);
                ButtonImage assignButton = (ButtonImage)rowPane.findPaneOfTypeByID(FarmFieldsModuleWindow.TAG_BUTTON_ASSIGN, ButtonImage.class);
                assignButton.setEnabled(FarmFieldsModuleWindow.this.moduleView.assignFieldManually());
                assignButton.show();
                assignButton.setHoverPane(null);
                if (field.isTaken()) {
                    FarmFieldsModuleWindow.this.setAssignButtonTexture(assignButton, true);
                } else {
                    FarmFieldsModuleWindow.this.setAssignButtonTexture(assignButton, false);
                    if (!FarmFieldsModuleWindow.this.moduleView.canAssignField(field)) {
                        assignButton.disable();
                        MutableComponent warningTooltip = FarmFieldsModuleWindow.this.moduleView.getFieldWarningTooltip(field);
                        if (warningTooltip != null && FarmFieldsModuleWindow.this.moduleView.assignFieldManually()) {
                            ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append(warningTooltip.withStyle(ChatFormatting.RED))).hoverPane((Pane)assignButton).build();
                        }
                    }
                }
            }
        });
        this.updateUI();
    }

    public void onUpdate() {
        super.onUpdate();
        this.updateUI();
    }

    private void setAssignButtonTexture(ButtonImage button, boolean isOn) {
        if (isOn) {
            button.setImage(ResourceLocation.parse((String)TEXTURE_ASSIGN_ON_NORMAL));
            button.setImageDisabled(ResourceLocation.parse((String)TEXTURE_ASSIGN_ON_DISABLED));
        } else {
            button.setImage(ResourceLocation.parse((String)TEXTURE_ASSIGN_OFF_NORMAL));
            button.setImageDisabled(ResourceLocation.parse((String)TEXTURE_ASSIGN_OFF_DISABLED));
        }
    }
}

