/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui;

import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.structurize.client.gui.WindowSwitchPack;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.items.component.SupplyData;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import com.minecolonies.core.client.gui.WindowSupplies;
import com.minecolonies.core.event.ColonyStoryListener;
import com.minecolonies.core.network.messages.server.MarkStoryReadOnItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;

public class WindowSupplyStory
extends AbstractWindowSkeleton {
    private final BlockPos pos;
    private final String type;
    private final InteractionHand hand;
    private ItemStack stack;

    public WindowSupplyStory(BlockPos pos, String type, ItemStack stack, InteractionHand hand) {
        super("minecolonies:gui/windowsupplystory.xml");
        this.mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
        this.pos = pos == null ? this.mc.player.blockPosition().relative(this.mc.player.getDirection(), 10) : pos;
        this.type = type;
        this.stack = stack;
        this.hand = hand;
        this.registerButton("cancel", this::close);
        this.registerButton("colonyStylePicker", this::switchPack);
        this.registerButton("place", this::place);
        ArrayList<MutableComponent> story = new ArrayList<MutableComponent>();
        SupplyData currentComponent = SupplyData.readFromItemStack(stack);
        if (currentComponent.instantPlacement()) {
            Random random = new Random(currentComponent.randomKey());
            List biomes = this.mc.level.registryAccess().registryOrThrow(Registries.BIOME).holders().toList();
            Holder biome = (Holder)biomes.get(random.nextInt(biomes.size()));
            if (stack.getItem() == ModItems.supplyCamp) {
                story.add(Component.literal((String)ColonyStoryListener.pickRandom(ColonyStoryListener.supplyCampStories, (Holder<Biome>)biome, random)));
            } else {
                story.add(Component.literal((String)ColonyStoryListener.pickRandom(ColonyStoryListener.supplyShipStories, (Holder<Biome>)biome, random)));
            }
            story.add(Component.empty());
        }
        story.add(Component.translatable((String)"com.minecolonies.core.gui.supplies.guide", (Object[])new Object[]{Component.translatable((String)stack.getItem().getDescriptionId())}));
        story.add(Component.empty());
        if (stack.getItem() == ModItems.supplyCamp) {
            story.add(Component.translatable((String)"com.minecolonies.core.gui.supplycamp.guide"));
        } else {
            story.add(Component.translatable((String)"com.minecolonies.core.gui.supplyship.guide"));
        }
        ((Text)this.findPaneOfTypeByID("text", Text.class)).setText(story);
        ((Button)this.findPaneOfTypeByID("place", Button.class)).setText(Component.translatable((String)"com.minecolonies.core.gui.supplies.place", (Object[])new Object[]{Component.translatable((String)stack.getItem().getDescriptionId())}));
    }

    private void place() {
        new MarkStoryReadOnItem(this.hand).sendToServer();
        new WindowSupplies(this.pos, this.type).open();
    }

    private void switchPack() {
        new WindowSwitchPack(() -> new WindowSupplyStory(this.pos, this.type, this.stack, this.hand)).open();
    }
}

