/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.blocks;

import com.minecolonies.api.blocks.AbstractBlockBarrel;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.blocks.types.BarrelType;
import com.minecolonies.core.tileentities.TileEntityBarrel;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class BlockBarrel
extends AbstractBlockBarrel<BlockBarrel>
implements EntityBlock {
    public static final MapCodec<BlockBarrel> CODEC = BlockBarrel.simpleCodec(BlockBarrel::new);
    private static final float BLOCK_HARDNESS = 5.0f;
    private static final String BLOCK_NAME = "barrel_block";
    private static final float RESISTANCE = 1.0f;

    public BlockBarrel() {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).sound(SoundType.WOOD).strength(5.0f, 1.0f));
    }

    public BlockBarrel(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AbstractBlockBarrel.FACING, (Comparable)Direction.NORTH)).setValue((Property)VARIANT, (Comparable)((Object)BarrelType.ZERO)));
    }

    protected MapCodec<BlockBarrel> codec() {
        return CODEC;
    }

    @Override
    public ResourceLocation getRegistryName() {
        return new ResourceLocation("minecolonies", BLOCK_NAME);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AbstractBlockBarrel.FACING, VARIANT});
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new TileEntityBarrel(blockPos, blockState);
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        ItemStack itemstack = player.getInventory().getSelected();
        BlockEntity te = worldIn.getBlockEntity(pos);
        if (te instanceof TileEntityBarrel && !worldIn.isClientSide) {
            ((TileEntityBarrel)te).useBarrel(player, itemstack, ray.getDirection());
            ((TileEntityBarrel)te).updateBlock(worldIn);
        }
        return ItemInteractionResult.SUCCESS;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.5, (double)1.0);
    }

    @Deprecated
    @NotNull
    public BlockState rotate(@NotNull BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)AbstractBlockBarrel.FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)AbstractBlockBarrel.FACING)));
    }

    @Deprecated
    @NotNull
    public BlockState mirror(@NotNull BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)AbstractBlockBarrel.FACING)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)AbstractBlockBarrel.FACING, (Comparable)context.getHorizontalDirection());
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        return !worldIn.isEmptyBlock(pos.below()) && worldIn.getBlockState(pos.below()).getBlock() != ModBlocks.blockBarrel;
    }
}

