/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.colony.buildings.IBuilding;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class WorldUtil {
    public static boolean isBlockLoaded(LevelAccessor world, BlockPos pos) {
        return WorldUtil.isChunkLoaded(world, pos.getX() >> 4, pos.getZ() >> 4);
    }

    public static boolean isChunkLoaded(LevelAccessor world, int x, int z) {
        if (world.getChunkSource() instanceof ServerChunkCache) {
            ChunkHolder holder = ((ServerChunkCache)world.getChunkSource()).chunkMap.getVisibleChunkIfPresent(ChunkPos.asLong((int)x, (int)z));
            if (holder != null) {
                return holder.getFullStatus().isOrAfter(FullChunkStatus.FULL) && holder.getChunkIfPresent(ChunkStatus.FULL) != null;
            }
            return false;
        }
        return world.getChunk(x, z, ChunkStatus.FULL, false) != null;
    }

    public static void markChunkDirty(Level world, BlockPos pos) {
        if (WorldUtil.isBlockLoaded((LevelAccessor)world, pos)) {
            world.getChunk(pos.getX() >> 4, pos.getZ() >> 4).setUnsaved(true);
            BlockState state = world.getBlockState(pos);
            world.sendBlockUpdated(pos, state, state, 3);
        }
    }

    public static boolean isChunkLoaded(LevelAccessor world, ChunkPos pos) {
        return WorldUtil.isChunkLoaded(world, pos.x, pos.z);
    }

    public static boolean isEntityBlockLoaded(LevelAccessor world, BlockPos pos) {
        return WorldUtil.isEntityChunkLoaded(world, pos.getX() >> 4, pos.getZ() >> 4);
    }

    public static boolean isEntityChunkLoaded(LevelAccessor world, int x, int z) {
        return WorldUtil.isEntityChunkLoaded(world, new ChunkPos(x, z));
    }

    public static boolean isEntityChunkLoaded(LevelAccessor world, ChunkPos pos) {
        if (world instanceof ServerLevel) {
            return ((ServerLevel)world).isPositionEntityTicking(pos.getWorldPosition());
        }
        return WorldUtil.isChunkLoaded(world, pos);
    }

    public static boolean isAABBLoaded(Level world, AABB box) {
        return WorldUtil.isChunkLoaded((LevelAccessor)world, (int)box.minX >> 4, (int)box.minZ >> 4) && WorldUtil.isChunkLoaded((LevelAccessor)world, (int)box.maxX >> 4, (int)box.maxZ >> 4);
    }

    public static boolean isDayTime(Level world) {
        return world.getDayTime() % 24000L <= 12600L;
    }

    public static boolean isPastTime(Level world, int pastTime) {
        return world.getDayTime() % 24000L <= (long)pastTime;
    }

    public static boolean isPastNoon(Level world) {
        return WorldUtil.isPastTime(world, 6000);
    }

    public static boolean isOverworldType(@NotNull Level world) {
        return WorldUtil.isOfWorldType(world, (ResourceKey<DimensionType>)BuiltinDimensionTypes.OVERWORLD);
    }

    public static boolean isNetherType(@NotNull Level world) {
        return WorldUtil.isOfWorldType(world, (ResourceKey<DimensionType>)BuiltinDimensionTypes.NETHER);
    }

    public static boolean isOfWorldType(@NotNull Level world, @NotNull ResourceKey<DimensionType> type) {
        RegistryAccess dynRegistries = world.registryAccess();
        ResourceLocation loc = ((Registry)dynRegistries.registry(Registries.DIMENSION_TYPE).get()).getKey((Object)world.dimensionType());
        if (loc == null) {
            if (world.isClientSide) {
                return world.dimensionType().effectsLocation().equals((Object)type.location());
            }
            return false;
        }
        ResourceKey regKey = ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)loc);
        return regKey == type;
    }

    public static boolean isPeaceful(@NotNull Level world) {
        return !world.getLevelData().getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) || world.getDifficulty().equals((Object)Difficulty.PEACEFUL);
    }

    public static boolean setBlockState(LevelAccessor world, BlockPos pos, BlockState state) {
        if (world.isClientSide()) {
            return world.setBlock(pos, state, 3);
        }
        return WorldUtil.setBlockState(world, pos, state, 3);
    }

    public static boolean setBlockState(LevelAccessor world, BlockPos pos, BlockState state, int flags) {
        if (world.isClientSide() || !(world instanceof ServerLevel)) {
            return world.setBlock(pos, state, flags);
        }
        ServerLevel serverLevel = (ServerLevel)world;
        if ((flags & 2) != 0) {
            Set navigators = serverLevel.navigatingMobs;
            serverLevel.navigatingMobs.clear();
            boolean result = world.setBlock(pos, state, flags);
            serverLevel.navigatingMobs.addAll(navigators);
            return result;
        }
        return world.setBlock(pos, state, flags);
    }

    public static boolean removeBlock(LevelAccessor world, BlockPos pos, boolean isMoving) {
        FluidState fluidstate = world.getFluidState(pos);
        return WorldUtil.setBlockState(world, pos, fluidstate.createLegacyBlock(), 3 | (isMoving ? 64 : 0));
    }

    public static <T extends Entity> List<? extends T> getEntitiesWithinBuilding(@NotNull Level world, @NotNull Class<? extends T> clazz, @NotNull IBuilding building, @Nullable Predicate<? super T> predicate) {
        Tuple<BlockPos, BlockPos> corners = building.getCorners();
        if (predicate == null) {
            return world.getEntitiesOfClass(clazz, new AABB((double)((BlockPos)corners.getA()).getX(), (double)((BlockPos)corners.getA()).getY(), (double)((BlockPos)corners.getA()).getZ(), (double)((BlockPos)corners.getB()).getX(), (double)((BlockPos)corners.getB()).getY(), (double)((BlockPos)corners.getB()).getZ()));
        }
        return world.getEntitiesOfClass(clazz, new AABB((double)((BlockPos)corners.getA()).getX(), (double)((BlockPos)corners.getA()).getY(), (double)((BlockPos)corners.getA()).getZ(), (double)((BlockPos)corners.getB()).getX(), (double)((BlockPos)corners.getB()).getY(), (double)((BlockPos)corners.getB()).getZ()), predicate);
    }

    public static int getDimensionMaxHeight(DimensionType dimensionType) {
        return dimensionType.logicalHeight() + dimensionType.minY();
    }

    public static int getDimensionMinHeight(DimensionType dimensionType) {
        return dimensionType.minY();
    }

    public static boolean isInWorldHeight(int yBlock, Level world) {
        DimensionType dimensionType = world.dimensionType();
        return yBlock > WorldUtil.getDimensionMinHeight(dimensionType) && yBlock < WorldUtil.getDimensionMaxHeight(dimensionType);
    }

    @Nullable
    public static Player getNearestPlayer(Mob livingEntity, int x, int y, int z, double lookDistance) {
        return (Player)WorldUtil.getNearestEntity(livingEntity.level().players(), livingEntity, x, y, z, lookDistance);
    }

    @Nullable
    public static <T extends LivingEntity> T getNearestEntity(List<? extends T> entityList, @Nullable Mob livingEntity, int x, int y, int z, double lookDistance) {
        double currentEntityDistance = 100.0;
        LivingEntity closestEntity = null;
        BlockPos entityPos = new BlockPos(x, y, z);
        for (LivingEntity entity : entityList) {
            Mob mob;
            double invisPct;
            double invisPctModifier;
            double entityDistance;
            if (entity == livingEntity || !entity.canBeSeenByAnyone() || (entityDistance = entity.blockPosition().above().distSqr((Vec3i)entityPos)) > lookDistance || entityDistance > (invisPctModifier = Math.max(lookDistance * (invisPct = entity.getVisibilityPercent((Entity)livingEntity)), 2.0)) * invisPctModifier || livingEntity instanceof Mob && !(mob = livingEntity).getSensing().hasLineOfSight((Entity)entity) || !(entityDistance < currentEntityDistance)) continue;
            currentEntityDistance = entityDistance;
            closestEntity = entity;
        }
        return (T)closestEntity;
    }
}

