/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.util.IItemHandlerCapProvider;
import com.minecolonies.api.util.InventoryUtils;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InventoryFunctions {
    private InventoryFunctions() {
    }

    public static boolean matchFirstInProvider(IItemHandlerCapProvider provider, @NotNull Predicate<ItemStack> tester) {
        return InventoryFunctions.matchInProvider(provider, inv -> slot -> tester, true);
    }

    private static boolean matchInProvider(@Nullable IItemHandlerCapProvider provider, @NotNull Function<IItemHandlerCapProvider, Function<Integer, Predicate<ItemStack>>> tester, boolean stopAfterFirst) {
        if (provider == null) {
            return false;
        }
        boolean foundOne = false;
        for (IItemHandler handler : InventoryUtils.getItemHandlersFromProvider(provider)) {
            int size = handler.getSlots();
            for (int slot = 0; slot < size; ++slot) {
                ItemStack stack = handler.getStackInSlot(slot);
                if (!tester.apply(provider).apply(slot).test(stack)) continue;
                foundOne = true;
                if (!stopAfterFirst) continue;
                return true;
            }
        }
        return foundOne;
    }

    public static boolean matchFirstInProviderWithAction(IItemHandlerCapProvider provider, @NotNull Predicate<ItemStack> tester, @NotNull IMatchActionResult action) {
        return InventoryFunctions.matchInProvider(provider, inv -> slot -> stack -> {
            if (tester.test((ItemStack)stack)) {
                action.accept(provider, (int)slot);
                return true;
            }
            return false;
        }, true);
    }

    public static boolean matchFirstInHandlerWithAction(@NotNull IItemHandler itemHandler, @NotNull Predicate<ItemStack> tester, @NotNull IMatchActionResultHandler action) {
        return InventoryFunctions.matchInHandler(itemHandler, inv -> slot -> stack -> {
            if (tester.test((ItemStack)stack)) {
                action.accept(itemHandler, (int)slot);
                return true;
            }
            return false;
        });
    }

    private static boolean matchInHandler(@Nullable IItemHandler handler, @NotNull Function<IItemHandler, Function<Integer, Predicate<ItemStack>>> tester) {
        if (handler == null) {
            return false;
        }
        int size = handler.getSlots();
        for (int slot = 0; slot < size; ++slot) {
            ItemStack stack = handler.getStackInSlot(slot);
            if (!tester.apply(handler).apply(slot).test(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchFirstInProviderWithSimpleAction(IItemHandlerCapProvider provider, @NotNull Predicate<ItemStack> tester, @NotNull Consumer<Integer> action) {
        return InventoryFunctions.matchInProvider(provider, inv -> slot -> stack -> {
            if (tester.test((ItemStack)stack)) {
                action.accept((Integer)slot);
                return true;
            }
            return false;
        }, true);
    }

    public static boolean matchFirstInProvider(IItemHandlerCapProvider inventory, @NotNull BiPredicate<Integer, ItemStack> tester) {
        return InventoryFunctions.matchInProvider(inventory, inv -> slot -> stack -> tester.test((Integer)slot, (ItemStack)stack), true);
    }

    @FunctionalInterface
    public static interface IMatchActionResult
    extends ObjIntConsumer<IItemHandlerCapProvider> {
        @Override
        public void accept(IItemHandlerCapProvider var1, int var2);
    }

    @FunctionalInterface
    public static interface IMatchActionResultHandler
    extends ObjIntConsumer<IItemHandler> {
        @Override
        public void accept(IItemHandler var1, int var2);
    }
}

