/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.research.requirements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.ModResearchRequirements;
import com.minecolonies.core.util.GsonHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class BuildingAlternatesResearchRequirement
implements IResearchRequirement {
    private static final String TAG_BUILDINGS_LIST = "building-list";
    private static final String TAG_BUILDING_NAME = "building-name";
    private static final String TAG_BUILDING_LVL = "building-lvl";
    private static final String RESEARCH_REQUIREMENT_ALTERNATE_BUILDINGS_PROP = "alternate-buildings";
    private static final String RESEARCH_REQUIREMENT_BUILDING_LEVEL_PROP = "level";
    private final Map<String, Integer> buildings = new HashMap<String, Integer>();

    public BuildingAlternatesResearchRequirement(CompoundTag nbt) {
        ListTag buildingsNBT = nbt.getList(TAG_BUILDINGS_LIST, 10);
        for (int i = 0; i < buildingsNBT.size(); ++i) {
            CompoundTag indNBT = buildingsNBT.getCompound(i);
            this.buildings.put(indNBT.getString(TAG_BUILDING_NAME), indNBT.getInt(TAG_BUILDING_LVL));
        }
    }

    public BuildingAlternatesResearchRequirement(JsonObject json) {
        for (JsonElement element : GsonHelper.getAsJsonArray((JsonObject)json, (String)RESEARCH_REQUIREMENT_ALTERNATE_BUILDINGS_PROP)) {
            String arrBuilding = element.getAsString();
            int arrLevel = GsonHelper.getAsInt((JsonObject)json, (String)RESEARCH_REQUIREMENT_BUILDING_LEVEL_PROP);
            this.buildings.merge(arrBuilding, arrLevel, Integer::sum);
        }
    }

    public Map<String, Integer> getBuildings() {
        return this.buildings;
    }

    @Override
    public ModResearchRequirements.ResearchRequirementEntry getRegistryEntry() {
        return (ModResearchRequirements.ResearchRequirementEntry)ModResearchRequirements.buildingAlternatesResearchRequirement.get();
    }

    @Override
    public MutableComponent getDesc() {
        MutableComponent requirementList = Component.translatable((String)"");
        Iterator<Map.Entry<String, Integer>> iterator = this.buildings.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Integer> kvp = iterator.next();
            requirementList.append((Component)Component.translatable((String)"com.minecolonies.coremod.research.requirement.building.level", (Object[])new Object[]{Component.translatable((String)("block.minecolonies.blockhut" + kvp.getKey())), kvp.getValue()}));
            if (!iterator.hasNext()) continue;
            requirementList.append((Component)Component.translatable((String)"com.minecolonies.coremod.research.requirement.building.or"));
        }
        return requirementList;
    }

    @Override
    public boolean isFulfilled(IColony colony) {
        for (Map.Entry<String, Integer> requirement : this.buildings.entrySet()) {
            if (!colony.hasBuilding(requirement.getKey(), requirement.getValue(), false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag buildingsNBT = new ListTag();
        for (Map.Entry<String, Integer> build : this.buildings.entrySet()) {
            CompoundTag indNBT = new CompoundTag();
            indNBT.putString(TAG_BUILDING_NAME, build.getKey());
            indNBT.putInt(TAG_BUILDING_LVL, build.getValue().intValue());
            buildingsNBT.add((Object)indNBT);
        }
        nbt.put(TAG_BUILDINGS_LIST, (Tag)buildingsNBT);
        return nbt;
    }
}

