/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.loot;

import com.minecolonies.api.loot.ModLootConditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityInBiomeTag
implements LootItemCondition {
    public static final EntityInBiomeTag ANY = new EntityInBiomeTag(null);
    public static final MapCodec<EntityInBiomeTag> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)TagKey.hashedCodec((ResourceKey)Registries.BIOME).optionalFieldOf("tag", null).forGetter(t -> t.tag)).apply((Applicative)builder, EntityInBiomeTag::ofNullable));
    @Nullable
    private final TagKey<Biome> tag;

    private EntityInBiomeTag(@Nullable TagKey<Biome> tag) {
        this.tag = tag;
    }

    public static LootItemCondition.Builder any() {
        return () -> ANY;
    }

    public static LootItemCondition.Builder of(@NotNull TagKey<Biome> category) {
        return () -> new EntityInBiomeTag(category);
    }

    private static EntityInBiomeTag ofNullable(TagKey<Biome> tag) {
        return tag == null ? ANY : new EntityInBiomeTag(tag);
    }

    @NotNull
    public LootItemConditionType getType() {
        return (LootItemConditionType)ModLootConditions.entityInBiomeTag.get();
    }

    public boolean test(@NotNull LootContext lootContext) {
        if (this.tag == null) {
            return true;
        }
        Entity entity = (Entity)lootContext.getParamOrNull(LootContextParams.THIS_ENTITY);
        if (entity != null && entity.level() != null) {
            return entity.level().getBiome(entity.blockPosition()).is(this.tag);
        }
        return false;
    }
}

