/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.inventory.container;

import com.minecolonies.api.blocks.AbstractBlockMinecoloniesRack;
import com.minecolonies.api.blocks.types.RackType;
import com.minecolonies.api.inventory.ModContainers;
import com.minecolonies.api.tileentities.AbstractTileEntityRack;
import com.minecolonies.api.util.ItemStackUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class ContainerRack
extends AbstractContainerMenu {
    private final IItemHandler inventory;
    public final AbstractTileEntityRack rack;
    public final AbstractTileEntityRack neighborRack;
    private final int inventorySize;

    public static ContainerRack fromFriendlyByteBuf(int windowId, Inventory inv, RegistryFriendlyByteBuf packetBuffer) {
        BlockPos tePos = packetBuffer.readBlockPos();
        BlockPos neighborPos = packetBuffer.readBlockPos();
        return new ContainerRack(windowId, inv, tePos, neighborPos);
    }

    public ContainerRack(int windowId, Inventory inv, BlockPos rack, BlockPos neighbor) {
        super((MenuType)ModContainers.rackInv.get(), windowId);
        int i;
        AbstractTileEntityRack neighborRack;
        AbstractTileEntityRack abstractTileEntityRack = (AbstractTileEntityRack)inv.player.level().getBlockEntity(rack);
        AbstractTileEntityRack abstractTileEntityRack2 = neighborRack = neighbor.equals((Object)BlockPos.ZERO) ? null : (AbstractTileEntityRack)inv.player.level().getBlockEntity(neighbor);
        this.inventory = neighborRack != null ? (abstractTileEntityRack.getBlockState().getValue(AbstractBlockMinecoloniesRack.VARIANT) != RackType.NO_RENDER ? new CombinedInvWrapper(new IItemHandlerModifiable[]{abstractTileEntityRack.getInventory(), neighborRack.getInventory()}) : new CombinedInvWrapper(new IItemHandlerModifiable[]{neighborRack.getInventory(), abstractTileEntityRack.getInventory()})) : abstractTileEntityRack.getInventory();
        this.rack = abstractTileEntityRack;
        this.neighborRack = neighborRack;
        this.inventorySize = this.inventory.getSlots() / 9;
        int size = this.inventory.getSlots();
        int columns = this.inventorySize <= 8 ? 9 : size / 8 + 1;
        int extraOffset = this.inventorySize <= 8 ? 0 : 2;
        int index = 0;
        for (int j = 0; j < Math.min(this.inventorySize, 8); ++j) {
            for (int k = 0; k < columns; ++k) {
                if (index >= size) continue;
                this.addSlot((Slot)new SlotItemHandler(this.inventory, index, 8 + k * 18, 18 + j * 18));
                ++index;
            }
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inv, j + i * 9 + 9, 8 + j * 18, 30 + extraOffset + 18 * Math.min(this.inventorySize, 8) + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inv, i, 8 + i * 18, 88 + extraOffset + 18 * Math.min(this.inventorySize, 8)));
        }
    }

    public void clicked(int slotId, int dragType, @NotNull ClickType clickTypeIn, Player player) {
        if (player.level().isClientSide || slotId >= this.inventory.getSlots() || slotId < 0) {
            super.clicked(slotId, dragType, clickTypeIn, player);
            return;
        }
        ItemStack currentStack = this.inventory.getStackInSlot(slotId).copy();
        super.clicked(slotId, dragType, clickTypeIn, player);
        ItemStack afterStack = this.inventory.getStackInSlot(slotId).copy();
        if (!ItemStack.matches((ItemStack)currentStack, (ItemStack)afterStack)) {
            this.updateRacks(afterStack);
        }
    }

    @NotNull
    public ItemStack quickMoveStack(Player playerIn, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (slot == null || !slot.hasItem()) {
            return ItemStackUtils.EMPTY;
        }
        ItemStack stackCopy = slot.getItem().copy();
        int maxIndex = this.inventorySize * 9;
        if (index < maxIndex ? !this.moveItemStackTo(stackCopy, maxIndex, this.slots.size(), true) : !this.moveItemStackTo(stackCopy, 0, maxIndex, false)) {
            return ItemStackUtils.EMPTY;
        }
        if (ItemStackUtils.getSize(stackCopy) == 0) {
            slot.set(ItemStackUtils.EMPTY);
        } else {
            slot.set(stackCopy);
            slot.setChanged();
        }
        if (playerIn instanceof ServerPlayer) {
            this.updateRacks(stackCopy);
        }
        return stackCopy;
    }

    protected boolean moveItemStackTo(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        ItemStack before = stack.copy();
        boolean merge = super.moveItemStackTo(stack, startIndex, endIndex, reverseDirection);
        if (merge) {
            this.updateRacks(before);
        }
        return merge;
    }

    private void updateRacks(ItemStack stack) {
        this.rack.updateItemStorage();
        this.rack.updateWarehouseIfAvailable(stack);
        if (this.neighborRack != null) {
            this.neighborRack.updateItemStorage();
            this.neighborRack.updateWarehouseIfAvailable(stack);
        }
    }

    public boolean stillValid(Player playerIn) {
        return true;
    }
}

