/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.inventory.container;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.inventory.ModContainers;
import com.minecolonies.api.util.ItemStackUtils;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.FurnaceResultSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class ContainerCraftingFurnace
extends AbstractContainerMenu {
    private final IItemHandler furnaceInventory;
    private final Inventory playerInventory;
    public final BlockPos buildingPos;
    private int moduleId;

    public static ContainerCraftingFurnace fromFriendlyByteBuf(int windowId, Inventory inv, RegistryFriendlyByteBuf packetBuffer) {
        BlockPos tePos = packetBuffer.readBlockPos();
        int moduleId = packetBuffer.readInt();
        return new ContainerCraftingFurnace(windowId, inv, tePos, moduleId);
    }

    public ContainerCraftingFurnace(int windowId, Inventory inv, BlockPos pos, int moduleId) {
        super((MenuType)ModContainers.craftingFurnace.get(), windowId);
        int i;
        this.moduleId = moduleId;
        this.furnaceInventory = new IItemHandlerModifiable(this){
            ItemStack input = ItemStack.EMPTY;
            ItemStack output = ItemStack.EMPTY;

            public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
                ItemStack copy = stack.copy();
                copy.setCount(1);
                if (slot == 0) {
                    this.input = copy;
                } else {
                    this.output = copy;
                }
            }

            public int getSlots() {
                return 3;
            }

            @Nonnull
            public ItemStack getStackInSlot(int slot) {
                if (slot == 0) {
                    return this.input;
                }
                return this.output;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                ItemStack copy = stack.copy();
                copy.setCount(1);
                if (slot == 0) {
                    this.input = copy;
                } else {
                    this.output = copy;
                }
                return stack;
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.EMPTY;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot == 0) {
                    return !IMinecoloniesAPI.getInstance().getFurnaceRecipes().getSmeltingResult(stack).isEmpty();
                }
                return false;
            }
        };
        this.playerInventory = inv;
        this.buildingPos = pos;
        this.addSlot((Slot)new SlotItemHandler(this, this.furnaceInventory, 0, 56, 17){

            public int getMaxStackSize() {
                return 1;
            }

            @NotNull
            public ItemStack remove(int par1) {
                return ItemStack.EMPTY;
            }

            public boolean mayPlace(ItemStack par1ItemStack) {
                return true;
            }

            public boolean mayPickup(Player par1PlayerEntity) {
                return false;
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this.furnaceInventory, 1, 116, 35));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)this.playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)this.playerInventory, i, 8 + i * 18, 142));
        }
    }

    public void clicked(int slotId, int clickedButton, ClickType mode, Player playerIn) {
        if (slotId >= 0 && slotId < 2) {
            if (mode == ClickType.PICKUP || mode == ClickType.PICKUP_ALL || mode == ClickType.SWAP) {
                Slot slot = (Slot)this.slots.get(slotId);
                this.handleSlotClick(slot, this.getCarried());
            }
        } else {
            super.clicked(slotId, clickedButton, mode, this.playerInventory.player);
        }
        this.updateFurnaceOutput();
    }

    public void setFurnaceInput(ItemStack stack) {
        this.handleSlotClick(this.getSlot(0), stack);
        this.updateFurnaceOutput();
    }

    private ItemStack handleSlotClick(Slot slot, ItemStack stack) {
        if (stack.getCount() > 0) {
            ItemStack copy = stack.copy();
            copy.setCount(1);
            slot.set(copy);
        } else if (slot.getItem().getCount() > 0) {
            slot.set(ItemStack.EMPTY);
        }
        return slot.getItem().copy();
    }

    private void updateFurnaceOutput() {
        if (!this.playerInventory.player.level().isClientSide) {
            ServerPlayer player = (ServerPlayer)this.playerInventory.player;
            ItemStack result = IMinecoloniesAPI.getInstance().getFurnaceRecipes().getSmeltingResult(this.furnaceInventory.getStackInSlot(0));
            this.furnaceInventory.insertItem(1, result, false);
            player.connection.send((Packet)new ClientboundContainerSetSlotPacket(this.containerId, 0, 1, result));
        }
    }

    public boolean stillValid(@NotNull Player playerIn) {
        return true;
    }

    @NotNull
    public ItemStack quickMoveStack(Player playerIn, int index) {
        if (index <= 2) {
            return ItemStack.EMPTY;
        }
        ItemStack itemstack = ItemStackUtils.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index == 0) {
                if (!this.moveItemStackTo(itemstack1, 2, 38, true)) {
                    return ItemStackUtils.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (index < 32) {
                if (!this.moveItemStackTo(itemstack1, 32, 38, false)) {
                    return ItemStackUtils.EMPTY;
                }
            } else if (index < 38 && !this.moveItemStackTo(itemstack1, 2, 32, false) || !this.moveItemStackTo(itemstack1, 2, 38, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.getCount() == 0) {
                slot.set(ItemStackUtils.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStackUtils.EMPTY;
            }
        }
        return itemstack;
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slotIn) {
        return !(slotIn instanceof FurnaceResultSlot) && super.canTakeItemForPickAll(stack, slotIn);
    }

    public Player getPlayer() {
        return this.playerInventory.player;
    }

    public Level getWorldObj() {
        return this.playerInventory.player.level();
    }

    public BlockPos getPos() {
        return this.buildingPos;
    }

    public int getModuleId() {
        return this.moduleId;
    }
}

