/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.eventbus;

import com.minecolonies.api.eventbus.EventBus;
import com.minecolonies.api.eventbus.IModEvent;
import com.minecolonies.api.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DefaultEventBus
implements EventBus {
    private final Map<Class<? extends IModEvent>, List<EventBus.EventHandler<? extends IModEvent>>> eventHandlersPerType = new HashMap<Class<? extends IModEvent>, List<EventBus.EventHandler<? extends IModEvent>>>();

    @Override
    public <T extends IModEvent> void subscribe(@NotNull Class<T> eventType, @NotNull EventBus.EventHandler<T> handler) {
        Log.getLogger().debug("Registering event handler for id {}.", (Object)eventType.getSimpleName());
        this.eventHandlersPerType.computeIfAbsent(eventType, f -> new ArrayList()).add(handler);
    }

    @Override
    public void post(@NotNull IModEvent event) {
        List<EventBus.EventHandler<? extends IModEvent>> eventHandlers = this.eventHandlersPerType.get(event.getClass());
        if (eventHandlers == null) {
            return;
        }
        Log.getLogger().debug("Sending event '{}' for type '{}'. Sending to {} handlers.", (Object)event.getEventId(), (Object)event.getClass().getSimpleName(), (Object)eventHandlers.size());
        for (EventBus.EventHandler<? extends IModEvent> handler : eventHandlers) {
            try {
                handler.apply(event);
            }
            catch (Exception ex) {
                Log.getLogger().warn("Sending event '{}' for type '{}'. Error occurred in handler:", (Object)event.getEventId(), (Object)event.getClass().getSimpleName(), (Object)ex);
            }
        }
    }
}

