/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.ai.workers.util;

import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.ItemStackUtils;
import java.util.function.Predicate;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;

public class GuardGear
implements Predicate<ItemStack> {
    private final int minLevelRequired;
    private final int maxLevelRequired;
    private final int minArmorLevel;
    private final int maxArmorLevel;
    private final int minBuildingLevelRequired;
    private final int maxBuildingLevelRequired;
    private final EquipmentSlot type;
    private final EquipmentTypeEntry itemNeeded;

    public GuardGear(EquipmentTypeEntry item, EquipmentSlot type, int minArmorLevel, int maxArmorLevel, Tuple<Integer, Integer> citizenLevelRange, Tuple<Integer, Integer> buildingLevelRange) {
        this.type = type;
        this.itemNeeded = item;
        this.minLevelRequired = (Integer)citizenLevelRange.getA();
        this.maxLevelRequired = (Integer)citizenLevelRange.getB();
        this.minArmorLevel = minArmorLevel;
        this.maxArmorLevel = maxArmorLevel;
        this.minBuildingLevelRequired = (Integer)buildingLevelRange.getA();
        this.maxBuildingLevelRequired = (Integer)buildingLevelRange.getB();
    }

    public int getMinLevelRequired() {
        return this.minLevelRequired;
    }

    public int getMaxLevelRequired() {
        return this.maxLevelRequired;
    }

    public EquipmentSlot getType() {
        return this.type;
    }

    public int getMinArmorLevel() {
        return this.minArmorLevel;
    }

    public int getMaxArmorLevel() {
        return this.maxArmorLevel;
    }

    public EquipmentTypeEntry getItemNeeded() {
        return this.itemNeeded;
    }

    public int getMinBuildingLevelRequired() {
        return this.minBuildingLevelRequired;
    }

    public int getMaxBuildingLevelRequired() {
        return this.maxBuildingLevelRequired;
    }

    @Override
    public boolean test(ItemStack stack) {
        return ItemStackUtils.hasEquipmentLevel(stack, this.itemNeeded, this.minArmorLevel, this.maxArmorLevel) && stack.getItem() instanceof ArmorItem && ((ArmorItem)stack.getItem()).getEquipmentSlot() == this.getType() || stack.getItem() instanceof SwordItem && this.getType() == EquipmentSlot.MAINHAND || stack.getItem() instanceof ShieldItem && this.getType() == EquipmentSlot.OFFHAND;
    }
}

