/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.ai.combat.threat;

import com.minecolonies.api.entity.ai.combat.threat.IThreatTableEntity;
import com.minecolonies.api.entity.ai.combat.threat.ThreatTableEntry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;

public class ThreatTable<T extends LivingEntity> {
    private static final int MELEE_RANGE = 8;
    private static final int MAX_TRACKING_TICKS = 2400;
    private static final int MAX_DIST_THREAT = 7;
    private static final int MAX_HEALTH_THREAT = 2;
    private List<ThreatTableEntry> threatList = new ArrayList<ThreatTableEntry>();
    private int currentTargetIndex = 0;
    private final T owner;

    public ThreatTable(T owner) {
        this.owner = owner;
    }

    public void addThreat(LivingEntity attacker, int additionalThreat) {
        ThreatTableEntry threatTableEntry = null;
        int index = this.threatList.size();
        for (int i = 0; i < index; ++i) {
            ThreatTableEntry entry = this.threatList.get(i);
            if (entry.getEntity() != attacker) continue;
            threatTableEntry = entry;
            index = i;
            break;
        }
        if (threatTableEntry == null) {
            threatTableEntry = new ThreatTableEntry(attacker);
            this.threatList.add(threatTableEntry);
            threatTableEntry.addThreat(Math.max(0, 7 - this.owner.blockPosition().distManhattan((Vec3i)attacker.blockPosition()) / 4));
            threatTableEntry.addThreat((int)Math.max(0.0f, 2.0f - 3.0f * (attacker.getHealth() / attacker.getMaxHealth())));
        }
        threatTableEntry.addThreat(additionalThreat);
        this.adaptTableToThreat(index);
    }

    public int getThreatFor(LivingEntity attacker) {
        Object threatTableEntry = null;
        int index = this.threatList.size();
        for (int i = 0; i < index; ++i) {
            ThreatTableEntry entry = this.threatList.get(i);
            if (entry.getEntity() != attacker) continue;
            return entry.getThreat();
        }
        return -1;
    }

    private void adaptTableToThreat(int index) {
        for (int i = index; i > 0; --i) {
            ThreatTableEntry current = this.threatList.get(i);
            ThreatTableEntry above = this.threatList.get(i - 1);
            if (current.getThreat() <= above.getThreat()) break;
            if (this.currentTargetIndex == i - 1) {
                this.currentTargetIndex = i;
            }
            this.threatList.set(i, above);
            this.threatList.set(i - 1, current);
        }
    }

    public ThreatTableEntry getTarget() {
        if (this.threatList.isEmpty()) {
            return null;
        }
        ThreatTableEntry current = this.threatList.get(this.currentTargetIndex);
        ThreatTableEntry top = this.threatList.get(0);
        if (top.getThreat() > current.getThreat()) {
            if (top.getEntity().distanceToSqr(this.owner) > 8.0) {
                if ((double)top.getThreat() > (double)current.getThreat() * 1.3) {
                    this.currentTargetIndex = 0;
                    current = top;
                }
            } else if ((double)top.getThreat() > (double)current.getThreat() * 1.1) {
                this.currentTargetIndex = 0;
                current = top;
            }
        }
        if (Math.abs(this.owner.level().getGameTime() - current.getLastSeen()) > 2400L || !current.getEntity().isAlive()) {
            this.removeCurrentTarget();
            return this.getTarget();
        }
        if (current.getThreat() < 0) {
            return null;
        }
        if (current instanceof IThreatTableEntity) {
            IThreatTableEntity threatTableEntity = (IThreatTableEntity)((Object)current);
            if (threatTableEntity.getThreatTable().threatList.isEmpty()) {
                threatTableEntity.getThreatTable().addThreat((LivingEntity)this.owner, 0);
            }
        }
        return current;
    }

    public LivingEntity getTargetMob() {
        ThreatTableEntry entry = this.getTarget();
        if (entry == null) {
            return null;
        }
        return entry.getEntity();
    }

    public void resetCurrentTargetThreat() {
        ThreatTableEntry entry = this.threatList.get(this.currentTargetIndex);
        if (entry.getThreat() > 0) {
            entry.setThreat(0);
            this.threatList.remove(this.currentTargetIndex);
            this.currentTargetIndex = 0;
            this.threatList.add(entry);
        }
    }

    public void markInvalidTarget() {
        if (this.threatList.isEmpty()) {
            return;
        }
        ThreatTableEntry entry = this.threatList.get(this.currentTargetIndex);
        if (!entry.getEntity().isAlive()) {
            this.removeCurrentTarget();
            return;
        }
        if (entry.getThreat() != -1) {
            entry.setThreat(-1);
            this.threatList.remove(this.currentTargetIndex);
            this.currentTargetIndex = 0;
            this.threatList.add(entry);
        }
    }

    public void removeCurrentTarget() {
        if (this.threatList.isEmpty()) {
            return;
        }
        this.threatList.remove(this.currentTargetIndex);
        this.currentTargetIndex = 0;
    }

    public void resetTable() {
        this.threatList = new ArrayList<ThreatTableEntry>();
        this.currentTargetIndex = 0;
    }
}

