/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.crafting;

import com.google.common.collect.ImmutableList;
import com.ldtteam.structurize.items.ModItems;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.AbstractRecipeType;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ImmutableItemStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.ModRecipeTypes;
import com.minecolonies.api.crafting.registry.RecipeTypeEntry;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecipeStorage
implements IRecipeStorage {
    private final AbstractRecipeType<IRecipeStorage> recipeType;
    private final ResourceLocation recipeSource;
    @NotNull
    private final List<ItemStorage> input;
    @NotNull
    private final List<ItemStorage> cleanedInput = new ArrayList<ItemStorage>();
    @NotNull
    private final ItemStack primaryOutput;
    @NotNull
    private final List<ItemStack> alternateOutputs;
    @NotNull
    private final List<ItemStack> secondaryOutputs = new ArrayList<ItemStack>();
    @NotNull
    private final List<ItemStack> tools = new ArrayList<ItemStack>();
    private final Block intermediate;
    private final int gridSize;
    private final IToken<?> token;
    private final ResourceKey<LootTable> lootTable;
    private final EquipmentTypeEntry requiredTool;
    private int hash = 0;
    private LootTable loot;
    public static final LootContextParamSet recipeLootParameters = new LootContextParamSet.Builder().required(LootContextParams.ORIGIN).required(LootContextParams.THIS_ENTITY).required(LootContextParams.TOOL).optional(LootContextParams.DAMAGE_SOURCE).optional(LootContextParams.ATTACKING_ENTITY).optional(LootContextParams.DIRECT_ATTACKING_ENTITY).build();

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(@NotNull IRecipeStorage recipe) {
        return new Builder(recipe);
    }

    private RecipeStorage(@NotNull Builder builder) {
        this.input = Collections.unmodifiableList(builder.input);
        this.primaryOutput = builder.primaryOutput;
        this.alternateOutputs = !builder.alternateOutputs.isEmpty() ? builder.alternateOutputs : ImmutableList.of();
        this.gridSize = builder.gridSize;
        this.intermediate = builder.intermediate;
        this.token = builder.token == null ? StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN) : builder.token;
        this.recipeSource = builder.recipeSource;
        this.lootTable = builder.lootTable;
        this.requiredTool = builder.requiredTool;
        ResourceLocation type = builder.recipeType != null ? builder.recipeType : (builder.alternateOutputs.isEmpty() ? ModRecipeTypes.CLASSIC_ID : ModRecipeTypes.MULTI_OUTPUT_ID);
        Registry<RecipeTypeEntry> recipeTypes = MinecoloniesAPIProxy.getInstance().getRecipeTypeRegistry();
        this.recipeType = ((RecipeTypeEntry)recipeTypes.get(type)).getHandlerProducer().apply(this);
        this.processInputsAndTools(builder.secondaryOutputs);
    }

    private void processInputsAndTools(@Nullable List<ItemStack> secOutputs) {
        this.cleanedInput.clear();
        this.tools.clear();
        this.secondaryOutputs.clear();
        if (secOutputs != null) {
            for (ItemStack secOutput : secOutputs) {
                if (secOutput.isEmpty() || secOutput.getItem() == ModItems.buildTool.get()) continue;
                this.secondaryOutputs.add(secOutput);
            }
        }
        ArrayList<ItemStorage> items = new ArrayList<ItemStorage>();
        for (ItemStorage input : this.input) {
            ItemStorage storage;
            ItemStorage inputItem = input;
            if (inputItem.isEmpty() || inputItem.getItem() == ModItems.buildTool.get()) continue;
            ItemStack container = inputItem.getItemStack().getCraftingRemainingItem();
            if (secOutputs == null && !ItemStackUtils.isEmpty(container)) {
                container.setCount(inputItem.getAmount());
                this.secondaryOutputs.add(container);
            }
            for (ItemStack result : this.secondaryOutputs) {
                if (!ItemStackUtils.compareItemStacksIgnoreStackSize(inputItem.getItemStack(), result, false, true)) continue;
                inputItem = new ItemStorage(inputItem.getItemStack(), inputItem.getAmount(), true, inputItem.shouldIgnoreNBTValue);
                this.tools.add(result);
                this.secondaryOutputs.remove(result);
                break;
            }
            if (items.contains(storage = inputItem.copy())) {
                int index = items.indexOf(storage);
                ItemStorage tempStorage = (ItemStorage)items.remove(index);
                tempStorage.setAmount(tempStorage.getAmount() + storage.getAmount());
                if (!tempStorage.matchDefinitionEquals(storage)) {
                    int amount = tempStorage.getAmount();
                    tempStorage = new ItemStorage(tempStorage.getItemStack(), tempStorage.ignoreDamageValue() || storage.ignoreDamageValue(), tempStorage.ignoreNBT() || storage.ignoreNBT());
                    tempStorage.setAmount(amount);
                }
                storage = tempStorage;
            }
            items.add(storage);
        }
        for (ItemStorage storage : items) {
            this.cleanedInput.add(new ImmutableItemStorage(storage));
        }
    }

    @Override
    public List<ItemStorage> getInput() {
        return new ArrayList<ItemStorage>(this.input);
    }

    @Override
    @NotNull
    public List<ItemStorage> getCleanedInput() {
        return this.cleanedInput;
    }

    @Override
    @NotNull
    public ItemStack getPrimaryOutput() {
        return this.primaryOutput;
    }

    @Override
    public int getGridSize() {
        return this.gridSize;
    }

    @Override
    public Block getIntermediate() {
        return this.intermediate;
    }

    @Override
    public boolean canFullFillRecipe(int qty, Map<ItemStorage, Integer> existingRequirements, IItemHandler ... inventories) {
        List<ItemStorage> items = this.getCleanedInput();
        for (ItemStorage storage : items) {
            ItemStack stack = storage.getItemStack();
            int availableCount = InventoryUtils.getItemCountInItemHandlers((Collection<IItemHandler>)ImmutableList.copyOf((Object[])inventories), itemStack -> !ItemStackUtils.isEmpty(itemStack) && ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, stack, false, !storage.ignoreNBT()));
            if (this.canFulfillItemStorage(qty, existingRequirements, availableCount, storage)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canFullFillRecipe(int qty, Map<ItemStorage, Integer> existingRequirements, @NotNull List<IItemHandler> citizen, @NotNull IBuilding building) {
        List<ItemStorage> items = this.getCleanedInput();
        for (ItemStorage storage : items) {
            ItemStack stack = storage.getItemStack();
            int availableCount = InventoryUtils.getItemCountInItemHandlers(citizen, itemStack -> !ItemStackUtils.isEmpty(itemStack) && ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, stack, false, !storage.ignoreNBT())) + InventoryUtils.getCountFromBuilding(building, storage);
            if (this.canFulfillItemStorage(qty, existingRequirements, availableCount, storage)) continue;
            return false;
        }
        return true;
    }

    private boolean canFulfillItemStorage(int qty, Map<ItemStorage, Integer> existingRequirements, int availableCount, ItemStorage storage) {
        ItemStack container;
        ItemStack stack = storage.getItemStack();
        int neededCount = !this.secondaryOutputs.isEmpty() || !this.tools.isEmpty() ? (!ItemStackUtils.compareItemStackListIgnoreStackSize(this.getCraftingToolsAndSecondaryOutputs(), stack, false, !storage.ignoreNBT()) ? storage.getAmount() * qty : storage.getAmount()) : (ItemStackUtils.isEmpty(container = stack.getCraftingRemainingItem()) || !ItemStackUtils.compareItemStacksIgnoreStackSize(stack, container, false, !storage.ignoreNBT()) ? storage.getAmount() * qty : storage.getAmount());
        return availableCount >= neededCount + existingRequirements.getOrDefault(storage, 0);
    }

    public boolean equals(Object o) {
        ItemStack right;
        ItemStack left;
        int i;
        if (this == o) {
            return true;
        }
        if (!(o instanceof RecipeStorage)) {
            return false;
        }
        RecipeStorage that = (RecipeStorage)o;
        if (!(this.gridSize == that.gridSize && this.cleanedInput.size() == that.cleanedInput.size() && this.alternateOutputs.size() == that.alternateOutputs.size() && this.secondaryOutputs.size() == that.secondaryOutputs.size() && this.requiredTool == that.requiredTool && this.tools.size() == that.tools.size() && Objects.equals(this.recipeSource, that.recipeSource) && Objects.equals(this.lootTable, that.lootTable) && this.recipeType.getId().equals((Object)that.recipeType.getId()) && ItemStackUtils.compareItemStacksIgnoreStackSize(this.primaryOutput, that.primaryOutput, false, true))) {
            return false;
        }
        for (i = 0; i < this.cleanedInput.size(); ++i) {
            if (this.cleanedInput.get(i).equals(that.cleanedInput.get(i)) && this.cleanedInput.get(i).matchDefinitionEquals(that.cleanedInput.get(i)) && this.cleanedInput.get(i).getAmount() == that.cleanedInput.get(i).getAmount()) continue;
            return false;
        }
        for (i = 0; i < this.alternateOutputs.size(); ++i) {
            left = this.alternateOutputs.get(i);
            if (ItemStackUtils.compareItemStacksIgnoreStackSize(left, right = that.alternateOutputs.get(i), false, true) && left.getCount() == right.getCount()) continue;
            return false;
        }
        for (i = 0; i < this.secondaryOutputs.size(); ++i) {
            left = this.secondaryOutputs.get(i);
            if (ItemStackUtils.compareItemStacksIgnoreStackSize(left, right = that.secondaryOutputs.get(i), false, true) && left.getCount() == right.getCount()) continue;
            return false;
        }
        for (i = 0; i < this.tools.size(); ++i) {
            left = this.tools.get(i);
            if (ItemStackUtils.compareItemStacksIgnoreStackSize(left, right = that.tools.get(i), false, true) && left.getCount() == right.getCount()) continue;
            return false;
        }
        return Objects.equals(this.intermediate, that.intermediate);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Objects.hash(this.cleanedInput, this.primaryOutput.getItem(), this.primaryOutput.getCount(), this.intermediate, this.gridSize, this.requiredTool, this.hashableItemStackList(this.alternateOutputs), this.hashableItemStackList(this.secondaryOutputs), this.hashableItemStackList(this.tools));
        }
        return this.hash;
    }

    private Map<Item, Integer> hashableItemStackList(List<ItemStack> items) {
        HashMap<Item, Integer> hashableList = new HashMap<Item, Integer>();
        for (ItemStack item : items) {
            hashableList.put(item.getItem(), item.getCount());
        }
        return hashableList;
    }

    private boolean checkForFreeSpace(List<IItemHandler> handlers) {
        ArrayList<ItemStack> resultStacks = new ArrayList<ItemStack>();
        if (!this.secondaryOutputs.isEmpty() && !ItemStackUtils.isEmpty(this.getPrimaryOutput())) {
            resultStacks.addAll(this.secondaryOutputs);
        } else {
            for (ItemStorage stack : this.input) {
                ItemStack container = stack.getItemStack().getCraftingRemainingItem();
                if (ItemStackUtils.isEmpty(container)) continue;
                container.setCount(stack.getAmount());
                resultStacks.add(container);
            }
        }
        resultStacks.add(this.getPrimaryOutput());
        if (resultStacks.size() > this.getInput().size()) {
            int freeSpace = 0;
            for (IItemHandler handler : handlers) {
                freeSpace += handler.getSlots() - InventoryUtils.getAmountOfStacksInItemHandler(handler);
            }
            return freeSpace >= resultStacks.size() - this.getInput().size();
        }
        return true;
    }

    @Override
    public List<ItemStack> fullfillRecipeAndCopy(LootParams context, List<IItemHandler> handlers, boolean doInsert) {
        if (!this.checkForFreeSpace(handlers) || !this.canFullFillRecipe(1, Collections.emptyMap(), handlers.toArray(new IItemHandler[0]))) {
            return null;
        }
        AbstractEntityCitizen citizen = (AbstractEntityCitizen)context.getParamOrNull(LootContextParams.THIS_ENTITY);
        for (ItemStorage storage : this.getCleanedInput()) {
            ItemStack stack = storage.getItemStack();
            int amountNeeded = storage.getAmount();
            if (amountNeeded == 0) break;
            for (IItemHandler handler : handlers) {
                boolean isTool = ItemStackUtils.compareItemStackListIgnoreStackSize(this.tools, stack, false, !storage.ignoreNBT());
                int slotOfStack = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith(handler, itemStack -> ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, stack, false, !storage.ignoreNBT()) && (!isTool || !stack.isDamageableItem() || ItemStackUtils.getDurability(itemStack) > 0));
                while (slotOfStack != -1 && amountNeeded > 0) {
                    if (citizen != null && isTool) {
                        if (stack.isDamageableItem()) {
                            ItemStack toDamage = handler.extractItem(slotOfStack, 1, false);
                            if (!ItemStackUtils.isEmpty(toDamage)) {
                                toDamage.hurtAndBreak(toDamage.getItem().damageItem(stack, 1, (LivingEntity)citizen, item -> {}), (LivingEntity)citizen, EquipmentSlot.MAINHAND);
                            }
                            if (!ItemStackUtils.isEmpty(toDamage)) {
                                handler.insertItem(slotOfStack, toDamage, false);
                            }
                        }
                        --amountNeeded;
                        continue;
                    }
                    int count = ItemStackUtils.getSize(handler.getStackInSlot(slotOfStack));
                    ItemStack extractedStack = handler.extractItem(slotOfStack, amountNeeded, false).copy();
                    if (ItemStackUtils.isEmpty(extractedStack)) {
                        handler.insertItem(slotOfStack, extractedStack, false);
                        return null;
                    }
                    if ((amountNeeded -= count) <= 0) continue;
                    slotOfStack = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith(handler, itemStack -> !ItemStackUtils.isEmpty(itemStack) && ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, stack, false, !storage.ignoreNBT()));
                }
                if (amountNeeded > 0) continue;
                break;
            }
            if (amountNeeded <= 0) continue;
            return null;
        }
        return this.insertCraftedItems(handlers, this.getPrimaryOutput(), context, doInsert);
    }

    @Override
    public IToken<?> getToken() {
        return this.token;
    }

    private List<ItemStack> insertCraftedItems(List<IItemHandler> handlers, ItemStack outputStack, LootParams context, boolean doInsert) {
        ArrayList<ItemStack> resultStacks = new ArrayList<ItemStack>();
        ArrayList<ItemStack> secondaryStacks = new ArrayList<ItemStack>();
        if (!ItemStackUtils.isEmpty(outputStack)) {
            resultStacks.add(outputStack.copy());
            if (doInsert) {
                for (IItemHandler handler : handlers) {
                    if (InventoryUtils.addItemStackToItemHandler(handler, outputStack.copy())) break;
                }
            }
            secondaryStacks.addAll(this.secondaryOutputs);
        }
        if (this.loot == null && this.lootTable != null) {
            this.loot = context.getLevel().getServer().reloadableRegistries().getLootTable(this.lootTable);
        }
        if (this.loot != null && context != null) {
            secondaryStacks.addAll((Collection<ItemStack>)this.loot.getRandomItems(context));
        }
        resultStacks.addAll(secondaryStacks.stream().map(ItemStack::copy).collect(Collectors.toList()));
        if (doInsert) {
            for (ItemStack stack : secondaryStacks) {
                for (IItemHandler handler : handlers) {
                    if (InventoryUtils.addItemStackToItemHandler(handler, stack.copy())) break;
                }
            }
        }
        return Collections.unmodifiableList(resultStacks);
    }

    @Override
    public RecipeStorage getClassicForMultiOutput(ItemStack requiredOutput) {
        return RecipeStorage.builder(this).withPrimaryOutput(requiredOutput).withAlternateOutputs(List.of()).withRecipeType(ModRecipeTypes.CLASSIC_ID).build();
    }

    @Override
    public RecipeStorage getClassicForMultiOutput(Predicate<ItemStack> stackPredicate) {
        if (!this.getPrimaryOutput().isEmpty() && stackPredicate.test(this.getPrimaryOutput())) {
            return this.getClassicForMultiOutput(this.getPrimaryOutput());
        }
        for (ItemStack item : this.alternateOutputs) {
            if (!stackPredicate.test(item)) continue;
            return this.getClassicForMultiOutput(item);
        }
        return null;
    }

    @Override
    public AbstractRecipeType<IRecipeStorage> getRecipeType() {
        return this.recipeType;
    }

    @Override
    public ResourceLocation getRecipeSource() {
        return this.recipeSource;
    }

    @Override
    @NotNull
    public List<ItemStack> getAlternateOutputs() {
        return this.alternateOutputs;
    }

    @Override
    @NotNull
    public List<ItemStack> getCraftingToolsAndSecondaryOutputs() {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        results.addAll(this.tools);
        results.addAll(this.secondaryOutputs);
        return results;
    }

    @Override
    public ResourceKey<LootTable> getLootTable() {
        return this.lootTable;
    }

    @Override
    @NotNull
    public EquipmentTypeEntry getRequiredTool() {
        return this.requiredTool;
    }

    @Override
    @NotNull
    public List<ItemStack> getCraftingTools() {
        return ImmutableList.copyOf(this.tools);
    }

    @Override
    @NotNull
    public List<ItemStack> getSecondaryOutputs() {
        return ImmutableList.copyOf(this.secondaryOutputs);
    }

    public static class Builder {
        private ResourceLocation recipeType = null;
        private ResourceLocation recipeSource = null;
        @NotNull
        private List<ItemStorage> input = List.of();
        @NotNull
        private ItemStack primaryOutput = ItemStack.EMPTY;
        @NotNull
        private List<ItemStack> alternateOutputs = List.of();
        @NotNull
        private List<ItemStack> secondaryOutputs = List.of();
        private Block intermediate = Blocks.AIR;
        private int gridSize = 1;
        private IToken<?> token = null;
        private ResourceKey<LootTable> lootTable = null;
        private EquipmentTypeEntry requiredTool = (EquipmentTypeEntry)ModEquipmentTypes.none.get();

        public Builder() {
        }

        public Builder(@NotNull IRecipeStorage recipe) {
            this.recipeType = recipe.getRecipeType().getId();
            this.recipeSource = recipe.getRecipeSource();
            this.input = recipe.getInput();
            this.primaryOutput = recipe.getPrimaryOutput();
            this.alternateOutputs = recipe.getAlternateOutputs();
            this.secondaryOutputs = recipe.getCraftingToolsAndSecondaryOutputs();
            this.intermediate = recipe.getIntermediate();
            this.gridSize = recipe.getGridSize();
            this.token = null;
            this.lootTable = recipe.getLootTable();
            this.requiredTool = recipe.getRequiredTool();
        }

        public Builder withRecipeType(@Nullable ResourceLocation type) {
            this.recipeType = type;
            return this;
        }

        public Builder withRecipeId(@Nullable ResourceLocation id) {
            this.recipeSource = id;
            return this;
        }

        public Builder withInputs(@NotNull List<ItemStorage> inputs) {
            this.input = inputs;
            return this;
        }

        public Builder withPrimaryOutput(@NotNull ItemStack output) {
            this.primaryOutput = output;
            return this;
        }

        public Builder withAlternateOutputs(@NotNull List<ItemStack> outputs) {
            this.alternateOutputs = outputs;
            return this;
        }

        public Builder withSecondaryOutputs(@NotNull List<ItemStack> outputs) {
            this.secondaryOutputs = outputs;
            return this;
        }

        public Builder withIntermediate(@NotNull Block intermediate) {
            this.intermediate = intermediate;
            return this;
        }

        public Builder withGridSize(int gridSize) {
            this.gridSize = gridSize;
            return this;
        }

        public Builder withToken(@Nullable IToken<?> token) {
            this.token = token;
            return this;
        }

        public Builder withLootTable(@Nullable ResourceKey<LootTable> lootTable) {
            this.lootTable = lootTable;
            return this;
        }

        public Builder withRequiredTool(@NotNull EquipmentTypeEntry tool) {
            this.requiredTool = tool;
            return this;
        }

        public RecipeStorage build() {
            return new RecipeStorage(this);
        }
    }
}

