/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.modules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class ModuleContainerUtils {
    private ModuleContainerUtils() {
    }

    public static <T> boolean hasModule(Collection<T> modules, Class<? extends T> clazz) {
        for (T module : modules) {
            if (!clazz.isInstance(module)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static <T, T2 extends T> Optional<T2> getFirstOptionalModuleOccurance(Collection<T> modules, Class<T2> clazz) {
        for (T module : modules) {
            if (!clazz.isInstance(module)) continue;
            return Optional.of(module);
        }
        return Optional.empty();
    }

    @NotNull
    public static <T, T2 extends T> T2 getFirstModuleOccurance(Collection<T> modules, Class<T2> clazz, String errorMessage) {
        for (T module : modules) {
            if (!clazz.isInstance(module)) continue;
            return (T2)module;
        }
        throw new IllegalStateException(errorMessage);
    }

    @NotNull
    public static <T, T2 extends T> T2 getModuleMatching(Collection<T> modules, Class<T2> clazz, Predicate<? super T2> modulePredicate, String errorMessage) {
        for (T module : modules) {
            if (!clazz.isInstance(module) || !modulePredicate.test(module)) continue;
            return (T2)module;
        }
        throw new IllegalStateException(errorMessage);
    }

    @NotNull
    public static <T, T2 extends T> List<T2> getModules(Collection<T> modules, Class<T2> clazz) {
        ArrayList<T> result = new ArrayList<T>();
        for (T module : modules) {
            if (!clazz.isInstance(module)) continue;
            result.add(module);
        }
        return result;
    }
}

