/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.client.render.modeltype;

import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import org.jetbrains.annotations.NotNull;

public class CitizenModel<T extends AbstractEntityCitizen>
extends HumanoidModel<AbstractEntityCitizen> {
    private static final String RENDER_META_WORKING = "working";
    public static boolean isItApril1st = false;

    public CitizenModel(ModelPart part) {
        super(part, RenderType::entityCutoutNoCull);
    }

    public void setupAnim(@NotNull AbstractEntityCitizen citizen, float f1, float f2, float f3, float f4, float f5) {
        super.setupAnim((LivingEntity)citizen, f1, f2, f3, f4, f5);
        if (this.body.xRot == 0.0f) {
            this.body.xRot = this.getActualRotation(citizen);
        }
        if (this.head.xRot == 0.0f) {
            this.head.xRot = this.getActualRotation(citizen);
        }
        if (citizen.getCitizenDataView() != null && citizen.getCitizenDataView().getCustomTextureUUID() != null) {
            this.head.visible = false;
            this.hat.visible = false;
        } else {
            this.head.visible = true;
            this.hat.visible = true;
        }
        if (isItApril1st) {
            switch (citizen.getCivilianID() % 7) {
                case 0: {
                    this.leftArm.visible = false;
                    break;
                }
                case 1: {
                    this.rightArm.visible = false;
                    break;
                }
                case 2: {
                    this.body.visible = false;
                    break;
                }
                case 3: {
                    this.head.visible = false;
                    break;
                }
                case 4: {
                    this.hat.visible = false;
                    break;
                }
                case 5: {
                    this.leftLeg.visible = false;
                    break;
                }
                case 6: {
                    this.rightLeg.visible = false;
                }
            }
        }
    }

    public static LayerDefinition createMesh() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public float getActualRotation(@NotNull AbstractEntityCitizen entity) {
        return 0.0f;
    }

    public boolean isWorking(AbstractEntityCitizen citizen) {
        return citizen.getRenderMetadata().contains(RENDER_META_WORKING);
    }

    public boolean displayHat(AbstractEntityCitizen citizen) {
        if (citizen.getPose() == Pose.SLEEPING || !citizen.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
            return false;
        }
        return citizen.getCitizenDataView() == null || citizen.getCitizenDataView().getDisplayArmor(EquipmentSlot.HEAD).isEmpty() && citizen.getCitizenDataView().getCustomTextureUUID() == null;
    }
}

