/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.blocks.decorative;

import com.minecolonies.api.blocks.interfaces.IBlockMinecolonies;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.core.tileentities.TileEntityColonyFlag;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractColonyFlagBanner<B extends AbstractColonyFlagBanner<B>>
extends AbstractBannerBlock
implements IBlockMinecolonies<AbstractColonyFlagBanner<B>> {
    public static final String REGISTRY_NAME = "colony_banner";
    public static final String REGISTRY_NAME_WALL = "colony_wall_banner";

    public AbstractColonyFlagBanner(DyeColor dyeColor, BlockBehaviour.Properties properties) {
        super(dyeColor, properties);
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new TileEntityColonyFlag(blockPos, blockState);
    }

    public void setPlacedBy(Level worldIn, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        if (worldIn.isClientSide) {
            return;
        }
        BlockEntity te = worldIn.getBlockEntity(pos);
        if (te instanceof TileEntityColonyFlag) {
            TileEntityColonyFlag flagTileEntity = (TileEntityColonyFlag)te;
            IColony colony = IColonyManager.getInstance().getIColony(worldIn, pos);
            if (colony == null && placer instanceof Player) {
                colony = IColonyManager.getInstance().getIColonyByOwner(worldIn, (Player)placer);
            }
            if (colony != null) {
                flagTileEntity.colonyId = colony.getID();
            }
        }
    }

    @Override
    public AbstractColonyFlagBanner<B> registerBlock(Registry<Block> registry) {
        Registry.register(registry, (ResourceLocation)this.getRegistryName(), (Object)this);
        return this;
    }

    @Override
    public void registerBlockItem(Registry<Item> registry, Item.Properties properties) {
    }
}

