/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.advancements;

import com.minecolonies.api.advancements.AdvancementTriggers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;

public class ClickGuiButtonTrigger
extends SimpleCriterionTrigger<ClickGuiButtonTriggerInstance> {
    public void trigger(ServerPlayer player, String buttonId, String windowResource) {
        this.trigger(player, trigger -> trigger.test(buttonId, windowResource));
    }

    public Codec<ClickGuiButtonTriggerInstance> codec() {
        return ClickGuiButtonTriggerInstance.CODEC;
    }

    public record ClickGuiButtonTriggerInstance(Optional<ContextAwarePredicate> player, Optional<String> buttonId, Optional<String> windowResource) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<ClickGuiButtonTriggerInstance> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(ClickGuiButtonTriggerInstance::player), (App)Codec.STRING.optionalFieldOf("button_id").forGetter(ClickGuiButtonTriggerInstance::buttonId), (App)Codec.STRING.optionalFieldOf("window_resource_location").forGetter(ClickGuiButtonTriggerInstance::windowResource)).apply((Applicative)builder, ClickGuiButtonTriggerInstance::new));

        public static Criterion<ClickGuiButtonTriggerInstance> clickGuiButton() {
            return ClickGuiButtonTriggerInstance.clickGuiButton(null, null);
        }

        public static Criterion<ClickGuiButtonTriggerInstance> clickGuiButton(String buttonId) {
            return ClickGuiButtonTriggerInstance.clickGuiButton(buttonId, null);
        }

        public static Criterion<ClickGuiButtonTriggerInstance> clickGuiButton(String buttonId, String windowResource) {
            return ((ClickGuiButtonTrigger)((Object)AdvancementTriggers.CLICK_GUI_BUTTON.get())).createCriterion((CriterionTriggerInstance)new ClickGuiButtonTriggerInstance(Optional.empty(), Optional.ofNullable(buttonId), Optional.ofNullable(windowResource)));
        }

        public boolean test(String buttonId, String windowResource) {
            if (this.buttonId.isPresent() && this.windowResource.isPresent()) {
                return this.buttonId.get().equalsIgnoreCase(buttonId) && this.windowResource.get().equalsIgnoreCase(windowResource);
            }
            if (this.buttonId.isPresent()) {
                return this.buttonId.get().equalsIgnoreCase(buttonId);
            }
            return true;
        }
    }
}

