/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.render;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.su5ed.mffs.MFFSConfig;
import dev.su5ed.mffs.MFFSMod;
import dev.su5ed.mffs.render.ModRenderType;
import dev.su5ed.mffs.render.OffscreenRenderTarget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EffectInstance;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.joml.Matrix4f;

public final class RenderPostProcessor {
    public static final RenderStateShard.OutputStateShard GLITCH_TARGET = new RenderStateShard.OutputStateShard("mffs:glitch_target", () -> {
        if (enableGlitchEffect) {
            glitchRenderTarget.bindWrite(false);
            RenderSystem.depthMask((boolean)true);
        } else {
            ModRenderType.TRANSLUCENT_TARGET_NO_DEPTH_MASK.setupRenderState();
        }
    }, () -> {
        if (enableGlitchEffect) {
            Minecraft.getInstance().getMainRenderTarget().bindWrite(false);
        } else {
            ModRenderType.TRANSLUCENT_TARGET_NO_DEPTH_MASK.clearRenderState();
        }
    });
    private static final ResourceLocation NOISE_SEED = MFFSMod.location("textures/model/noise.png");
    static RenderTarget glitchRenderTarget;
    private static Matrix4f shaderOrthoMatrix;
    private static PostPass postProcessPass;
    private static boolean enableGlitchEffect;

    public static void initRenderTarget() {
        enableGlitchEffect = (Boolean)MFFSConfig.CLIENT.enableProjectorModeGlitch.get();
        if (enableGlitchEffect) {
            Minecraft minecraft = Minecraft.getInstance();
            RenderTarget mainRenderTarget = minecraft.getMainRenderTarget();
            Window window = minecraft.getWindow();
            glitchRenderTarget = new OffscreenRenderTarget(window.getWidth(), window.getHeight());
            glitchRenderTarget.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            shaderOrthoMatrix = new Matrix4f().setOrtho(0.0f, (float)mainRenderTarget.width, 0.0f, (float)mainRenderTarget.height, 0.1f, 1000.0f);
        }
    }

    public static void reloadPostProcessPass() {
        enableGlitchEffect = (Boolean)MFFSConfig.CLIENT.enableProjectorModeGlitch.get();
        if (enableGlitchEffect) {
            Minecraft minecraft = Minecraft.getInstance();
            RenderTarget mainRenderTarget = minecraft.getMainRenderTarget();
            if (postProcessPass != null) {
                postProcessPass.close();
            }
            try {
                postProcessPass = new PostPass((ResourceProvider)minecraft.getResourceManager(), "mffs:glitch_blit", glitchRenderTarget, mainRenderTarget, false);
                postProcessPass.setOrthoMatrix(shaderOrthoMatrix);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void resizeDisplay() {
        if (enableGlitchEffect) {
            Minecraft minecraft = Minecraft.getInstance();
            RenderTarget mainRenderTarget = minecraft.getMainRenderTarget();
            Window window = minecraft.getWindow();
            if (glitchRenderTarget != null) {
                glitchRenderTarget.resize(window.getWidth(), window.getHeight(), Minecraft.ON_OSX);
            }
            shaderOrthoMatrix = new Matrix4f().setOrtho(0.0f, (float)mainRenderTarget.width, 0.0f, (float)mainRenderTarget.height, 0.1f, 1000.0f);
            if (postProcessPass != null) {
                postProcessPass.setOrthoMatrix(shaderOrthoMatrix);
            }
        }
    }

    public static void prepareRender() {
        if (enableGlitchEffect) {
            glitchRenderTarget.clear(Minecraft.ON_OSX);
            Minecraft.getInstance().getMainRenderTarget().bindWrite(false);
        }
    }

    public static void process(int ticks) {
        if (enableGlitchEffect) {
            RenderPostProcessor.process(postProcessPass, ticks);
            Minecraft.getInstance().getMainRenderTarget().bindWrite(false);
        }
    }

    private static void process(PostPass pass, float time) {
        EffectInstance effect = pass.getEffect();
        Minecraft minecraft = Minecraft.getInstance();
        Window window = minecraft.getWindow();
        float width = pass.outTarget.width;
        float height = pass.outTarget.height;
        float farPlane = 500.0f;
        pass.inTarget.unbindWrite();
        RenderSystem.viewport((int)0, (int)0, (int)((int)width), (int)((int)height));
        effect.setSampler("DiffuseSampler", () -> ((RenderTarget)pass.inTarget).getColorTextureId());
        effect.setSampler("NoiseSampler", () -> minecraft.getTextureManager().getTexture(NOISE_SEED).getId());
        effect.setSampler("DepthSampler", () -> ((RenderTarget)pass.inTarget).getDepthTextureId());
        effect.safeGetUniform("ProjMat").set(shaderOrthoMatrix);
        effect.safeGetUniform("InSize").set((float)pass.inTarget.width, (float)pass.inTarget.height);
        effect.safeGetUniform("OutSize").set(width, height);
        effect.safeGetUniform("Time").set(time);
        effect.safeGetUniform("ScreenSize").set((float)window.getWidth(), (float)window.getHeight());
        effect.apply();
        pass.outTarget.bindWrite(false);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        bufferbuilder.addVertex(0.0f, 0.0f, farPlane);
        bufferbuilder.addVertex(width, 0.0f, farPlane);
        bufferbuilder.addVertex(width, height, farPlane);
        bufferbuilder.addVertex(0.0f, height, farPlane);
        BufferUploader.draw((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.disableDepthTest();
        effect.clear();
        pass.outTarget.unbindWrite();
        pass.inTarget.unbindRead();
    }

    private RenderPostProcessor() {
    }
}

