/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.su5ed.mffs.MFFSMod;
import dev.su5ed.mffs.blockentity.ProjectorBlockEntity;
import dev.su5ed.mffs.render.LazyRenderer;
import dev.su5ed.mffs.render.ModRenderType;
import dev.su5ed.mffs.render.RenderTickHandler;
import dev.su5ed.mffs.render.model.ProjectorRotorModel;
import dev.su5ed.mffs.setup.ModClientSetup;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class ProjectorRenderer
implements BlockEntityRenderer<ProjectorBlockEntity> {
    public static final ResourceLocation PROJECTOR_OFF_TEXTURE = MFFSMod.location("textures/model/projector_off.png");
    public static final ResourceLocation PROJECTOR_ON_TEXTURE = MFFSMod.location("textures/model/projector_on.png");
    private final ModelPart rotor;
    private final Function<ModelLayerLocation, ModelPart> modelPartCache;
    private final Function<BlockEntity, HoloRenderer> holoRenderer;

    public ProjectorRenderer(BlockEntityRendererProvider.Context context) {
        this.rotor = context.bakeLayer(ProjectorRotorModel.LAYER_LOCATION);
        this.modelPartCache = Util.memoize(arg_0 -> ((BlockEntityRendererProvider.Context)context).bakeLayer(arg_0));
        this.holoRenderer = Util.memoize(HoloRenderer::new);
    }

    public void render(ProjectorBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        this.renderRotor(blockEntity, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
        blockEntity.getMode().ifPresent(mode -> {
            RenderTickHandler.addTransparentRenderer(ModRenderType.STANDARD_TRANSLUCENT_TRIANGLE, this.holoRenderer.apply(blockEntity));
            ModClientSetup.renderLazy(blockEntity.getModeStack().getItem(), blockEntity, this.modelPartCache);
        });
    }

    private void renderRotor(ProjectorBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        ResourceLocation texture = blockEntity.isActive() ? PROJECTOR_ON_TEXTURE : PROJECTOR_OFF_TEXTURE;
        poseStack.pushPose();
        poseStack.translate(0.5, -0.75, 0.5);
        float activePartial = blockEntity.isActive() ? partialTick : 0.0f;
        poseStack.mulPose(Axis.YN.rotationDegrees(((float)blockEntity.getAnimation() + activePartial) * (float)blockEntity.getAnimationSpeed()));
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)texture));
        this.rotor.render(poseStack, buffer, packedLight, packedOverlay);
        poseStack.popPose();
    }

    private static class HoloRenderer
    implements LazyRenderer {
        private final BlockEntity be;
        private final Vec3 centerPos;

        public HoloRenderer(BlockEntity be) {
            this.be = be;
            this.centerPos = Vec3.atCenterOf((Vec3i)be.getBlockPos());
        }

        @Override
        public void render(PoseStack poseStack, VertexConsumer buffer, int ticks, float partialTick) {
            poseStack.pushPose();
            poseStack.translate(this.centerPos.x, this.centerPos.y, this.centerPos.z);
            Vec3 playerPos = Minecraft.getInstance().player.position();
            BlockPos bePos = this.be.getBlockPos();
            double xDifference = playerPos.x - ((double)bePos.getX() + 0.5);
            double zDifference = playerPos.z - ((double)bePos.getZ() + 0.5);
            float rotation = (float)Math.toDegrees(Math.atan2(zDifference, xDifference));
            poseStack.mulPose(Axis.YP.rotationDegrees(-rotation + 27.0f));
            float height = 2.0f;
            float width = 2.0f;
            Matrix4f mat = poseStack.last().pose();
            buffer.addVertex(mat, 0.0f, 0.0f, 0.0f).setColor(72, 198, 255, 255);
            buffer.addVertex(mat, -0.866f * width, height, -0.5f * width).setColor(0, 0, 0, 0);
            buffer.addVertex(mat, 0.866f * width, height, -0.5f * width).setColor(0, 0, 0, 0);
            buffer.addVertex(mat, 0.0f, 0.0f, 0.0f).setColor(72, 198, 255, 255);
            buffer.addVertex(mat, 0.866f * width, height, -0.5f * width).setColor(0, 0, 0, 0);
            buffer.addVertex(mat, 0.0f, height, width).setColor(0, 0, 0, 0);
            buffer.addVertex(mat, 0.0f, 0.0f, 0.0f).setColor(72, 198, 255, 255);
            buffer.addVertex(mat, 0.0f, height, width).setColor(0, 0, 0, 0);
            buffer.addVertex(mat, -0.866f * width, height, -0.5f * width).setColor(0, 0, 0, 0);
            poseStack.popPose();
        }

        @Override
        @Nullable
        public Vec3 centerPos() {
            return this.centerPos;
        }
    }
}

