/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.menu;

import dev.su5ed.mffs.blockentity.FortronBlockEntity;
import dev.su5ed.mffs.setup.ModItems;
import dev.su5ed.mffs.setup.ModObjects;
import dev.su5ed.mffs.util.DataSlotWrapper;
import dev.su5ed.mffs.util.ModUtil;
import dev.su5ed.mffs.util.inventory.InventorySlot;
import dev.su5ed.mffs.util.inventory.SlotInventory;
import dev.su5ed.mffs.util.inventory.SlotInventoryFilter;
import dev.su5ed.mffs.util.loot.MenuInventoryTrigger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;

public abstract class FortronMenu<T extends FortronBlockEntity>
extends AbstractContainerMenu {
    public final T blockEntity;
    protected final Player player;
    protected final IItemHandler playerInventory;
    private final IItemHandler itemHandler;
    private final List<Slot> hotBarSlots = new ArrayList<Slot>();
    private final List<Slot> playerInventorySlots = new ArrayList<Slot>();
    private final List<Slot> blockEntitySlots = new ArrayList<Slot>();
    private Runnable frequencyChangeListener;
    private boolean isRemoteAccess;

    protected FortronMenu(@Nullable MenuType<?> type, BlockEntityType<T> blockEntityType, int containerId, BlockPos pos, Player player, Inventory playerInventory) {
        super(type, containerId);
        this.player = player;
        this.blockEntity = (FortronBlockEntity)player.getCommandSenderWorld().getBlockEntity(pos, blockEntityType).orElseThrow();
        this.playerInventory = new InvWrapper((Container)playerInventory);
        this.trackPower();
        this.itemHandler = Objects.requireNonNull((IItemHandler)this.blockEntity.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, this.blockEntity.getBlockPos(), this.blockEntity.getBlockState(), this.blockEntity, null), "IItemHandler capability not found");
        this.addSlotListener(new AdvancementContainerListener());
    }

    protected Slot addInventorySlot(Slot slot) {
        Slot ret = this.addSlot(slot);
        this.blockEntitySlots.add(ret);
        return ret;
    }

    public void setRemoteAccess(boolean remoteAccess) {
        this.isRemoteAccess = remoteAccess;
    }

    public void setFrequencyChangeListener(Runnable frequencyChangeListener) {
        this.frequencyChangeListener = frequencyChangeListener;
    }

    public void triggerMenuAdvancement() {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            boolean active = ((FortronBlockEntity)this.blockEntity).isActive();
            ((MenuInventoryTrigger)((Object)ModObjects.MENU_INVENTORY_TRIGGER.get())).trigger(serverPlayer, active, this.itemHandler);
        }
    }

    public boolean stillValid(Player player) {
        return (Boolean)ContainerLevelAccess.create((Level)this.blockEntity.getLevel(), (BlockPos)this.blockEntity.getBlockPos()).evaluate((level, pos) -> (!this.isRemoteAccess || player.getItemInHand(InteractionHand.MAIN_HAND).is((Item)ModItems.REMOTE_CONTROLLER_ITEM.get())) && level.getBlockState(pos).is(this.blockEntity.getBlockState().getBlock()), (Object)true);
    }

    public void clicked(int slotId, int button, ClickType clickType, Player player) {
        if (slotId >= 0 && slotId < this.slots.size()) {
            Slot slot = this.getSlot(slotId);
            if (slot instanceof SlotInventoryFilter && clickType == ClickType.PICKUP) {
                ItemStack stack = this.getCarried();
                if (button == 0) {
                    slot.set(stack.copyWithCount(1));
                } else {
                    slot.set(ItemStack.EMPTY);
                }
                return;
            }
            this.triggerMenuAdvancement();
        }
        super.clicked(slotId, button, clickType, player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            stack = slotStack.copy();
            if (this.blockEntitySlots.contains(slot) ? !ModUtil.moveItemStackTo(slotStack, this.hotBarSlots) && !ModUtil.moveItemStackTo(slotStack, this.playerInventorySlots) : !ModUtil.moveItemStackTo(slotStack, this.blockEntitySlots)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return stack;
    }

    protected void layoutPlayerInventorySlots(int x, int y) {
        TriFunction factory = (index, slotX, slotY) -> new SlotItemHandler(this.playerInventory, index.intValue(), slotX.intValue(), slotY.intValue());
        this.playerInventorySlots.addAll(this.addSlotBox(9, x, y, 9, 18, 3, 18, (TriFunction<Integer, Integer, Integer, Slot>)factory));
        this.hotBarSlots.addAll(this.addSlotRange(0, x, y += 58, 9, 18, (TriFunction<Integer, Integer, Integer, Slot>)factory));
    }

    protected void addInventorySlotBox(int x, int y, int horAmount, int verAmount, List<InventorySlot> slots) {
        this.blockEntitySlots.addAll(this.addSlotBox(x, y, horAmount, verAmount, slots));
    }

    protected List<Slot> addSlotBox(int x, int y, int horAmount, int verAmount, List<InventorySlot> slots) {
        return this.addSlotBox(0, x, y, horAmount, 18, verAmount, 18, (TriFunction<Integer, Integer, Integer, Slot>)((TriFunction)(idx, slotX, slotY) -> new SlotInventory((InventorySlot)slots.get((int)idx), (int)slotX, (int)slotY)));
    }

    protected List<Slot> addSlotBox(int index, int x, int y, int horAmount, int dx, int verAmount, int dy, TriFunction<Integer, Integer, Integer, Slot> factory) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int j = 0; j < verAmount; ++j) {
            slots.addAll(this.addSlotRange(index, x, y, horAmount, dx, factory));
            index += horAmount;
            y += dy;
        }
        return slots;
    }

    protected void addInventorySlotRange(int index, int x, int y, int amount, int dx, TriFunction<Integer, Integer, Integer, Slot> factory) {
        this.blockEntitySlots.addAll(this.addSlotRange(index, x, y, amount, dx, factory));
    }

    protected List<Slot> addSlotRange(int index, int x, int y, int amount, int dx, TriFunction<Integer, Integer, Integer, Slot> factory) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        int i = 0;
        while (i < amount) {
            slots.add(this.addSlot((Slot)factory.apply((Object)index, (Object)x, (Object)y)));
            ++i;
            x += dx;
            ++index;
        }
        return slots;
    }

    private void trackPower() {
        this.addIntDataSlot(((FortronBlockEntity)this.blockEntity).fortronStorage::getStoredFortron, ((FortronBlockEntity)this.blockEntity).fortronStorage::setStoredFortron);
        this.addIntDataSlot(((FortronBlockEntity)this.blockEntity).fortronStorage::getFrequency, frequency -> {
            ((FortronBlockEntity)this.blockEntity).fortronStorage.setFrequency(frequency);
            if (this.frequencyChangeListener != null) {
                this.frequencyChangeListener.run();
            }
        });
    }

    protected void addIntDataSlot(IntSupplier gettter, IntConsumer setter) {
        this.addDataSlot(() -> gettter.getAsInt() & 0xFFFF, value -> {
            int current = gettter.getAsInt() & 0xFFFF0000;
            setter.accept(current + (value & 0xFFFF));
        });
        this.addDataSlot(() -> gettter.getAsInt() >> 16 & 0xFFFF, value -> {
            int current = gettter.getAsInt() & 0xFFFF;
            setter.accept(current | value << 16);
        });
    }

    protected void addDataSlot(IntSupplier gettter, IntConsumer setter) {
        this.addDataSlot(new DataSlotWrapper(gettter, setter));
    }

    private class AdvancementContainerListener
    implements ContainerListener {
        private AdvancementContainerListener() {
        }

        public void slotChanged(AbstractContainerMenu containerToSend, int dataSlotIndex, ItemStack stack) {
            FortronMenu.this.triggerMenuAdvancement();
        }

        public void dataChanged(AbstractContainerMenu containerMenu, int dataSlotIndex, int value) {
        }
    }
}

