/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.blockentity;

import dev.su5ed.mffs.MFFSConfig;
import dev.su5ed.mffs.api.module.Module;
import dev.su5ed.mffs.api.module.ModuleAcceptor;
import dev.su5ed.mffs.api.module.ModuleType;
import dev.su5ed.mffs.blockentity.BaseBlockEntity;
import dev.su5ed.mffs.blockentity.FortronBlockEntity;
import dev.su5ed.mffs.setup.ModCapabilities;
import dev.su5ed.mffs.setup.ModModules;
import dev.su5ed.mffs.util.ModUtil;
import dev.su5ed.mffs.util.ObjectCache;
import dev.su5ed.mffs.util.inventory.InventorySlot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

public abstract class ModularBlockEntity
extends FortronBlockEntity
implements ModuleAcceptor,
ObjectCache {
    private static final String FOTRON_COST_CACHE_KEY = "getFortronCost";
    private static final String MODULE_CACHE_KEY = "getModule_";
    private static final String MODULE_COUNT_CACHE_KEY = "getModuleCount_";
    private static final String MODULE_INSTANCE_CACHE_KEY = "getModuleInstances";
    private final int capacityBoost;
    private final Map<String, Object> cache = Collections.synchronizedMap(new HashMap());

    protected ModularBlockEntity(BlockEntityType<? extends BaseBlockEntity> type, BlockPos pos, BlockState state) {
        this(type, pos, state, 5);
    }

    protected ModularBlockEntity(BlockEntityType<? extends BaseBlockEntity> type, BlockPos pos, BlockState state, int capacityBoost) {
        super(type, pos, state);
        this.capacityBoost = capacityBoost;
    }

    public void consumeCost() {
        if (this.getFortronCost() > 0) {
            this.fortronStorage.extractFortron(this.getFortronCost(), false);
        }
    }

    protected float getAmplifier() {
        return 1.0f;
    }

    @Override
    public int getBaseFortronTankCapacity() {
        return 500;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.updateFortronTankCapacity();
    }

    @Override
    protected void onInventoryChanged() {
        super.onInventoryChanged();
        this.updateFortronTankCapacity();
        this.clearCache();
    }

    @Override
    public boolean hasModule(ModuleType<?> module) {
        return this.cached(MODULE_CACHE_KEY + module.hashCode(), () -> this.getAllModuleItemsStream().anyMatch(stack -> ModUtil.isModule(stack, module)));
    }

    @Override
    public int getModuleCount(ModuleType<?> module, Collection<InventorySlot> slots) {
        String key = MODULE_COUNT_CACHE_KEY + module.hashCode() + "_" + slots.hashCode();
        return this.cached(key, () -> ((StreamEx)this.getModuleItemsStream(slots).filter(stack -> ModUtil.isModule(stack, module))).mapToInt(ItemStack::getCount).sum());
    }

    @Override
    public Set<ItemStack> getModuleStacks() {
        return ((StreamEx)this.getAllModuleItemsStream().filter(ModUtil::isModule)).toSet();
    }

    @Override
    public Set<Module> getModuleInstances() {
        return this.cached(MODULE_INSTANCE_CACHE_KEY, () -> this.getModuleItemsStream(List.of()).mapPartial(stack -> Optional.ofNullable((ModuleType)stack.getCapability(ModCapabilities.MODULE_TYPE)).map(moduleType -> moduleType.createModule((ItemStack)stack))).toSet());
    }

    @Override
    public StreamEx<ItemStack> getAllModuleItemsStream() {
        return this.getModuleItemsStream(List.of());
    }

    @Override
    public int getFortronCost() {
        return this.cached(FOTRON_COST_CACHE_KEY, this::doGetFortronCost);
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T cached(String key, Supplier<T> calculation) {
        if (((Boolean)MFFSConfig.COMMON.useCache.get()).booleanValue()) {
            Map<String, Object> map = this.cache;
            synchronized (map) {
                Object value = this.cache.get(key);
                if (value == null) {
                    T computed = calculation.get();
                    this.cache.put(key, computed);
                    return computed;
                }
                return (T)value;
            }
        }
        return calculation.get();
    }

    protected int doGetFortronCost() {
        double cost = StreamEx.of(this.getModuleStacks()).mapToDouble(stack -> (double)stack.getCount() * Optional.ofNullable((ModuleType)stack.getCapability(ModCapabilities.MODULE_TYPE)).map(module -> module.getFortronCost(this.getAmplifier())).orElse(0.0)).sum();
        return (int)Math.round(cost);
    }

    protected void addModuleSlots(List<? super InventorySlot> list) {
    }

    protected List<InventorySlot> createUpgradeSlots(int count) {
        return this.createUpgradeSlots(count, ModUtil::isModule, (ItemStack stack) -> {});
    }

    protected List<InventorySlot> createUpgradeSlots(int count, @Nullable Module.Category category, Consumer<ItemStack> onChanged) {
        return this.createUpgradeSlots(count, (ItemStack stack) -> category == null || ModUtil.isModule(stack, category), onChanged);
    }

    protected List<InventorySlot> createUpgradeSlots(int count, Predicate<ItemStack> filter, Consumer<ItemStack> onChanged) {
        return IntStreamEx.range((int)count).mapToObj(i -> this.addSlot("upgrade_" + i, InventorySlot.Mode.BOTH, filter, onChanged)).toList();
    }

    private void updateFortronTankCapacity() {
        int capacity = (this.getModuleCount(ModModules.CAPACITY) * this.capacityBoost + this.getBaseFortronTankCapacity()) * 1000;
        this.fortronStorage.setCapacity(capacity);
    }

    private StreamEx<ItemStack> getModuleItemsStream(Collection<InventorySlot> slots) {
        if (slots.isEmpty()) {
            ArrayList moduleSlots = new ArrayList();
            this.addModuleSlots(moduleSlots);
            return StreamEx.of(moduleSlots).map(InventorySlot::getItem);
        }
        return StreamEx.of(slots).map(InventorySlot::getItem);
    }
}

