/*
 * Decompiled with CFR 0.152.
 */
package com.mamailes.merrymaking.init;

import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.JukeboxSong;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;

public class MMSounds {
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((Registry)BuiltInRegistries.SOUND_EVENT, (String)"merrymaking");
    public static final Supplier<SoundEvent> JINGLE_BELLS = MMSounds.registerSoundEvent("jingle_bells");
    public static final Supplier<SoundEvent> CHRISTMAS_DISC_1 = MMSounds.registerSoundEvent("christmas_disc_1");
    public static final Supplier<SoundEvent> CHRISTMAS_DISC_2 = MMSounds.registerSoundEvent("christmas_disc_2");
    public static final ResourceKey<JukeboxSong> CHRISTMAS_DISC_1_KEY = MMSounds.createSong("christmas_disc_1");
    public static final ResourceKey<JukeboxSong> CHRISTMAS_DISC_2_KEY = MMSounds.createSong("christmas_disc_2");

    private static ResourceKey<JukeboxSong> createSong(String name) {
        return ResourceKey.create((ResourceKey)Registries.JUKEBOX_SONG, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"merrymaking", (String)name));
    }

    private static Supplier<SoundEvent> registerSoundEvent(String name) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"merrymaking", (String)name);
        return SOUND_EVENTS.register(name, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)id));
    }

    public static void register(IEventBus eventBus) {
        SOUND_EVENTS.register(eventBus);
    }
}

