/*
 * Decompiled with CFR 0.152.
 */
package com.mamailes.merrymaking.block.deco.kwanzaa;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mamailes.merrymaking.block.deco.base.HorizontalDecoBlock;
import com.mamailes.merrymaking.util.MMHShapes;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class KinaraBlock
extends HorizontalDecoBlock {
    protected static final VoxelShape WEST_AABB = Block.box((double)5.5, (double)0.0, (double)0.0, (double)11.5, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.box((double)5.5, (double)0.0, (double)0.0, (double)11.5, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_AABB = Block.box((double)0.0, (double)0.0, (double)5.5, (double)16.0, (double)16.0, (double)11.5);
    protected static final VoxelShape SOUTH_AABB = Block.box((double)0.0, (double)0.0, (double)5.5, (double)16.0, (double)16.0, (double)11.5);
    public static final BooleanProperty LIT = BooleanProperty.create((String)"lit");
    public static final IntegerProperty CANDLES = IntegerProperty.create((String)"candles", (int)0, (int)7);
    public static final IntegerProperty LIT_CANDLES = IntegerProperty.create((String)"lit_candles", (int)0, (int)7);
    public static Boolean CANDLE_LIT = false;
    private static boolean first_lit = false;
    private static boolean second_lit = false;
    private static boolean third_lit = false;
    private static boolean fourth_lit = false;
    private static boolean fifth_lit = false;
    private static boolean sixth_lit = false;
    private static boolean seventh_lit = false;
    public final ImmutableMap<BlockState, VoxelShape> SHAPES_0;
    public final ImmutableMap<BlockState, VoxelShape> SHAPES_1;
    public final ImmutableMap<BlockState, VoxelShape> SHAPES_2;
    public final ImmutableMap<BlockState, VoxelShape> SHAPES_3;
    public final ImmutableMap<BlockState, VoxelShape> SHAPES_4;
    public final ImmutableMap<BlockState, VoxelShape> SHAPES_5;
    public final ImmutableMap<BlockState, VoxelShape> SHAPES_6;
    public final ImmutableMap<BlockState, VoxelShape> SHAPES_7;
    protected final ParticleOptions flameParticle;

    public KinaraBlock(BlockBehaviour.Properties properties, ParticleOptions particle) {
        super(properties);
        this.flameParticle = particle;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)DIRECTION, (Comparable)Direction.NORTH)).setValue((Property)CANDLES, (Comparable)Integer.valueOf(0))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
        this.SHAPES_0 = this.generateBaseOnlyShapes((ImmutableList<BlockState>)this.getStateDefinition().getPossibleStates());
        this.SHAPES_1 = this.generateCandle1Shapes((ImmutableList<BlockState>)this.getStateDefinition().getPossibleStates());
        this.SHAPES_2 = this.generateCandle2Shapes((ImmutableList<BlockState>)this.getStateDefinition().getPossibleStates());
        this.SHAPES_3 = this.generateCandle3Shapes((ImmutableList<BlockState>)this.getStateDefinition().getPossibleStates());
        this.SHAPES_4 = this.generateCandle4Shapes((ImmutableList<BlockState>)this.getStateDefinition().getPossibleStates());
        this.SHAPES_5 = this.generateCandle5Shapes((ImmutableList<BlockState>)this.getStateDefinition().getPossibleStates());
        this.SHAPES_6 = this.generateCandle6Shapes((ImmutableList<BlockState>)this.getStateDefinition().getPossibleStates());
        this.SHAPES_7 = this.generateCandle7Shapes((ImmutableList<BlockState>)this.getStateDefinition().getPossibleStates());
    }

    private ImmutableMap<BlockState, VoxelShape> generateBaseOnlyShapes(ImmutableList<BlockState> states) {
        VoxelShape[] BASE = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)5.0, (double)0.0, (double)5.5, (double)11.0, (double)1.0, (double)10.5), Direction.NORTH));
        VoxelShape[] BASE1 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)3.0, (double)1.0, (double)6.5, (double)13.0, (double)2.0, (double)9.5), Direction.NORTH));
        VoxelShape[] BASE2 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)2.0, (double)2.0, (double)6.5, (double)14.0, (double)3.0, (double)9.5), Direction.NORTH));
        VoxelShape[] BASE3 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)1.0, (double)3.0, (double)6.5, (double)15.0, (double)4.0, (double)9.5), Direction.NORTH));
        VoxelShape[] BASE4 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)0.0, (double)4.0, (double)7.5, (double)16.0, (double)5.0, (double)8.5), Direction.NORTH));
        VoxelShape[] TOP = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)0.25, (double)5.0, (double)7.0, (double)15.75, (double)6.0, (double)9.0), Direction.NORTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.getValue((Property)DIRECTION);
            ArrayList<VoxelShape> shapesTL = new ArrayList<VoxelShape>();
            shapesTL.add(BASE[direction.get2DDataValue()]);
            shapesTL.add(BASE1[direction.get2DDataValue()]);
            shapesTL.add(BASE2[direction.get2DDataValue()]);
            shapesTL.add(BASE3[direction.get2DDataValue()]);
            shapesTL.add(BASE4[direction.get2DDataValue()]);
            shapesTL.add(TOP[direction.get2DDataValue()]);
            builder.put((Object)state, (Object)MMHShapes.combineShapes(shapesTL));
        }
        return builder.build();
    }

    private ImmutableMap<BlockState, VoxelShape> generateCandle1Shapes(ImmutableList<BlockState> states) {
        VoxelShape[] BASE = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)5.0, (double)0.0, (double)5.5, (double)11.0, (double)1.0, (double)10.5), Direction.NORTH));
        VoxelShape[] BASE1 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)3.0, (double)1.0, (double)6.5, (double)13.0, (double)2.0, (double)9.5), Direction.NORTH));
        VoxelShape[] BASE2 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)2.0, (double)2.0, (double)6.5, (double)14.0, (double)3.0, (double)9.5), Direction.NORTH));
        VoxelShape[] BASE3 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)1.0, (double)3.0, (double)6.5, (double)15.0, (double)4.0, (double)9.5), Direction.NORTH));
        VoxelShape[] BASE4 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)0.0, (double)4.0, (double)7.5, (double)16.0, (double)5.0, (double)8.5), Direction.NORTH));
        VoxelShape[] TOP = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)0.25, (double)5.0, (double)7.0, (double)15.75, (double)6.0, (double)9.0), Direction.NORTH));
        VoxelShape[] CANDLE1 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)7.25, (double)5.0, (double)7.25, (double)8.75, (double)13.0, (double)8.75), Direction.NORTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.getValue((Property)DIRECTION);
            ArrayList<VoxelShape> shapesTL = new ArrayList<VoxelShape>();
            shapesTL.add(BASE[direction.get2DDataValue()]);
            shapesTL.add(BASE1[direction.get2DDataValue()]);
            shapesTL.add(BASE2[direction.get2DDataValue()]);
            shapesTL.add(BASE3[direction.get2DDataValue()]);
            shapesTL.add(BASE4[direction.get2DDataValue()]);
            shapesTL.add(TOP[direction.get2DDataValue()]);
            shapesTL.add(CANDLE1[direction.get2DDataValue()]);
            builder.put((Object)state, (Object)MMHShapes.combineShapes(shapesTL));
        }
        return builder.build();
    }

    private ImmutableMap<BlockState, VoxelShape> generateCandle2Shapes(ImmutableList<BlockState> states) {
        VoxelShape[] BASE = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)5.0, (double)0.0, (double)5.5, (double)11.0, (double)1.0, (double)10.5), Direction.NORTH));
        VoxelShape[] BASE1 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)3.0, (double)1.0, (double)6.5, (double)13.0, (double)2.0, (double)9.5), Direction.NORTH));
        VoxelShape[] BASE2 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)2.0, (double)2.0, (double)6.5, (double)14.0, (double)3.0, (double)9.5), Direction.NORTH));
        VoxelShape[] BASE3 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)1.0, (double)3.0, (double)6.5, (double)15.0, (double)4.0, (double)9.5), Direction.NORTH));
        VoxelShape[] BASE4 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)0.0, (double)4.0, (double)7.5, (double)16.0, (double)5.0, (double)8.5), Direction.NORTH));
        VoxelShape[] TOP = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)0.25, (double)5.0, (double)7.0, (double)15.75, (double)6.0, (double)9.0), Direction.NORTH));
        VoxelShape[] CANDLE1 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)7.25, (double)5.0, (double)7.25, (double)8.75, (double)13.0, (double)8.75), Direction.NORTH));
        VoxelShape[] CANDLE2 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)5.0, (double)5.0, (double)7.25, (double)6.5, (double)13.0, (double)8.75), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.getValue((Property)DIRECTION);
            ArrayList<VoxelShape> shapesTL = new ArrayList<VoxelShape>();
            shapesTL.add(BASE[direction.get2DDataValue()]);
            shapesTL.add(BASE1[direction.get2DDataValue()]);
            shapesTL.add(BASE2[direction.get2DDataValue()]);
            shapesTL.add(BASE3[direction.get2DDataValue()]);
            shapesTL.add(BASE4[direction.get2DDataValue()]);
            shapesTL.add(TOP[direction.get2DDataValue()]);
            shapesTL.add(CANDLE1[direction.get2DDataValue()]);
            shapesTL.add(CANDLE2[direction.get2DDataValue()]);
            builder.put((Object)state, (Object)MMHShapes.combineShapes(shapesTL));
        }
        return builder.build();
    }

    private ImmutableMap<BlockState, VoxelShape> generateCandle3Shapes(ImmutableList<BlockState> states) {
        VoxelShape[] BASE = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)5.0, (double)0.0, (double)5.5, (double)11.0, (double)1.0, (double)10.5), Direction.NORTH));
        VoxelShape[] BASE1 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)3.0, (double)1.0, (double)6.5, (double)13.0, (double)2.0, (double)9.5), Direction.NORTH));
        VoxelShape[] BASE2 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)2.0, (double)2.0, (double)6.5, (double)14.0, (double)3.0, (double)9.5), Direction.NORTH));
        VoxelShape[] BASE3 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)1.0, (double)3.0, (double)6.5, (double)15.0, (double)4.0, (double)9.5), Direction.NORTH));
        VoxelShape[] BASE4 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)0.0, (double)4.0, (double)7.5, (double)16.0, (double)5.0, (double)8.5), Direction.NORTH));
        VoxelShape[] TOP = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)0.25, (double)5.0, (double)7.0, (double)15.75, (double)6.0, (double)9.0), Direction.NORTH));
        VoxelShape[] CANDLE1 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)7.25, (double)5.0, (double)7.25, (double)8.75, (double)13.0, (double)8.75), Direction.NORTH));
        VoxelShape[] CANDLE2 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)5.0, (double)5.0, (double)7.25, (double)6.5, (double)13.0, (double)8.75), Direction.SOUTH));
        VoxelShape[] CANDLE3 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)9.55, (double)5.0, (double)7.25, (double)11.0, (double)13.0, (double)8.75), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.getValue((Property)DIRECTION);
            ArrayList<VoxelShape> shapesTL = new ArrayList<VoxelShape>();
            shapesTL.add(BASE[direction.get2DDataValue()]);
            shapesTL.add(BASE1[direction.get2DDataValue()]);
            shapesTL.add(BASE2[direction.get2DDataValue()]);
            shapesTL.add(BASE3[direction.get2DDataValue()]);
            shapesTL.add(BASE4[direction.get2DDataValue()]);
            shapesTL.add(TOP[direction.get2DDataValue()]);
            shapesTL.add(CANDLE1[direction.get2DDataValue()]);
            shapesTL.add(CANDLE2[direction.get2DDataValue()]);
            shapesTL.add(CANDLE3[direction.get2DDataValue()]);
            builder.put((Object)state, (Object)MMHShapes.combineShapes(shapesTL));
        }
        return builder.build();
    }

    private ImmutableMap<BlockState, VoxelShape> generateCandle4Shapes(ImmutableList<BlockState> states) {
        VoxelShape[] BASE = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)5.0, (double)0.0, (double)5.5, (double)11.0, (double)1.0, (double)10.5), Direction.NORTH));
        VoxelShape[] BASE1 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)3.0, (double)1.0, (double)6.5, (double)13.0, (double)2.0, (double)9.5), Direction.NORTH));
        VoxelShape[] BASE2 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)2.0, (double)2.0, (double)6.5, (double)14.0, (double)3.0, (double)9.5), Direction.NORTH));
        VoxelShape[] BASE3 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)1.0, (double)3.0, (double)6.5, (double)15.0, (double)4.0, (double)9.5), Direction.NORTH));
        VoxelShape[] BASE4 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)0.0, (double)4.0, (double)7.5, (double)16.0, (double)5.0, (double)8.5), Direction.NORTH));
        VoxelShape[] TOP = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)0.25, (double)5.0, (double)7.0, (double)15.75, (double)6.0, (double)9.0), Direction.NORTH));
        VoxelShape[] CANDLE1 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)7.25, (double)5.0, (double)7.25, (double)8.75, (double)13.0, (double)8.75), Direction.NORTH));
        VoxelShape[] CANDLE2 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)5.0, (double)5.0, (double)7.25, (double)6.5, (double)13.0, (double)8.75), Direction.SOUTH));
        VoxelShape[] CANDLE3 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)9.55, (double)5.0, (double)7.25, (double)11.0, (double)13.0, (double)8.75), Direction.SOUTH));
        VoxelShape[] CANDLE4 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)2.75, (double)5.0, (double)7.25, (double)4.25, (double)13.0, (double)8.75), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.getValue((Property)DIRECTION);
            ArrayList<VoxelShape> shapesTL = new ArrayList<VoxelShape>();
            shapesTL.add(BASE[direction.get2DDataValue()]);
            shapesTL.add(BASE1[direction.get2DDataValue()]);
            shapesTL.add(BASE2[direction.get2DDataValue()]);
            shapesTL.add(BASE3[direction.get2DDataValue()]);
            shapesTL.add(BASE4[direction.get2DDataValue()]);
            shapesTL.add(TOP[direction.get2DDataValue()]);
            shapesTL.add(CANDLE1[direction.get2DDataValue()]);
            shapesTL.add(CANDLE2[direction.get2DDataValue()]);
            shapesTL.add(CANDLE3[direction.get2DDataValue()]);
            shapesTL.add(CANDLE4[direction.get2DDataValue()]);
            builder.put((Object)state, (Object)MMHShapes.combineShapes(shapesTL));
        }
        return builder.build();
    }

    private ImmutableMap<BlockState, VoxelShape> generateCandle5Shapes(ImmutableList<BlockState> states) {
        VoxelShape[] BASE = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)5.0, (double)0.0, (double)5.5, (double)11.0, (double)1.0, (double)10.5), Direction.NORTH));
        VoxelShape[] BASE1 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)3.0, (double)1.0, (double)6.5, (double)13.0, (double)2.0, (double)9.5), Direction.NORTH));
        VoxelShape[] BASE2 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)2.0, (double)2.0, (double)6.5, (double)14.0, (double)3.0, (double)9.5), Direction.NORTH));
        VoxelShape[] BASE3 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)1.0, (double)3.0, (double)6.5, (double)15.0, (double)4.0, (double)9.5), Direction.NORTH));
        VoxelShape[] BASE4 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)0.0, (double)4.0, (double)7.5, (double)16.0, (double)5.0, (double)8.5), Direction.NORTH));
        VoxelShape[] TOP = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)0.25, (double)5.0, (double)7.0, (double)15.75, (double)6.0, (double)9.0), Direction.NORTH));
        VoxelShape[] CANDLE1 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)7.25, (double)5.0, (double)7.25, (double)8.75, (double)13.0, (double)8.75), Direction.NORTH));
        VoxelShape[] CANDLE2 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)5.0, (double)5.0, (double)7.25, (double)6.5, (double)13.0, (double)8.75), Direction.SOUTH));
        VoxelShape[] CANDLE3 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)9.55, (double)5.0, (double)7.25, (double)11.0, (double)13.0, (double)8.75), Direction.SOUTH));
        VoxelShape[] CANDLE4 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)2.75, (double)5.0, (double)7.25, (double)4.25, (double)13.0, (double)8.75), Direction.SOUTH));
        VoxelShape[] CANDLE5 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)11.75, (double)5.0, (double)7.25, (double)13.25, (double)13.0, (double)8.75), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.getValue((Property)DIRECTION);
            ArrayList<VoxelShape> shapesTL = new ArrayList<VoxelShape>();
            shapesTL.add(BASE[direction.get2DDataValue()]);
            shapesTL.add(BASE1[direction.get2DDataValue()]);
            shapesTL.add(BASE2[direction.get2DDataValue()]);
            shapesTL.add(BASE3[direction.get2DDataValue()]);
            shapesTL.add(BASE4[direction.get2DDataValue()]);
            shapesTL.add(TOP[direction.get2DDataValue()]);
            shapesTL.add(CANDLE1[direction.get2DDataValue()]);
            shapesTL.add(CANDLE2[direction.get2DDataValue()]);
            shapesTL.add(CANDLE3[direction.get2DDataValue()]);
            shapesTL.add(CANDLE4[direction.get2DDataValue()]);
            shapesTL.add(CANDLE5[direction.get2DDataValue()]);
            builder.put((Object)state, (Object)MMHShapes.combineShapes(shapesTL));
        }
        return builder.build();
    }

    private ImmutableMap<BlockState, VoxelShape> generateCandle6Shapes(ImmutableList<BlockState> states) {
        VoxelShape[] BASE = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)5.0, (double)0.0, (double)5.5, (double)11.0, (double)1.0, (double)10.5), Direction.NORTH));
        VoxelShape[] BASE1 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)3.0, (double)1.0, (double)6.5, (double)13.0, (double)2.0, (double)9.5), Direction.NORTH));
        VoxelShape[] BASE2 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)2.0, (double)2.0, (double)6.5, (double)14.0, (double)3.0, (double)9.5), Direction.NORTH));
        VoxelShape[] BASE3 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)1.0, (double)3.0, (double)6.5, (double)15.0, (double)4.0, (double)9.5), Direction.NORTH));
        VoxelShape[] BASE4 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)0.0, (double)4.0, (double)7.5, (double)16.0, (double)5.0, (double)8.5), Direction.NORTH));
        VoxelShape[] TOP = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)0.25, (double)5.0, (double)7.0, (double)15.75, (double)6.0, (double)9.0), Direction.NORTH));
        VoxelShape[] CANDLE1 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)7.25, (double)5.0, (double)7.25, (double)8.75, (double)13.0, (double)8.75), Direction.NORTH));
        VoxelShape[] CANDLE2 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)5.0, (double)5.0, (double)7.25, (double)6.5, (double)13.0, (double)8.75), Direction.SOUTH));
        VoxelShape[] CANDLE3 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)9.55, (double)5.0, (double)7.25, (double)11.0, (double)13.0, (double)8.75), Direction.SOUTH));
        VoxelShape[] CANDLE4 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)2.75, (double)5.0, (double)7.25, (double)4.25, (double)13.0, (double)8.75), Direction.SOUTH));
        VoxelShape[] CANDLE5 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)11.75, (double)5.0, (double)7.25, (double)13.25, (double)13.0, (double)8.75), Direction.SOUTH));
        VoxelShape[] CANDLE6 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)0.5, (double)5.0, (double)7.25, (double)2.0, (double)13.0, (double)8.75), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.getValue((Property)DIRECTION);
            ArrayList<VoxelShape> shapesTL = new ArrayList<VoxelShape>();
            shapesTL.add(BASE[direction.get2DDataValue()]);
            shapesTL.add(BASE1[direction.get2DDataValue()]);
            shapesTL.add(BASE2[direction.get2DDataValue()]);
            shapesTL.add(BASE3[direction.get2DDataValue()]);
            shapesTL.add(BASE4[direction.get2DDataValue()]);
            shapesTL.add(TOP[direction.get2DDataValue()]);
            shapesTL.add(CANDLE1[direction.get2DDataValue()]);
            shapesTL.add(CANDLE2[direction.get2DDataValue()]);
            shapesTL.add(CANDLE3[direction.get2DDataValue()]);
            shapesTL.add(CANDLE4[direction.get2DDataValue()]);
            shapesTL.add(CANDLE5[direction.get2DDataValue()]);
            shapesTL.add(CANDLE6[direction.get2DDataValue()]);
            builder.put((Object)state, (Object)MMHShapes.combineShapes(shapesTL));
        }
        return builder.build();
    }

    private ImmutableMap<BlockState, VoxelShape> generateCandle7Shapes(ImmutableList<BlockState> states) {
        VoxelShape[] BASE = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)5.0, (double)0.0, (double)5.5, (double)11.0, (double)1.0, (double)10.5), Direction.NORTH));
        VoxelShape[] BASE1 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)3.0, (double)1.0, (double)6.5, (double)13.0, (double)2.0, (double)9.5), Direction.NORTH));
        VoxelShape[] BASE2 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)2.0, (double)2.0, (double)6.5, (double)14.0, (double)3.0, (double)9.5), Direction.NORTH));
        VoxelShape[] BASE3 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)1.0, (double)3.0, (double)6.5, (double)15.0, (double)4.0, (double)9.5), Direction.NORTH));
        VoxelShape[] BASE4 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)0.0, (double)4.0, (double)7.5, (double)16.0, (double)5.0, (double)8.5), Direction.NORTH));
        VoxelShape[] TOP = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)0.25, (double)5.0, (double)7.0, (double)15.75, (double)6.0, (double)9.0), Direction.NORTH));
        VoxelShape[] CANDLE1 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)7.25, (double)5.0, (double)7.25, (double)8.75, (double)13.0, (double)8.75), Direction.NORTH));
        VoxelShape[] CANDLE2 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)5.0, (double)5.0, (double)7.25, (double)6.5, (double)13.0, (double)8.75), Direction.SOUTH));
        VoxelShape[] CANDLE3 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)9.55, (double)5.0, (double)7.25, (double)11.0, (double)13.0, (double)8.75), Direction.SOUTH));
        VoxelShape[] CANDLE4 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)2.75, (double)5.0, (double)7.25, (double)4.25, (double)13.0, (double)8.75), Direction.SOUTH));
        VoxelShape[] CANDLE5 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)11.75, (double)5.0, (double)7.25, (double)13.25, (double)13.0, (double)8.75), Direction.SOUTH));
        VoxelShape[] CANDLE6 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)0.5, (double)5.0, (double)7.25, (double)2.0, (double)13.0, (double)8.75), Direction.SOUTH));
        VoxelShape[] CANDLE7 = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)14.0, (double)5.0, (double)7.25, (double)15.5, (double)13.0, (double)8.75), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.getValue((Property)DIRECTION);
            ArrayList<VoxelShape> shapesTL = new ArrayList<VoxelShape>();
            shapesTL.add(BASE[direction.get2DDataValue()]);
            shapesTL.add(BASE1[direction.get2DDataValue()]);
            shapesTL.add(BASE2[direction.get2DDataValue()]);
            shapesTL.add(BASE3[direction.get2DDataValue()]);
            shapesTL.add(BASE4[direction.get2DDataValue()]);
            shapesTL.add(TOP[direction.get2DDataValue()]);
            shapesTL.add(CANDLE1[direction.get2DDataValue()]);
            shapesTL.add(CANDLE2[direction.get2DDataValue()]);
            shapesTL.add(CANDLE3[direction.get2DDataValue()]);
            shapesTL.add(CANDLE4[direction.get2DDataValue()]);
            shapesTL.add(CANDLE5[direction.get2DDataValue()]);
            shapesTL.add(CANDLE6[direction.get2DDataValue()]);
            shapesTL.add(CANDLE7[direction.get2DDataValue()]);
            builder.put((Object)state, (Object)MMHShapes.combineShapes(shapesTL));
        }
        return builder.build();
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)DIRECTION, (Comparable)context.getHorizontalDirection())).setValue((Property)LIT, (Comparable)Boolean.FALSE);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.getValue((Property)CANDLES)) {
            case 1 -> Objects.requireNonNull((VoxelShape)this.SHAPES_1.get((Object)state));
            case 2 -> Objects.requireNonNull((VoxelShape)this.SHAPES_2.get((Object)state));
            case 3 -> Objects.requireNonNull((VoxelShape)this.SHAPES_3.get((Object)state));
            case 4 -> Objects.requireNonNull((VoxelShape)this.SHAPES_4.get((Object)state));
            case 5 -> Objects.requireNonNull((VoxelShape)this.SHAPES_5.get((Object)state));
            case 6 -> Objects.requireNonNull((VoxelShape)this.SHAPES_6.get((Object)state));
            case 7 -> Objects.requireNonNull((VoxelShape)this.SHAPES_7.get((Object)state));
            default -> Objects.requireNonNull((VoxelShape)this.SHAPES_0.get((Object)state));
        };
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            if ((Integer)state.getValue((Property)LIT_CANDLES) == 1) {
                return 2;
            }
            if ((Integer)state.getValue((Property)LIT_CANDLES) == 2) {
                return 4;
            }
            if ((Integer)state.getValue((Property)LIT_CANDLES) == 3) {
                return 6;
            }
            if ((Integer)state.getValue((Property)LIT_CANDLES) == 4) {
                return 8;
            }
            if ((Integer)state.getValue((Property)LIT_CANDLES) == 5) {
                return 10;
            }
            if ((Integer)state.getValue((Property)LIT_CANDLES) == 6) {
                return 12;
            }
            if ((Integer)state.getValue((Property)LIT_CANDLES) == 7) {
                return 14;
            }
        }
        return super.getLightEmission(state, level, pos);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult pHitResult) {
        stack = player.getItemInHand(hand);
        if (!level.isClientSide()) {
            if (stack.getItem() == Items.BLACK_CANDLE && (Integer)state.getValue((Property)CANDLES) == 0) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CANDLES, (Comparable)Integer.valueOf((Integer)state.getValue((Property)CANDLES) + 1)));
                stack.shrink(1);
                return ItemInteractionResult.SUCCESS;
            }
            if (stack.getItem() == Items.RED_CANDLE && (Integer)state.getValue((Property)CANDLES) == 1) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CANDLES, (Comparable)Integer.valueOf((Integer)state.getValue((Property)CANDLES) + 1)));
                stack.shrink(1);
                CANDLE_LIT = false;
                return ItemInteractionResult.SUCCESS;
            }
            if (stack.getItem() == Items.GREEN_CANDLE && (Integer)state.getValue((Property)CANDLES) == 2) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CANDLES, (Comparable)Integer.valueOf((Integer)state.getValue((Property)CANDLES) + 1)));
                stack.shrink(1);
                CANDLE_LIT = false;
                return ItemInteractionResult.SUCCESS;
            }
            if (stack.getItem() == Items.RED_CANDLE && (Integer)state.getValue((Property)CANDLES) == 3) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CANDLES, (Comparable)Integer.valueOf((Integer)state.getValue((Property)CANDLES) + 1)));
                stack.shrink(1);
                CANDLE_LIT = false;
                return ItemInteractionResult.SUCCESS;
            }
            if (stack.getItem() == Items.GREEN_CANDLE && (Integer)state.getValue((Property)CANDLES) == 4) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CANDLES, (Comparable)Integer.valueOf((Integer)state.getValue((Property)CANDLES) + 1)));
                stack.shrink(1);
                CANDLE_LIT = false;
                return ItemInteractionResult.SUCCESS;
            }
            if (stack.getItem() == Items.RED_CANDLE && (Integer)state.getValue((Property)CANDLES) == 5) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CANDLES, (Comparable)Integer.valueOf((Integer)state.getValue((Property)CANDLES) + 1)));
                stack.shrink(1);
                CANDLE_LIT = false;
                return ItemInteractionResult.SUCCESS;
            }
            if (stack.getItem() == Items.GREEN_CANDLE && (Integer)state.getValue((Property)CANDLES) == 6) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CANDLES, (Comparable)Integer.valueOf((Integer)state.getValue((Property)CANDLES) + 1)));
                stack.shrink(1);
                CANDLE_LIT = false;
                return ItemInteractionResult.SUCCESS;
            }
            if (stack.getItem() == Items.FLINT_AND_STEEL) {
                if ((Integer)state.getValue((Property)CANDLES) == 1 && (Integer)state.getValue((Property)LIT_CANDLES) == 0) {
                    if (!((Boolean)state.getValue((Property)LIT)).booleanValue()) {
                        level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)LIT_CANDLES, (Comparable)Integer.valueOf(1)));
                    }
                    CANDLE_LIT = true;
                    stack.setDamageValue(1);
                    player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                    first_lit = true;
                    player.sendSystemMessage((Component)Component.literal((String)"The Umoja Candle has been lit."));
                }
                if (!CANDLE_LIT.booleanValue() && (Integer)state.getValue((Property)CANDLES) == 2) {
                    CANDLE_LIT = true;
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LIT_CANDLES, (Comparable)Integer.valueOf(2)));
                    stack.setDamageValue(1);
                    player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                    second_lit = true;
                    player.sendSystemMessage((Component)Component.literal((String)"The Kujichagulia Candle has been lit."));
                }
                if (!CANDLE_LIT.booleanValue() && (Integer)state.getValue((Property)CANDLES) == 3) {
                    CANDLE_LIT = true;
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LIT_CANDLES, (Comparable)Integer.valueOf(3)));
                    stack.setDamageValue(1);
                    player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                    third_lit = true;
                    player.sendSystemMessage((Component)Component.literal((String)"The Ujima Candle has been lit."));
                }
                if (!CANDLE_LIT.booleanValue() && (Integer)state.getValue((Property)CANDLES) == 4) {
                    CANDLE_LIT = true;
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LIT_CANDLES, (Comparable)Integer.valueOf(4)));
                    stack.setDamageValue(1);
                    player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                    fourth_lit = true;
                    player.sendSystemMessage((Component)Component.literal((String)"The Ujamaa Candle has been lit."));
                }
                if (!CANDLE_LIT.booleanValue() && (Integer)state.getValue((Property)CANDLES) == 5) {
                    CANDLE_LIT = true;
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LIT_CANDLES, (Comparable)Integer.valueOf(5)));
                    stack.setDamageValue(1);
                    player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                    fifth_lit = true;
                    player.sendSystemMessage((Component)Component.literal((String)"The Nia Candle has been lit."));
                }
                if (!CANDLE_LIT.booleanValue() && (Integer)state.getValue((Property)CANDLES) == 6) {
                    CANDLE_LIT = true;
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LIT_CANDLES, (Comparable)Integer.valueOf(6)));
                    stack.setDamageValue(1);
                    player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                    sixth_lit = true;
                    player.sendSystemMessage((Component)Component.literal((String)"The Kuumba Candle has been lit."));
                }
                if (!CANDLE_LIT.booleanValue() && (Integer)state.getValue((Property)CANDLES) == 7) {
                    CANDLE_LIT = true;
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LIT_CANDLES, (Comparable)Integer.valueOf(7)));
                    stack.setDamageValue(1);
                    player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                    seventh_lit = true;
                    player.sendSystemMessage((Component)Component.literal((String)"The Imani Candle has been lit."));
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, pHitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            if ((Integer)state.getValue((Property)CANDLES) == 7 && (Integer)state.getValue((Property)LIT_CANDLES) == 7) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)CANDLES, (Comparable)Integer.valueOf(6))).setValue((Property)LIT_CANDLES, (Comparable)Integer.valueOf(6)));
                player.addItem(new ItemStack((ItemLike)Items.GREEN_CANDLE));
                return InteractionResult.CONSUME;
            }
            if ((Integer)state.getValue((Property)CANDLES) == 7) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)CANDLES, (Comparable)Integer.valueOf(6))).setValue((Property)LIT_CANDLES, (Comparable)Integer.valueOf(6)));
                player.addItem(new ItemStack((ItemLike)Items.GREEN_CANDLE));
                return InteractionResult.CONSUME;
            }
            if ((Integer)state.getValue((Property)CANDLES) == 6 && (Integer)state.getValue((Property)LIT_CANDLES) == 6) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)CANDLES, (Comparable)Integer.valueOf(5))).setValue((Property)LIT_CANDLES, (Comparable)Integer.valueOf(5)));
                player.addItem(new ItemStack((ItemLike)Items.RED_CANDLE));
                return InteractionResult.CONSUME;
            }
            if ((Integer)state.getValue((Property)CANDLES) == 6) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)CANDLES, (Comparable)Integer.valueOf(5))).setValue((Property)LIT_CANDLES, (Comparable)Integer.valueOf(5)));
                player.addItem(new ItemStack((ItemLike)Items.RED_CANDLE));
                return InteractionResult.CONSUME;
            }
            if ((Integer)state.getValue((Property)CANDLES) == 5 && (Integer)state.getValue((Property)LIT_CANDLES) == 5) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)CANDLES, (Comparable)Integer.valueOf(4))).setValue((Property)LIT_CANDLES, (Comparable)Integer.valueOf(4)));
                player.addItem(new ItemStack((ItemLike)Items.GREEN_CANDLE));
                return InteractionResult.CONSUME;
            }
            if ((Integer)state.getValue((Property)CANDLES) == 5) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)CANDLES, (Comparable)Integer.valueOf(4))).setValue((Property)LIT_CANDLES, (Comparable)Integer.valueOf(4)));
                player.addItem(new ItemStack((ItemLike)Items.GREEN_CANDLE));
                return InteractionResult.CONSUME;
            }
            if ((Integer)state.getValue((Property)CANDLES) == 4 && (Integer)state.getValue((Property)LIT_CANDLES) == 4) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)CANDLES, (Comparable)Integer.valueOf(3))).setValue((Property)LIT_CANDLES, (Comparable)Integer.valueOf(3)));
                player.addItem(new ItemStack((ItemLike)Items.RED_CANDLE));
                return InteractionResult.CONSUME;
            }
            if ((Integer)state.getValue((Property)CANDLES) == 4) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)CANDLES, (Comparable)Integer.valueOf(3))).setValue((Property)LIT_CANDLES, (Comparable)Integer.valueOf(3)));
                player.addItem(new ItemStack((ItemLike)Items.RED_CANDLE));
                return InteractionResult.CONSUME;
            }
            if ((Integer)state.getValue((Property)CANDLES) == 3 && (Integer)state.getValue((Property)LIT_CANDLES) == 3) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)CANDLES, (Comparable)Integer.valueOf(2))).setValue((Property)LIT_CANDLES, (Comparable)Integer.valueOf(2)));
                player.addItem(new ItemStack((ItemLike)Items.GREEN_CANDLE));
                return InteractionResult.CONSUME;
            }
            if ((Integer)state.getValue((Property)CANDLES) == 3) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)CANDLES, (Comparable)Integer.valueOf(2))).setValue((Property)LIT_CANDLES, (Comparable)Integer.valueOf(2)));
                player.addItem(new ItemStack((ItemLike)Items.GREEN_CANDLE));
                return InteractionResult.CONSUME;
            }
            if ((Integer)state.getValue((Property)CANDLES) == 2 && (Integer)state.getValue((Property)LIT_CANDLES) == 2) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)CANDLES, (Comparable)Integer.valueOf(1))).setValue((Property)LIT_CANDLES, (Comparable)Integer.valueOf(1)));
                player.addItem(new ItemStack((ItemLike)Items.RED_CANDLE));
                return InteractionResult.CONSUME;
            }
            if ((Integer)state.getValue((Property)CANDLES) == 2) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)CANDLES, (Comparable)Integer.valueOf(1))).setValue((Property)LIT_CANDLES, (Comparable)Integer.valueOf(1)));
                player.addItem(new ItemStack((ItemLike)Items.RED_CANDLE));
                return InteractionResult.CONSUME;
            }
            if ((Integer)state.getValue((Property)CANDLES) == 1 && (Integer)state.getValue((Property)LIT_CANDLES) == 1) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)((BlockState)state.setValue((Property)CANDLES, (Comparable)Integer.valueOf(0))).setValue((Property)LIT_CANDLES, (Comparable)Integer.valueOf(0))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
                player.addItem(new ItemStack((ItemLike)Items.BLACK_CANDLE));
                return InteractionResult.CONSUME;
            }
            if ((Integer)state.getValue((Property)CANDLES) == 1) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)((BlockState)state.setValue((Property)CANDLES, (Comparable)Integer.valueOf(0))).setValue((Property)LIT_CANDLES, (Comparable)Integer.valueOf(0))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
                player.addItem(new ItemStack((ItemLike)Items.BLACK_CANDLE));
                return InteractionResult.CONSUME;
            }
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LIT});
        builder.add(new Property[]{CANDLES});
        builder.add(new Property[]{LIT_CANDLES});
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        boolean seven;
        boolean one = first_lit;
        boolean two = first_lit && second_lit;
        boolean three = first_lit && second_lit && third_lit;
        boolean four = first_lit && second_lit && third_lit && fourth_lit;
        boolean five = first_lit && second_lit && third_lit && fourth_lit && fifth_lit;
        boolean six = first_lit && second_lit && third_lit && fourth_lit && fifth_lit && sixth_lit;
        boolean bl = seven = first_lit && second_lit && third_lit && fourth_lit && fifth_lit && sixth_lit && seventh_lit;
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            if (state.getValue((Property)DIRECTION) == Direction.NORTH) {
                if ((Integer)state.getValue((Property)LIT_CANDLES) == 1) {
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                }
                if ((Integer)state.getValue((Property)LIT_CANDLES) == 2) {
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.35f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                }
                if ((Integer)state.getValue((Property)LIT_CANDLES) == 3) {
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.35f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.65f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                }
                if ((Integer)state.getValue((Property)LIT_CANDLES) == 4) {
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.925f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.35f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.65f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.23f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                }
                if ((Integer)state.getValue((Property)LIT_CANDLES) == 5) {
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.35f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.65f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.23f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.775f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                }
                if ((Integer)state.getValue((Property)LIT_CANDLES) == 6) {
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.35f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.65f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.23f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.775f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.9f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                }
                if ((Integer)state.getValue((Property)LIT_CANDLES) == 7) {
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.35f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.65f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.23f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.775f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.9f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.1f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                }
            }
            if (state.getValue((Property)DIRECTION) == Direction.EAST) {
                if ((Integer)state.getValue((Property)LIT_CANDLES) == 1) {
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                }
                if ((Integer)state.getValue((Property)LIT_CANDLES) == 2) {
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.35f), 0.0, 0.0, 0.0);
                }
                if ((Integer)state.getValue((Property)LIT_CANDLES) == 3) {
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.35f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.65f), 0.0, 0.0, 0.0);
                }
                if ((Integer)state.getValue((Property)LIT_CANDLES) == 4) {
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.35f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.65f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.23f), 0.0, 0.0, 0.0);
                }
                if ((Integer)state.getValue((Property)LIT_CANDLES) == 5) {
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.35f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.65f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.23f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.775f), 0.0, 0.0, 0.0);
                }
                if ((Integer)state.getValue((Property)LIT_CANDLES) == 6) {
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.35f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.65f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.23f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.775f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.9f), 0.0, 0.0, 0.0);
                }
                if ((Integer)state.getValue((Property)LIT_CANDLES) == 7) {
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.35f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.65f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.23f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.775f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.9f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.1f), 0.0, 0.0, 0.0);
                }
            }
            if (state.getValue((Property)DIRECTION) == Direction.SOUTH) {
                if ((Integer)state.getValue((Property)LIT_CANDLES) == 1) {
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                }
                if ((Integer)state.getValue((Property)LIT_CANDLES) == 2) {
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.65f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                }
                if ((Integer)state.getValue((Property)LIT_CANDLES) == 3) {
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.65f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.35f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                }
                if ((Integer)state.getValue((Property)LIT_CANDLES) == 4) {
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.65f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.35f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.775f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                }
                if ((Integer)state.getValue((Property)LIT_CANDLES) == 5) {
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.65f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.35f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.775f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.23f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                }
                if ((Integer)state.getValue((Property)LIT_CANDLES) == 6) {
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.65f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.35f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.775f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.23f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.9f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                }
                if ((Integer)state.getValue((Property)LIT_CANDLES) == 7) {
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.65f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.35f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.775f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.23f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.9f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.1f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                }
            }
            if (state.getValue((Property)DIRECTION) == Direction.WEST) {
                if ((Integer)state.getValue((Property)LIT_CANDLES) == 1) {
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                }
                if ((Integer)state.getValue((Property)LIT_CANDLES) == 2) {
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.65f), 0.0, 0.0, 0.0);
                }
                if ((Integer)state.getValue((Property)LIT_CANDLES) == 3) {
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.65f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.35f), 0.0, 0.0, 0.0);
                }
                if ((Integer)state.getValue((Property)LIT_CANDLES) == 4) {
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.65f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.35f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.775f), 0.0, 0.0, 0.0);
                }
                if ((Integer)state.getValue((Property)LIT_CANDLES) == 5) {
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.65f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.35f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.775f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.23f), 0.0, 0.0, 0.0);
                }
                if ((Integer)state.getValue((Property)LIT_CANDLES) == 6) {
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.65f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.35f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.775f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.23f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.9f), 0.0, 0.0, 0.0);
                }
                if ((Integer)state.getValue((Property)LIT_CANDLES) == 7) {
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.65f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.35f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.775f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.23f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.9f), 0.0, 0.0, 0.0);
                    level.addParticle(this.flameParticle, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.923f), (double)((float)pos.getZ() + 0.1f), 0.0, 0.0, 0.0);
                }
            }
        }
        super.animateTick(state, level, pos, random);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if ((Integer)state.getValue((Property)CANDLES) == 1) {
            KinaraBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.BLACK_CANDLE));
        }
        if ((Integer)state.getValue((Property)CANDLES) == 2) {
            KinaraBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.BLACK_CANDLE));
            KinaraBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.RED_CANDLE));
        }
        if ((Integer)state.getValue((Property)CANDLES) == 3) {
            KinaraBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.BLACK_CANDLE));
            KinaraBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.RED_CANDLE));
            KinaraBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.GREEN_CANDLE));
        }
        if ((Integer)state.getValue((Property)CANDLES) == 4) {
            KinaraBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.BLACK_CANDLE));
            KinaraBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.RED_CANDLE, 2));
            KinaraBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.GREEN_CANDLE));
        }
        if ((Integer)state.getValue((Property)CANDLES) == 5) {
            KinaraBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.BLACK_CANDLE));
            KinaraBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.RED_CANDLE, 2));
            KinaraBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.GREEN_CANDLE, 2));
        }
        if ((Integer)state.getValue((Property)CANDLES) == 6) {
            KinaraBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.BLACK_CANDLE));
            KinaraBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.RED_CANDLE, 3));
            KinaraBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.GREEN_CANDLE, 2));
        }
        if ((Integer)state.getValue((Property)CANDLES) == 7) {
            KinaraBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.BLACK_CANDLE));
            KinaraBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.RED_CANDLE, 3));
            KinaraBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.GREEN_CANDLE, 3));
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }
}

