/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.requester.status;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.IntFunction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;

public enum RequestStatus implements StringRepresentable
{
    IDLE,
    MISSING,
    REQUEST,
    PLAN,
    LINK,
    EXPORT;

    public static final Codec<RequestStatus> CODEC;
    public static final IntFunction<RequestStatus> BY_ID;
    public static final StreamCodec<ByteBuf, RequestStatus> STREAM_CODEC;

    public RequestStatus translateToClient() {
        if (this == REQUEST || this == PLAN) {
            return IDLE;
        }
        return this;
    }

    public boolean locksRequest() {
        return this == LINK || this == EXPORT;
    }

    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    static {
        CODEC = StringRepresentable.fromEnum(RequestStatus::values);
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])RequestStatus.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
    }
}

