/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.misc;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gripe._90.megacells.definition.MEGAComponents;
import gripe._90.megacells.definition.MEGAItems;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class DecompressionPattern
implements IPatternDetails {
    private final AEItemKey definition;
    private final Item from;
    private final Item to;
    private final int factor;
    private final boolean compress;

    public DecompressionPattern(Item from, Item to, int factor, boolean compress) {
        this.from = from;
        this.to = to;
        this.factor = factor;
        this.compress = compress;
        ItemStack definition = new ItemStack(MEGAItems.SKY_STEEL_INGOT);
        definition.set(MEGAComponents.ENCODED_DECOMPRESSION_PATTERN, (Object)new Encoded(from, to, factor, compress));
        this.definition = AEItemKey.of((ItemStack)definition);
    }

    public AEItemKey getDefinition() {
        return this.definition;
    }

    public IPatternDetails.IInput[] getInputs() {
        return new IPatternDetails.IInput[]{new Input(this.from, this.compress ? this.factor : 1)};
    }

    public List<GenericStack> getOutputs() {
        return Collections.singletonList(new GenericStack((AEKey)AEItemKey.of((ItemLike)this.to), this.compress ? 1L : (long)this.factor));
    }

    public boolean equals(Object o) {
        return o != null && o.getClass() == this.getClass() && ((DecompressionPattern)o).definition.equals((Object)this.definition);
    }

    public int hashCode() {
        return this.definition.hashCode();
    }

    public record Encoded(Item from, Item to, int factor, boolean compress) {
        public static final Codec<Encoded> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("from").forGetter(Encoded::from), (App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("to").forGetter(Encoded::to), (App)Codec.INT.fieldOf("factor").forGetter(Encoded::factor), (App)Codec.BOOL.fieldOf("compress").forGetter(Encoded::compress)).apply((Applicative)instance, Encoded::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Encoded> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ITEM), Encoded::from, (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ITEM), Encoded::to, (StreamCodec)ByteBufCodecs.VAR_INT, Encoded::factor, (StreamCodec)ByteBufCodecs.BOOL, Encoded::compress, Encoded::new);
    }

    private record Input(Item input, int factor) implements IPatternDetails.IInput
    {
        public GenericStack[] getPossibleInputs() {
            return new GenericStack[]{new GenericStack((AEKey)AEItemKey.of((ItemLike)this.input), (long)this.factor)};
        }

        public long getMultiplier() {
            return 1L;
        }

        public boolean isValid(AEKey input, Level level) {
            return input.matches(this.getPossibleInputs()[0]);
        }

        public AEKey getRemainingKey(AEKey template) {
            return null;
        }
    }
}

