/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.item.cell;

import appeng.api.config.Actionable;
import appeng.api.crafting.IPatternDetails;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import gripe._90.megacells.definition.MEGAComponents;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.item.cell.BulkCellItem;
import gripe._90.megacells.misc.CompressionChain;
import gripe._90.megacells.misc.CompressionService;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class BulkCellInventory
implements StorageCell {
    private final ISaveProvider container;
    private final ItemStack stack;
    private AEItemKey storedItem;
    private final AEItemKey filterItem;
    private final boolean compressionEnabled;
    private CompressionChain compressionChain;
    private BigInteger unitCount;
    private BigInteger unitFactor;
    private int compressionCutoff;
    private Map<Item, Long> compressedStacks;
    private List<IPatternDetails> decompressionPatterns;
    private boolean isPersisted = true;

    BulkCellInventory(ItemStack stack, ISaveProvider container) {
        int maxCutoff;
        int recordedCutoff;
        this.stack = stack;
        this.container = container;
        BulkCellItem cell = (BulkCellItem)stack.getItem();
        this.filterItem = (AEItemKey)cell.getConfigInventory(stack).getKey(0);
        this.compressionEnabled = cell.getUpgrades(stack).isInstalled(MEGAItems.COMPRESSION_CARD);
        this.storedItem = (AEItemKey)stack.get(MEGAComponents.BULK_CELL_ITEM);
        this.unitCount = (BigInteger)stack.getOrDefault(MEGAComponents.BULK_CELL_UNIT_COUNT, (Object)BigInteger.ZERO);
        AEItemKey determiningKey = this.storedItem != null ? this.storedItem : this.filterItem;
        Item determiningItem = determiningKey != null ? determiningKey.getItem() : null;
        this.compressionChain = CompressionService.getChain(determiningItem);
        this.unitFactor = this.compressionChain.unitFactor(determiningItem);
        BigInteger recordedFactor = (BigInteger)stack.getOrDefault(MEGAComponents.BULK_CELL_UNIT_FACTOR, (Object)this.unitFactor);
        if (!this.unitFactor.equals(recordedFactor)) {
            this.unitCount = this.unitCount.multiply(this.unitFactor).divide(recordedFactor);
            stack.set(MEGAComponents.BULK_CELL_UNIT_COUNT, (Object)this.unitCount);
            stack.set(MEGAComponents.BULK_CELL_UNIT_FACTOR, (Object)this.unitFactor);
        }
        this.compressionCutoff = (recordedCutoff = ((Integer)stack.getOrDefault(MEGAComponents.BULK_CELL_COMPRESSION_CUTOFF, (Object)(maxCutoff = Math.max(0, this.compressionChain.size() - 1)))).intValue()) < 0 ? maxCutoff : Math.min(recordedCutoff, maxCutoff);
        this.compressedStacks = this.compressionChain.initStacks(this.unitCount, this.compressionCutoff, determiningItem);
    }

    public CellState getStatus() {
        if (this.storedItem == null || this.unitCount.signum() < 1) {
            return CellState.EMPTY;
        }
        if (this.isFilterMismatched()) {
            return CellState.FULL;
        }
        return CellState.NOT_EMPTY;
    }

    AEItemKey getStoredItem() {
        return this.storedItem;
    }

    long getStoredQuantity() {
        return CompressionChain.clamp(this.unitCount.divide(this.unitFactor), Long.MAX_VALUE);
    }

    AEItemKey getFilterItem() {
        return this.filterItem;
    }

    private boolean isFilterMismatched() {
        if (this.storedItem == null) {
            return false;
        }
        if (this.storedItem.equals((Object)this.filterItem)) {
            return false;
        }
        if (this.filterItem == null) {
            return true;
        }
        if (this.compressionChain.containsVariant(this.filterItem.getItem())) {
            this.storedItem = this.filterItem;
            this.unitFactor = this.compressionChain.unitFactor(this.storedItem.getItem());
            this.saveChanges();
            return false;
        }
        return true;
    }

    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    public boolean hasCompressionChain() {
        return !this.compressionChain.isEmpty();
    }

    long getTraceUnits() {
        return CompressionChain.clamp(this.unitCount.remainder(this.unitFactor), Long.MAX_VALUE);
    }

    public List<IPatternDetails> getDecompressionPatterns() {
        if (this.filterItem == null || !this.compressionEnabled || !this.hasCompressionChain() || this.isFilterMismatched()) {
            return List.of();
        }
        if (this.decompressionPatterns == null) {
            this.decompressionPatterns = this.compressionChain.getDecompressionPatterns(this.compressionCutoff);
        }
        return this.decompressionPatterns;
    }

    public double getIdleDrain() {
        return 5.0;
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (amount == 0L || !(what instanceof AEItemKey)) {
            return 0L;
        }
        AEItemKey item = (AEItemKey)what;
        if (this.isFilterMismatched()) {
            return 0L;
        }
        if (!(item.equals((Object)this.filterItem) || this.compressionEnabled && this.compressionChain.containsVariant(item.getItem()))) {
            return 0L;
        }
        BigInteger factor = this.compressionChain.unitFactor(item.getItem());
        BigInteger units = BigInteger.valueOf(amount).multiply(factor);
        if (mode == Actionable.MODULATE) {
            if (this.storedItem == null) {
                this.storedItem = this.filterItem;
            }
            this.updateContents(units);
        }
        return amount;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (this.storedItem == null || this.unitCount.signum() < 1 || !(what instanceof AEItemKey)) {
            return 0L;
        }
        AEItemKey item = (AEItemKey)what;
        if (!this.compressionChain.containsVariant(item.getItem()) && !item.equals((Object)this.storedItem)) {
            return 0L;
        }
        if (this.isFilterMismatched()) {
            amount = Math.min(amount, this.getAvailableStacks().get((AEKey)item));
        } else if (!this.compressionEnabled && !item.equals((Object)this.storedItem)) {
            return 0L;
        }
        BigInteger factor = this.compressionChain.unitFactor(item.getItem());
        BigInteger units = BigInteger.valueOf(amount).multiply(factor).min(this.unitCount);
        if (mode == Actionable.MODULATE) {
            this.updateContents(units.negate());
        }
        return CompressionChain.clamp(units.divide(factor), Long.MAX_VALUE);
    }

    private void updateContents(BigInteger unitsToAdd) {
        this.unitCount = this.unitCount.add(unitsToAdd);
        if (this.unitCount.signum() < 1) {
            this.storedItem = null;
            Item filter = this.filterItem != null ? this.filterItem.getItem() : null;
            this.compressionChain = CompressionService.getChain(filter);
            this.compressionCutoff = Math.max(0, this.compressionChain.size() - 1);
            this.compressedStacks = this.compressionChain.initStacks(this.unitCount, this.compressionCutoff, filter);
        } else {
            this.compressionChain.updateStacks(this.compressedStacks, unitsToAdd, this.compressionCutoff);
        }
        this.saveChanges();
    }

    private void saveChanges() {
        this.isPersisted = false;
        if (this.container != null) {
            this.container.saveChanges();
        } else {
            this.persist();
        }
    }

    public void persist() {
        if (this.isPersisted) {
            return;
        }
        if (this.storedItem == null || this.unitCount.signum() < 1) {
            this.stack.remove(MEGAComponents.BULK_CELL_ITEM);
            this.stack.remove(MEGAComponents.BULK_CELL_UNIT_COUNT);
            this.stack.remove(MEGAComponents.BULK_CELL_UNIT_FACTOR);
        } else {
            this.stack.set(MEGAComponents.BULK_CELL_ITEM, (Object)this.storedItem);
            this.stack.set(MEGAComponents.BULK_CELL_UNIT_COUNT, (Object)this.unitCount);
            this.stack.set(MEGAComponents.BULK_CELL_UNIT_FACTOR, (Object)this.unitFactor);
        }
        if (this.hasCompressionChain()) {
            this.stack.set(MEGAComponents.BULK_CELL_COMPRESSION_CUTOFF, (Object)this.compressionCutoff);
        } else {
            this.stack.remove(MEGAComponents.BULK_CELL_COMPRESSION_CUTOFF);
        }
        this.isPersisted = true;
    }

    public void switchCompressionCutoff(boolean backwards) {
        if (!this.hasCompressionChain()) {
            return;
        }
        int newCutoff = this.compressionCutoff;
        newCutoff += backwards ? 1 : -1;
        this.compressionCutoff = newCutoff %= this.compressionChain.size();
        this.stack.set(MEGAComponents.BULK_CELL_COMPRESSION_CUTOFF, (Object)this.compressionCutoff);
        this.decompressionPatterns = null;
    }

    public Item getCutoffItem() {
        return this.hasCompressionChain() ? this.compressionChain.getItem(this.compressionCutoff) : null;
    }

    Item getHighestVariant() {
        return this.hasCompressionChain() ? this.compressionChain.getItem(this.compressionChain.size() - 1) : null;
    }

    Item getLowestVariant() {
        return this.hasCompressionChain() ? this.compressionChain.getItem(0) : null;
    }

    public void getAvailableStacks(KeyCounter out) {
        if (this.storedItem != null) {
            if (this.compressionEnabled) {
                this.compressedStacks.forEach((item, amount) -> out.add((AEKey)AEItemKey.of((ItemLike)item), amount.longValue()));
            } else {
                out.add((AEKey)this.storedItem, CompressionChain.clamp(this.unitCount.divide(this.unitFactor), CompressionChain.STACK_LIMIT));
                if (this.isFilterMismatched()) {
                    this.compressedStacks.keySet().stream().takeWhile(i -> !this.storedItem.is((ItemLike)i)).forEach(i -> out.add((AEKey)AEItemKey.of((ItemLike)i), this.compressedStacks.get(i).longValue()));
                }
            }
        }
    }

    public boolean isPreferredStorageFor(AEKey what, IActionSource source) {
        AEItemKey item;
        return what instanceof AEItemKey && ((item = (AEItemKey)what).equals((Object)this.storedItem) || item.equals((Object)this.filterItem) || this.compressionChain.containsVariant(item.getItem()));
    }

    public boolean canFitInsideCell() {
        return this.filterItem == null && this.storedItem == null && this.unitCount.signum() < 1;
    }

    public Component getDescription() {
        return this.stack.getHoverName();
    }
}

