/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.definition;

import appeng.block.AEBaseBlock;
import appeng.block.AEBaseBlockItem;
import appeng.block.crafting.CraftingBlockItem;
import appeng.block.crafting.CraftingMonitorBlock;
import appeng.block.crafting.CraftingUnitBlock;
import appeng.block.crafting.ICraftingUnitType;
import appeng.block.networking.EnergyCellBlock;
import appeng.block.networking.EnergyCellBlockItem;
import appeng.core.definitions.BlockDefinition;
import appeng.core.definitions.ItemDefinition;
import appeng.decorative.AEDecorativeBlock;
import gripe._90.megacells.block.MEGACraftingUnitType;
import gripe._90.megacells.block.MEGAInterfaceBlock;
import gripe._90.megacells.block.MEGAPatternProviderBlock;
import gripe._90.megacells.block.MEGAPatternProviderBlockItem;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.definition.MEGATranslations;
import gripe._90.megacells.integration.Addons;
import gripe._90.megacells.integration.DummyIntegrationBlock;
import gripe._90.megacells.integration.appliede.MEGAEMCInterfaceBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class MEGABlocks {
    public static final DeferredRegister.Blocks DR = DeferredRegister.createBlocks((String)"megacells");
    private static final List<BlockDefinition<?>> BLOCKS = new ArrayList();
    public static final BlockDefinition<AEDecorativeBlock> SKY_STEEL_BLOCK = MEGABlocks.block("Sky Steel Block", "sky_steel_block", () -> new AEDecorativeBlock(BlockBehaviour.Properties.of().strength(5.0f, 12.0f).requiresCorrectToolForDrops().mapColor(MapColor.METAL).sound(SoundType.METAL)), (b, p) -> new AEBaseBlockItem(b, p.fireResistant()));
    public static final BlockDefinition<AEDecorativeBlock> SKY_BRONZE_BLOCK = MEGABlocks.block("Sky Bronze Block", "sky_bronze_block", () -> new AEDecorativeBlock(BlockBehaviour.Properties.of().strength(3.0f, 12.0f).requiresCorrectToolForDrops().mapColor(MapColor.METAL).sound(SoundType.METAL)), (b, p) -> new AEBaseBlockItem(b, p.fireResistant()));
    public static final BlockDefinition<?> SKY_OSMIUM_BLOCK = MEGABlocks.integrationBlock("Sky Osmium Block", "sky_osmium_block", () -> AEDecorativeBlock::new, BlockBehaviour.Properties.of().strength(7.5f, 24.0f).requiresCorrectToolForDrops().mapColor(MapColor.METAL).sound(SoundType.METAL), (b, p) -> new AEBaseBlockItem(b, p.fireResistant()), Addons.APPMEK);
    public static final BlockDefinition<EnergyCellBlock> MEGA_ENERGY_CELL = MEGABlocks.block("Superdense Energy Cell", "mega_energy_cell", () -> new EnergyCellBlock(1.28E7, 3200.0, 12800), EnergyCellBlockItem::new);
    public static final BlockDefinition<CraftingUnitBlock> MEGA_CRAFTING_UNIT = MEGABlocks.block("MEGA Crafting Unit", "mega_crafting_unit", () -> new CraftingUnitBlock((ICraftingUnitType)MEGACraftingUnitType.UNIT), AEBaseBlockItem::new);
    public static final BlockDefinition<CraftingUnitBlock> CRAFTING_ACCELERATOR = MEGABlocks.block("MEGA Crafting Co-Processing Unit", "mega_crafting_accelerator", () -> new CraftingUnitBlock((ICraftingUnitType)MEGACraftingUnitType.ACCELERATOR), (block, props) -> new CraftingBlockItem((Block)block, (Item.Properties)props){

        public void addCheckedInformation(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag adv) {
            lines.add((Component)MEGATranslations.AcceleratorThreads.text());
        }
    });
    public static final BlockDefinition<CraftingUnitBlock> CRAFTING_STORAGE_1M = MEGABlocks.block("1M MEGA Crafting Storage", "1m_crafting_storage", () -> new CraftingUnitBlock((ICraftingUnitType)MEGACraftingUnitType.STORAGE_1M), CraftingBlockItem::new);
    public static final BlockDefinition<CraftingUnitBlock> CRAFTING_STORAGE_4M = MEGABlocks.block("4M MEGA Crafting Storage", "4m_crafting_storage", () -> new CraftingUnitBlock((ICraftingUnitType)MEGACraftingUnitType.STORAGE_4M), CraftingBlockItem::new);
    public static final BlockDefinition<CraftingUnitBlock> CRAFTING_STORAGE_16M = MEGABlocks.block("16M MEGA Crafting Storage", "16m_crafting_storage", () -> new CraftingUnitBlock((ICraftingUnitType)MEGACraftingUnitType.STORAGE_16M), CraftingBlockItem::new);
    public static final BlockDefinition<CraftingUnitBlock> CRAFTING_STORAGE_64M = MEGABlocks.block("64M MEGA Crafting Storage", "64m_crafting_storage", () -> new CraftingUnitBlock((ICraftingUnitType)MEGACraftingUnitType.STORAGE_64M), CraftingBlockItem::new);
    public static final BlockDefinition<CraftingUnitBlock> CRAFTING_STORAGE_256M = MEGABlocks.block("256M MEGA Crafting Storage", "256m_crafting_storage", () -> new CraftingUnitBlock((ICraftingUnitType)MEGACraftingUnitType.STORAGE_256M), CraftingBlockItem::new);
    public static final BlockDefinition<CraftingMonitorBlock> CRAFTING_MONITOR = MEGABlocks.block("MEGA Crafting Monitor", "mega_crafting_monitor", () -> new CraftingMonitorBlock((ICraftingUnitType)MEGACraftingUnitType.MONITOR), CraftingBlockItem::new);
    public static final BlockDefinition<MEGAInterfaceBlock> MEGA_INTERFACE = MEGABlocks.block("MEGA Interface", "mega_interface", MEGAInterfaceBlock::new, AEBaseBlockItem::new);
    public static final BlockDefinition<MEGAPatternProviderBlock> MEGA_PATTERN_PROVIDER = MEGABlocks.block("MEGA Pattern Provider", "mega_pattern_provider", MEGAPatternProviderBlock::new, MEGAPatternProviderBlockItem::new);
    public static final BlockDefinition<?> MEGA_EMC_INTERFACE = MEGABlocks.integrationBlock("MEGA Transmutation Interface", "mega_emc_interface", () -> MEGAEMCInterfaceBlock::new, AEBaseBlock.metalProps(), AEBaseBlockItem::new, Addons.APPLIEDE);

    public static List<BlockDefinition<?>> getBlocks() {
        return Collections.unmodifiableList(BLOCKS);
    }

    private static <T extends Block> BlockDefinition<T> block(String englishName, String id, Supplier<T> blockSupplier, BiFunction<Block, Item.Properties, BlockItem> itemFactory) {
        DeferredBlock block = DR.register(id, blockSupplier);
        DeferredItem item = MEGAItems.DR.register(id, () -> (BlockItem)itemFactory.apply((Block)block.get(), new Item.Properties()));
        BlockDefinition definition = new BlockDefinition(englishName, block, new ItemDefinition(englishName, item));
        BLOCKS.add(definition);
        return definition;
    }

    private static BlockDefinition<?> integrationBlock(String englishName, String id, Supplier<Function<BlockBehaviour.Properties, Block>> blockFactory, BlockBehaviour.Properties blockProps, BiFunction<Block, Item.Properties, BlockItem> itemFactory, Addons addon) {
        if (!addon.isLoaded()) {
            return MEGABlocks.block(englishName, id, () -> new DummyIntegrationBlock(blockProps), (b, p) -> new DummyIntegrationBlock.Item((Block)b, (Item.Properties)p, addon));
        }
        return MEGABlocks.block(englishName, id, () -> (Block)((Function)blockFactory.get()).apply(blockProps), itemFactory);
    }
}

