/*
 * Decompiled with CFR 0.152.
 */
package com.mcwfurnitures.kikoz.storage;

import com.mcwfurnitures.kikoz.init.EntityInit;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class ChairEntity
extends Entity {
    private BlockPos chair;

    public ChairEntity(EntityType<ChairEntity> type, Level world) {
        super(type, world);
    }

    public ChairEntity(Level world, BlockPos pos) {
        super((EntityType)EntityInit.CHAIR.get(), world);
        this.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.75, (double)pos.getZ() + 0.5);
        this.noPhysics = true;
    }

    protected void readAdditionalSaveData(CompoundTag pCompound) {
    }

    protected void addAdditionalSaveData(CompoundTag pCompound) {
    }

    protected boolean canRide(Entity entity) {
        return true;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        return new ClientboundAddEntityPacket((Entity)this, entity);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && (this.getPassengers().isEmpty() || this.level().isEmptyBlock(this.blockPosition()))) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public static ItemInteractionResult create(Level level, BlockPos pos, Player player) {
        List seatsInThisBlock;
        if (!level.isClientSide() && (seatsInThisBlock = level.getEntitiesOfClass(ChairEntity.class, new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)pos.getX() + 1.0, (double)pos.getY() + 2.0, (double)pos.getZ() + 1.0))).isEmpty()) {
            ChairEntity chair = new ChairEntity(level, pos);
            level.addFreshEntity((Entity)chair);
            player.startRiding((Entity)chair);
        }
        return ItemInteractionResult.SUCCESS;
    }
}

