/*
 * Decompiled with CFR 0.152.
 */
package com.mcwfurnitures.kikoz.objects;

import com.mcwfurnitures.kikoz.objects.FurnitureObject;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Desk
extends FurnitureObject {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<ConnectionStatus> CONNECTION = EnumProperty.create((String)"connection", ConnectionStatus.class, (Enum[])new ConnectionStatus[]{ConnectionStatus.SINGLE, ConnectionStatus.MIDDLE, ConnectionStatus.LEFT, ConnectionStatus.RIGHT});
    protected static final VoxelShape NORTH_BASE = Shapes.or((VoxelShape)Block.box((double)1.77, (double)0.0, (double)1.0, (double)2.0, (double)14.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.1, (double)14.0, (double)0.1, (double)16.1, (double)16.0, (double)16.1), Block.box((double)2.0, (double)12.0, (double)2.0, (double)14.0, (double)14.0, (double)3.0), Block.box((double)2.0, (double)0.0, (double)13.0, (double)16.0, (double)14.0, (double)15.0), Block.box((double)2.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)3.0)});
    protected static final VoxelShape NORTH_MIDDLE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)15.9, (double)16.0));
    protected static final VoxelShape NORTH_RIGHT = Shapes.or((VoxelShape)Block.box((double)2.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)3.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)1.0, (double)2.0, (double)14.0, (double)16.0), Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    protected static final VoxelShape NORTH_LEFT = Shapes.or((VoxelShape)Block.box((double)2.0, (double)0.0, (double)13.0, (double)16.0, (double)14.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0), Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    protected static final VoxelShape EAST_BASE = Shapes.or((VoxelShape)Block.box((double)1.1, (double)0.0, (double)0.1, (double)15.1, (double)14.0, (double)2.1), (VoxelShape[])new VoxelShape[]{Block.box((double)0.1, (double)14.0, (double)0.1, (double)16.1, (double)16.0, (double)16.1), Block.box((double)13.1, (double)12.0, (double)2.1, (double)14.1, (double)14.0, (double)14.1), Block.box((double)1.1, (double)0.0, (double)2.1, (double)3.1, (double)14.0, (double)16.1), Block.box((double)13.1, (double)0.0, (double)2.1, (double)15.1, (double)14.0, (double)16.1)});
    protected static final VoxelShape EAST_MIDDLE = Shapes.or((VoxelShape)Block.box((double)0.1, (double)0.0, (double)0.1, (double)16.1, (double)14.0, (double)2.1), (VoxelShape)Block.box((double)0.1, (double)14.0, (double)0.1, (double)16.1, (double)15.9, (double)16.1));
    protected static final VoxelShape EAST_RIGHT = Shapes.or((VoxelShape)Block.box((double)0.1, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)2.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.1, (double)14.0, (double)0.0, (double)16.1, (double)16.0, (double)16.1), Block.box((double)13.1, (double)0.0, (double)2.0, (double)15.0, (double)14.0, (double)16.0)});
    protected static final VoxelShape EAST_LEFT = Shapes.or((VoxelShape)Block.box((double)1.1, (double)0.0, (double)0.1, (double)16.1, (double)14.0, (double)2.1), (VoxelShape[])new VoxelShape[]{Block.box((double)0.1, (double)14.0, (double)0.1, (double)16.1, (double)16.0, (double)16.1), Block.box((double)1.1, (double)0.0, (double)2.1, (double)3.1, (double)14.0, (double)16.1)});
    protected static final VoxelShape SOUTH_BASE = Shapes.or((VoxelShape)Block.box((double)14.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)2.0, (double)12.0, (double)13.0, (double)14.0, (double)14.0, (double)14.0), Block.box((double)0.0, (double)0.0, (double)1.0, (double)14.0, (double)14.0, (double)3.0), Block.box((double)0.0, (double)0.0, (double)13.0, (double)14.0, (double)14.0, (double)15.0)});
    protected static final VoxelShape SOUTH_MIDDLE = Shapes.or((VoxelShape)Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)15.9, (double)16.0));
    protected static final VoxelShape SOUTH_RIGHT = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)13.0, (double)14.0, (double)14.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)15.0), Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    protected static final VoxelShape SOUTH_LEFT = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)1.0, (double)14.0, (double)14.0, (double)3.0), (VoxelShape[])new VoxelShape[]{Block.box((double)14.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)16.0), Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    protected static final VoxelShape WEST_BASE = Shapes.or((VoxelShape)Block.box((double)1.1, (double)0.0, (double)14.1, (double)15.1, (double)14.0, (double)16.1), (VoxelShape[])new VoxelShape[]{Block.box((double)0.1, (double)14.0, (double)0.1, (double)16.1, (double)16.0, (double)16.1), Block.box((double)2.1, (double)12.0, (double)2.1, (double)3.1, (double)14.0, (double)14.1), Block.box((double)13.1, (double)0.0, (double)0.1, (double)15.1, (double)14.0, (double)14.1), Block.box((double)1.1, (double)0.0, (double)0.1, (double)3.1, (double)14.0, (double)14.1)});
    protected static final VoxelShape WEST_MIDDLE = Shapes.or((VoxelShape)Block.box((double)0.1, (double)0.0, (double)14.1, (double)16.1, (double)14.0, (double)16.1), (VoxelShape)Block.box((double)0.1, (double)14.0, (double)0.1, (double)16.1, (double)15.9, (double)16.1));
    protected static final VoxelShape WEST_RIGHT = Shapes.or((VoxelShape)Block.box((double)0.1, (double)0.0, (double)14.1, (double)15.1, (double)14.0, (double)16.1), (VoxelShape[])new VoxelShape[]{Block.box((double)0.1, (double)14.0, (double)0.1, (double)15.1, (double)16.0, (double)16.1), Block.box((double)0.1, (double)0.0, (double)0.1, (double)2.1, (double)14.0, (double)14.1)});
    protected static final VoxelShape WEST_LEFT = Shapes.or((VoxelShape)Block.box((double)0.1, (double)0.0, (double)14.1, (double)15.1, (double)14.0, (double)16.1), (VoxelShape[])new VoxelShape[]{Block.box((double)0.1, (double)14.0, (double)0.1, (double)16.1, (double)16.0, (double)16.1), Block.box((double)13.1, (double)0.0, (double)0.1, (double)15.1, (double)14.0, (double)14.1)});

    public Desk(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(CONNECTION, (Comparable)((Object)ConnectionStatus.SINGLE)));
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        ConnectionStatus connectionStatus = (ConnectionStatus)((Object)state.getValue(CONNECTION));
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: {
                if (connectionStatus == ConnectionStatus.MIDDLE) {
                    return NORTH_MIDDLE;
                }
                if (connectionStatus == ConnectionStatus.LEFT) {
                    return NORTH_LEFT;
                }
                if (connectionStatus == ConnectionStatus.RIGHT) {
                    return NORTH_RIGHT;
                }
                return NORTH_BASE;
            }
            case SOUTH: {
                if (connectionStatus == ConnectionStatus.MIDDLE) {
                    return SOUTH_MIDDLE;
                }
                if (connectionStatus == ConnectionStatus.RIGHT) {
                    return SOUTH_RIGHT;
                }
                if (connectionStatus == ConnectionStatus.LEFT) {
                    return SOUTH_LEFT;
                }
                return SOUTH_BASE;
            }
            case WEST: {
                if (connectionStatus == ConnectionStatus.MIDDLE) {
                    return WEST_MIDDLE;
                }
                if (connectionStatus == ConnectionStatus.RIGHT) {
                    return WEST_RIGHT;
                }
                if (connectionStatus == ConnectionStatus.LEFT) {
                    return WEST_LEFT;
                }
                return WEST_BASE;
            }
        }
        if (connectionStatus == ConnectionStatus.MIDDLE) {
            return EAST_MIDDLE;
        }
        if (connectionStatus == ConnectionStatus.LEFT) {
            return EAST_LEFT;
        }
        if (connectionStatus == ConnectionStatus.RIGHT) {
            return EAST_RIGHT;
        }
        return EAST_BASE;
    }

    @Override
    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    private BlockState TableState(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean north = level.getBlockState(pos.north()).getBlock() == this;
        boolean east = level.getBlockState(pos.east()).getBlock() == this;
        boolean south = level.getBlockState(pos.south()).getBlock() == this;
        boolean west = level.getBlockState(pos.west()).getBlock() == this;
        ConnectionStatus connection = this.getConnectionStatus((Direction)state.getValue((Property)FACING), north, east, south, west);
        return (BlockState)state.setValue(CONNECTION, (Comparable)((Object)connection));
    }

    private ConnectionStatus getConnectionStatus(Direction facing, boolean north, boolean east, boolean south, boolean west) {
        if (facing == Direction.NORTH) {
            if (north && south && !east && !west) {
                return ConnectionStatus.MIDDLE;
            }
            if (!north && south && !east && !west) {
                return ConnectionStatus.RIGHT;
            }
            if (north && !south && !east && !west) {
                return ConnectionStatus.LEFT;
            }
        }
        if (facing == Direction.SOUTH) {
            if (north && south && !east && !west) {
                return ConnectionStatus.MIDDLE;
            }
            if (!north && south && !east && !west) {
                return ConnectionStatus.LEFT;
            }
            if (north && !south && !east && !west) {
                return ConnectionStatus.RIGHT;
            }
        }
        if (facing == Direction.EAST) {
            if (!north && !south && east && west) {
                return ConnectionStatus.MIDDLE;
            }
            if (!north && !south && east && !west) {
                return ConnectionStatus.LEFT;
            }
            if (!north && !south && !east && west) {
                return ConnectionStatus.RIGHT;
            }
        }
        if (facing == Direction.WEST) {
            if (!north && !south && east && west) {
                return ConnectionStatus.MIDDLE;
            }
            if (!north && !south && east && !west) {
                return ConnectionStatus.RIGHT;
            }
            if (!north && !south && !east && west) {
                return ConnectionStatus.LEFT;
            }
        }
        return ConnectionStatus.SINGLE;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState statetwo, boolean bolean) {
        if (!statetwo.is(state.getBlock())) {
            this.TableState(state, (LevelAccessor)level, pos);
        }
    }

    @Override
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, CONNECTION});
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity livent, ItemStack stack) {
        this.TableState(state, (LevelAccessor)level, pos);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        return this.TableState(state, level, pos);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.TableState(super.getStateForPlacement(context), (LevelAccessor)context.getLevel(), context.getClickedPos()).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getClockWise());
    }

    public void placeAt(Level level, BlockPos pos, int number) {
        level.setBlock(pos, this.defaultBlockState(), number);
    }

    public static enum ConnectionStatus implements StringRepresentable
    {
        SINGLE("single"),
        MIDDLE("middle"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private ConnectionStatus(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

