/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.gui.GuiParser;
import mcjty.lib.varia.Tools;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.items.IItemHandler;

public class ItemStackTools {
    private static Set<TagKey<Item>> commonTags = null;

    @Nonnull
    public static ItemStack extractItem(@Nullable BlockEntity tileEntity, int slot, int amount) {
        if (tileEntity == null) {
            return ItemStack.EMPTY;
        }
        IItemHandler handler = (IItemHandler)tileEntity.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, tileEntity.getBlockPos(), null);
        if (handler != null) {
            return handler.extractItem(slot, amount, false);
        }
        return ItemStack.EMPTY;
    }

    @Nonnull
    public static ItemStack getStack(@Nullable BlockEntity tileEntity, int slot) {
        if (tileEntity == null) {
            return ItemStack.EMPTY;
        }
        IItemHandler h = (IItemHandler)tileEntity.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, tileEntity.getBlockPos(), null);
        if (h != null) {
            return h.getStackInSlot(slot);
        }
        return ItemStack.EMPTY;
    }

    public static GuiParser.GuiCommand itemStackToGuiCommand(String name, ItemStack item) {
        GuiParser.GuiCommand object = new GuiParser.GuiCommand(name);
        object.parameter(Tools.getId(item).toString());
        object.parameter(item.getCount());
        return object;
    }

    public static ItemStack guiCommandToItemStack(GuiParser.GuiCommand obj) {
        String itemName = obj.getOptionalPar(0, "minecraft:stick");
        Item item = Tools.getItem(ResourceLocation.parse((String)itemName));
        int amount = obj.getOptionalPar(1, 1);
        ItemStack stack = new ItemStack((ItemLike)item, amount);
        return stack;
    }

    public static void addCommonTags(Collection<TagKey<Item>> fromItem, Set<TagKey<Item>> tags) {
        ItemStackTools.findCommonTags();
        for (TagKey<Item> id : fromItem) {
            if (!commonTags.contains(id)) continue;
            tags.add(id);
        }
    }

    public static boolean hasCommonTag(Collection<TagKey<Item>> fromItem) {
        ItemStackTools.findCommonTags();
        for (TagKey<Item> id : fromItem) {
            if (!commonTags.contains(id)) continue;
            return true;
        }
        return false;
    }

    private static void findCommonTags() {
        if (commonTags == null) {
            commonTags = new HashSet<TagKey<Item>>();
            commonTags.add((TagKey<Item>)ItemTags.SAND);
            commonTags.add((TagKey<Item>)ItemTags.FENCES);
            commonTags.add((TagKey<Item>)ItemTags.SAPLINGS);
            commonTags.add((TagKey<Item>)ItemTags.LEAVES);
            commonTags.add((TagKey<Item>)ItemTags.LOGS);
            commonTags.add((TagKey<Item>)ItemTags.RAILS);
            commonTags.add((TagKey<Item>)ItemTags.SLABS);
            commonTags.add((TagKey<Item>)ItemTags.WOOL);
            commonTags.add((TagKey<Item>)ItemTags.WOOL_CARPETS);
            commonTags.add((TagKey<Item>)ItemTags.PLANKS);
            commonTags.add((TagKey<Item>)ItemTags.STAIRS);
            commonTags.add((TagKey<Item>)ItemTags.DIRT);
            commonTags.add((TagKey<Item>)Tags.Items.CROPS);
            commonTags.add((TagKey<Item>)Tags.Items.GLASS_BLOCKS);
            commonTags.add((TagKey<Item>)Tags.Items.GLASS_PANES);
            commonTags.add((TagKey<Item>)Tags.Items.CHESTS);
            commonTags.add((TagKey<Item>)Tags.Items.COBBLESTONES);
            commonTags.add((TagKey<Item>)Tags.Items.NETHERRACKS);
            commonTags.add((TagKey<Item>)Tags.Items.OBSIDIANS);
            commonTags.add((TagKey<Item>)Tags.Items.GRAVELS);
            commonTags.add((TagKey<Item>)Tags.Items.SANDS);
            commonTags.add((TagKey<Item>)Tags.Items.END_STONES);
            commonTags.add((TagKey<Item>)Tags.Items.STONES);
            commonTags.add((TagKey<Item>)Tags.Items.ORES_COAL);
            commonTags.add((TagKey<Item>)Tags.Items.ORES_DIAMOND);
            commonTags.add((TagKey<Item>)Tags.Items.ORES_EMERALD);
            commonTags.add((TagKey<Item>)Tags.Items.ORES_GOLD);
            commonTags.add((TagKey<Item>)Tags.Items.ORES_REDSTONE);
            commonTags.add((TagKey<Item>)Tags.Items.ORES_QUARTZ);
            commonTags.add((TagKey<Item>)Tags.Items.ORES_IRON);
            commonTags.add((TagKey<Item>)Tags.Items.ORES_LAPIS);
            commonTags.add((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"ores/copper")));
            commonTags.add((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"ores/tin")));
            commonTags.add((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"ores/silver")));
            commonTags.add((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"ores/manganese")));
            commonTags.add((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"ores/platinum")));
            commonTags.add((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_COAL);
            commonTags.add((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_DIAMOND);
            commonTags.add((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_EMERALD);
            commonTags.add((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_GOLD);
            commonTags.add((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_REDSTONE);
            commonTags.add((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_IRON);
            commonTags.add((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_LAPIS);
            commonTags.add((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"storage_blocks/copper")));
            commonTags.add((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"storage_blocks/tin")));
            commonTags.add((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"storage_blocks/silver")));
            commonTags.add((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"storage_blocks/manganese")));
            commonTags.add((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"storage_blocks/platinum")));
        }
    }
}

