/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import mcjty.lib.api.power.IBigPower;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.varia.IEnergyItem;
import mcjty.lib.varia.OrientationTools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EnergyTools {
    public static boolean isEnergyTE(BlockEntity te, @Nullable Direction side) {
        if (te == null) {
            return false;
        }
        return te.getLevel().getCapability(Capabilities.EnergyStorage.BLOCK, te.getBlockPos(), (Object)side) != null;
    }

    public static boolean isEnergyItem(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof IEnergyItem) {
            return true;
        }
        return stack.getCapability(Capabilities.EnergyStorage.ITEM) != null;
    }

    public static EnergyLevel getEnergyLevelMulti(BlockEntity tileEntity, @Nullable Direction side) {
        long energyStored;
        long maxEnergyStored;
        if (tileEntity instanceof IBigPower) {
            maxEnergyStored = ((IBigPower)tileEntity).getCapacity();
            energyStored = ((IBigPower)tileEntity).getStoredPower();
        } else if (tileEntity != null) {
            IEnergyStorage capability = (IEnergyStorage)tileEntity.getLevel().getCapability(Capabilities.EnergyStorage.BLOCK, tileEntity.getBlockPos(), (Object)side);
            if (capability == null) {
                maxEnergyStored = 0L;
                energyStored = 0L;
            } else {
                maxEnergyStored = capability.getMaxEnergyStored();
                energyStored = capability.getEnergyStored();
            }
        } else {
            maxEnergyStored = 0L;
            energyStored = 0L;
        }
        return new EnergyLevel(energyStored, maxEnergyStored);
    }

    public static EnergyLevel getEnergyLevel(BlockEntity tileEntity, @Nullable Direction side) {
        AtomicLong maxEnergyStored = new AtomicLong();
        AtomicLong energyStored = new AtomicLong();
        if (tileEntity != null) {
            IEnergyStorage handler = (IEnergyStorage)tileEntity.getLevel().getCapability(Capabilities.EnergyStorage.BLOCK, tileEntity.getBlockPos(), (Object)side);
            if (handler != null) {
                maxEnergyStored.set(handler.getMaxEnergyStored());
                energyStored.set(handler.getEnergyStored());
            }
        } else {
            maxEnergyStored.set(0L);
            energyStored.set(0L);
        }
        return new EnergyLevel(energyStored.get(), maxEnergyStored.get());
    }

    public static long receiveEnergy(BlockEntity tileEntity, Direction from, long maxReceive) {
        if (tileEntity != null) {
            IEnergyStorage handler = (IEnergyStorage)tileEntity.getLevel().getCapability(Capabilities.EnergyStorage.BLOCK, tileEntity.getBlockPos(), (Object)from);
            return handler != null ? (long)handler.receiveEnergy(EnergyTools.unsignedClampToInt(maxReceive), false) : 0L;
        }
        return 0L;
    }

    public static long receiveEnergy(ItemStack stack, long maxReceive) {
        Item item = stack.getItem();
        if (item instanceof IEnergyItem) {
            return ((IEnergyItem)item).receiveEnergyL(stack, maxReceive, false);
        }
        IEnergyStorage capability = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (capability != null) {
            return capability.receiveEnergy(EnergyTools.unsignedClampToInt(maxReceive), false);
        }
        return 0L;
    }

    public static int unsignedClampToInt(long l) {
        return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
    }

    public static int getIntEnergyStored(long energyStored, long maxEnergyStored) {
        return EnergyTools.unsignedClampToInt(energyStored);
    }

    public static void handleSendingEnergy(Level world, BlockPos pos, long storedPower, long sendPerTick, GenericEnergyStorage storage) {
        for (Direction facing : OrientationTools.DIRECTION_VALUES) {
            Direction opposite;
            BlockPos p = pos.relative(facing);
            BlockEntity te = world.getBlockEntity(p);
            if (!EnergyTools.isEnergyTE(te, opposite = facing.getOpposite())) continue;
            long rfToGive = Math.min(sendPerTick, storedPower);
            long received = EnergyTools.receiveEnergy(te, opposite, rfToGive);
            storage.consumeEnergy(received);
            if ((storedPower -= received) <= 0L) break;
        }
    }

    public record EnergyLevel(long energy, long maxEnergy) {
    }
}

