/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.client;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class RenderGlowEffect {
    private static final Quad[] QUADS = new Quad[]{new Quad(new Vt(0.0f, 0.0f, 0.0f), new Vt(1.0f, 0.0f, 0.0f), new Vt(1.0f, 0.0f, 1.0f), new Vt(0.0f, 0.0f, 1.0f)), new Quad(new Vt(0.0f, 1.0f, 1.0f), new Vt(1.0f, 1.0f, 1.0f), new Vt(1.0f, 1.0f, 0.0f), new Vt(0.0f, 1.0f, 0.0f)), new Quad(new Vt(1.0f, 1.0f, 0.0f), new Vt(1.0f, 0.0f, 0.0f), new Vt(0.0f, 0.0f, 0.0f), new Vt(0.0f, 1.0f, 0.0f)), new Quad(new Vt(1.0f, 0.0f, 1.0f), new Vt(1.0f, 1.0f, 1.0f), new Vt(0.0f, 1.0f, 1.0f), new Vt(0.0f, 0.0f, 1.0f)), new Quad(new Vt(0.0f, 0.0f, 1.0f), new Vt(0.0f, 1.0f, 1.0f), new Vt(0.0f, 1.0f, 0.0f), new Vt(0.0f, 0.0f, 0.0f)), new Quad(new Vt(1.0f, 0.0f, 0.0f), new Vt(1.0f, 1.0f, 0.0f), new Vt(1.0f, 1.0f, 1.0f), new Vt(1.0f, 0.0f, 1.0f))};

    public static void renderGlow(PoseStack matrixStack, MultiBufferSource buffer, ResourceLocation texture) {
        VertexConsumer builder = buffer.getBuffer(RenderType.translucent());
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(texture);
        Matrix4f matrix = matrixStack.last().pose();
        RenderGlowEffect.addSideFullTexture(matrix, builder, sprite, Direction.UP.ordinal(), 1.1f, -0.05f);
        RenderGlowEffect.addSideFullTexture(matrix, builder, sprite, Direction.DOWN.ordinal(), 1.1f, -0.05f);
        RenderGlowEffect.addSideFullTexture(matrix, builder, sprite, Direction.NORTH.ordinal(), 1.1f, -0.05f);
        RenderGlowEffect.addSideFullTexture(matrix, builder, sprite, Direction.SOUTH.ordinal(), 1.1f, -0.05f);
        RenderGlowEffect.addSideFullTexture(matrix, builder, sprite, Direction.WEST.ordinal(), 1.1f, -0.05f);
        RenderGlowEffect.addSideFullTexture(matrix, builder, sprite, Direction.EAST.ordinal(), 1.1f, -0.05f);
    }

    public static void addSideFullTexture(BufferBuilder buffer, int side, float mult, float offset, Vec3 offs) {
        int b1 = 0xF00000;
        int b2 = 240;
        Quad quad = QUADS[side];
        buffer.addVertex((float)(offs.x + (double)(quad.v1.x * mult) + (double)offset), (float)(offs.y + (double)(quad.v1.y * mult) + (double)offset), (float)(offs.z + (double)(quad.v1.z * mult) + (double)offset)).setUv(0.0f, 0.0f).setUv2(b1, b2).setColor(255, 255, 255, 128);
        buffer.addVertex((float)(offs.x + (double)(quad.v2.x * mult) + (double)offset), (float)(offs.y + (double)(quad.v2.y * mult) + (double)offset), (float)(offs.z + (double)(quad.v2.z * mult) + (double)offset)).setUv(0.0f, 1.0f).setUv2(b1, b2).setColor(255, 255, 255, 128);
        buffer.addVertex((float)(offs.x + (double)(quad.v3.x * mult) + (double)offset), (float)(offs.y + (double)(quad.v3.y * mult) + (double)offset), (float)(offs.z + (double)(quad.v3.z * mult) + (double)offset)).setUv(1.0f, 1.0f).setUv2(b1, b2).setColor(255, 255, 255, 128);
        buffer.addVertex((float)(offs.x + (double)(quad.v4.x * mult) + (double)offset), (float)(offs.y + (double)(quad.v4.y * mult) + (double)offset), (float)(offs.z + (double)(quad.v4.z * mult) + (double)offset)).setUv(1.0f, 0.0f).setUv2(b1, b2).setColor(255, 255, 255, 128);
    }

    public static void addSideFullTexture(Matrix4f positionMatrix, VertexConsumer buffer, TextureAtlasSprite sprite, int side, float mult, float offset) {
        int b1 = 0xF00000;
        int b2 = 240;
        Quad quad = QUADS[side];
        buffer.addVertex(positionMatrix, quad.v1.x * mult + offset, quad.v1.y * mult + offset, quad.v1.z * mult + offset).setColor(255, 255, 255, 128).setUv(sprite.getU0(), sprite.getV0()).setUv2(b1, b2).setNormal(1.0f, 0.0f, 0.0f);
        buffer.addVertex(positionMatrix, quad.v2.x * mult + offset, quad.v2.y * mult + offset, quad.v2.z * mult + offset).setColor(255, 255, 255, 128).setUv(sprite.getU0(), sprite.getV1()).setUv2(b1, b2).setNormal(1.0f, 0.0f, 0.0f);
        buffer.addVertex(positionMatrix, quad.v3.x * mult + offset, quad.v3.y * mult + offset, quad.v3.z * mult + offset).setColor(255, 255, 255, 128).setUv(sprite.getU1(), sprite.getV1()).setUv2(b1, b2).setNormal(1.0f, 0.0f, 0.0f);
        buffer.addVertex(positionMatrix, quad.v4.x * mult + offset, quad.v4.y * mult + offset, quad.v4.z * mult + offset).setColor(255, 255, 255, 128).setUv(sprite.getU1(), sprite.getV0()).setUv2(b1, b2).setNormal(1.0f, 0.0f, 0.0f);
    }

    private record Quad(Vt v1, Vt v2, Vt v3, Vt v4) {
        public Quad rotate(Direction direction) {
            return switch (direction) {
                case Direction.NORTH -> new Quad(this.v4, this.v1, this.v2, this.v3);
                case Direction.EAST -> new Quad(this.v3, this.v4, this.v1, this.v2);
                case Direction.SOUTH -> new Quad(this.v2, this.v3, this.v4, this.v1);
                case Direction.WEST -> this;
                default -> this;
            };
        }
    }

    private record Vt(float x, float y, float z) {
    }
}

