/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicSupport;
import mcjty.lib.varia.LogicFacing;
import mcjty.lib.varia.OrientationTools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LogicSlabBlock
extends BaseBlock {
    public static final EnumProperty<LogicFacing> LOGIC_FACING = EnumProperty.create((String)"logic_facing", LogicFacing.class);
    public static final VoxelShape BLOCK_DOWN = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.25, (double)1.0);
    public static final VoxelShape BLOCK_UP = Shapes.box((double)0.0, (double)0.75, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    public static final VoxelShape BLOCK_NORTH = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.25);
    public static final VoxelShape BLOCK_SOUTH = Shapes.box((double)0.0, (double)0.0, (double)0.75, (double)1.0, (double)1.0, (double)1.0);
    public static final VoxelShape BLOCK_WEST = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.25, (double)1.0, (double)1.0);
    public static final VoxelShape BLOCK_EAST = Shapes.box((double)0.75, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);

    public LogicSlabBlock(BlockBuilder builder) {
        super(builder);
    }

    public static Direction rotateLeft(Direction downSide, Direction inputSide) {
        return switch (downSide) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> inputSide.getClockWise();
            case Direction.UP -> inputSide.getCounterClockWise();
            case Direction.NORTH -> OrientationTools.rotateAround(inputSide, Direction.Axis.Z);
            case Direction.SOUTH -> OrientationTools.rotateAround(inputSide.getOpposite(), Direction.Axis.Z);
            case Direction.WEST -> OrientationTools.rotateAround(inputSide, Direction.Axis.X);
            case Direction.EAST -> OrientationTools.rotateAround(inputSide.getOpposite(), Direction.Axis.X);
        };
    }

    public static Direction rotateRight(Direction downSide, Direction inputSide) {
        return LogicSlabBlock.rotateLeft(downSide.getOpposite(), inputSide);
    }

    @Override
    public RotationType getRotationType() {
        return RotationType.NONE;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Vec3 hit = context.getClickLocation();
        BlockPos pos = context.getClickedPos();
        double hx = hit.x - (double)pos.getX();
        double hy = hit.y - (double)pos.getY();
        double hz = hit.z - (double)pos.getZ();
        double dx = Math.abs(0.5 - hx);
        double dy = Math.abs(0.5 - hy);
        double dz = Math.abs(0.5 - hz);
        Direction side = context.getClickedFace().getOpposite();
        return (BlockState)super.getStateForPlacement(context).setValue(LOGIC_FACING, (Comparable)((Object)(switch (side) {
            case Direction.DOWN -> {
                if (dx < dz) {
                    yield hz < 0.5 ? LogicFacing.DOWN_TOSOUTH : LogicFacing.DOWN_TONORTH;
                }
                yield hx < 0.5 ? LogicFacing.DOWN_TOEAST : LogicFacing.DOWN_TOWEST;
            }
            case Direction.UP -> {
                if (dx < dz) {
                    yield hz < 0.5 ? LogicFacing.UP_TOSOUTH : LogicFacing.UP_TONORTH;
                }
                yield hx < 0.5 ? LogicFacing.UP_TOEAST : LogicFacing.UP_TOWEST;
            }
            case Direction.NORTH -> {
                if (dx < dy) {
                    yield hy < 0.5 ? LogicFacing.NORTH_TOUP : LogicFacing.NORTH_TODOWN;
                }
                yield hx < 0.5 ? LogicFacing.NORTH_TOEAST : LogicFacing.NORTH_TOWEST;
            }
            case Direction.SOUTH -> {
                if (dx < dy) {
                    yield hy < 0.5 ? LogicFacing.SOUTH_TOUP : LogicFacing.SOUTH_TODOWN;
                }
                yield hx < 0.5 ? LogicFacing.SOUTH_TOEAST : LogicFacing.SOUTH_TOWEST;
            }
            case Direction.WEST -> {
                if (dy < dz) {
                    yield hz < 0.5 ? LogicFacing.WEST_TOSOUTH : LogicFacing.WEST_TONORTH;
                }
                yield hy < 0.5 ? LogicFacing.WEST_TOUP : LogicFacing.WEST_TODOWN;
            }
            case Direction.EAST -> {
                if (dy < dz) {
                    yield hz < 0.5 ? LogicFacing.EAST_TOSOUTH : LogicFacing.EAST_TONORTH;
                }
                yield hy < 0.5 ? LogicFacing.EAST_TOUP : LogicFacing.EAST_TODOWN;
            }
            default -> LogicFacing.DOWN_TOWEST;
        })));
    }

    @Nonnull
    public VoxelShape getShape(BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return switch (((LogicFacing)((Object)state.getValue(LOGIC_FACING))).getSide()) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> BLOCK_DOWN;
            case Direction.UP -> BLOCK_UP;
            case Direction.NORTH -> BLOCK_NORTH;
            case Direction.SOUTH -> BLOCK_SOUTH;
            case Direction.WEST -> BLOCK_WEST;
            case Direction.EAST -> BLOCK_EAST;
        };
    }

    protected int getInputStrength(Level world, BlockPos pos, Direction side) {
        BlockState blockState;
        Block b;
        int power = world.getSignal(pos.relative(side), side);
        if (power < 15 && (b = (blockState = world.getBlockState(pos.relative(side))).getBlock()) == Blocks.REDSTONE_WIRE) {
            power = Math.max(power, (Integer)blockState.getValue((Property)RedStoneWireBlock.POWER));
        }
        return power;
    }

    @Override
    @Deprecated
    protected void checkRedstone(Level world, BlockPos pos) {
        super.checkRedstone(world, pos);
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof GenericTileEntity) {
            GenericTileEntity generic = (GenericTileEntity)te;
            Direction inputSide = LogicSupport.getFacing(world.getBlockState(pos)).getInputSide();
            int power = this.getInputStrength(world, pos, inputSide);
            generic.setPowerInput(power);
        }
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        BlockEntity te = world.getBlockEntity(pos);
        if (state.getBlock() instanceof LogicSlabBlock && te instanceof GenericTileEntity) {
            Direction direction = LogicSupport.getFacing(state).getInputSide();
            return switch (direction) {
                default -> throw new MatchException(null, null);
                case Direction.NORTH, Direction.SOUTH -> {
                    if (side == Direction.NORTH || side == Direction.SOUTH) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.WEST, Direction.EAST -> {
                    if (side == Direction.WEST || side == Direction.EAST) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.DOWN, Direction.UP -> side == Direction.DOWN || side == Direction.UP;
            };
        }
        return false;
    }

    protected int getRedstoneOutput(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        BlockEntity te = world.getBlockEntity(pos);
        if (state.getBlock() instanceof LogicSlabBlock && te instanceof GenericTileEntity) {
            GenericTileEntity generic = (GenericTileEntity)te;
            return generic.getRedstoneOutput(state, world, pos, side);
        }
        return 0;
    }

    @Override
    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation rot) {
        if (state.getBlock() instanceof LogicSlabBlock) {
            LogicFacing facing = (LogicFacing)((Object)state.getValue(LOGIC_FACING));
            LogicFacing newfacing = LogicFacing.rotate(facing);
            BlockState newstate = (BlockState)state.getBlock().defaultBlockState().setValue(LOGIC_FACING, (Comparable)((Object)newfacing));
            world.setBlock(pos, newstate, 3);
            BlockEntity te = world.getBlockEntity(pos);
            if (te instanceof GenericTileEntity) {
                ((GenericTileEntity)te).rotateBlock(rot);
            }
            return newstate;
        }
        return state;
    }

    public boolean isSignalSource(@Nonnull BlockState state) {
        return true;
    }

    public int getSignal(@Nonnull BlockState blockState, @Nonnull BlockGetter blockAccess, @Nonnull BlockPos pos, @Nonnull Direction side) {
        return this.getRedstoneOutput(blockState, blockAccess, pos, side);
    }

    @Override
    protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LOGIC_FACING});
    }
}

