/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.util;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.ComponentItemHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.registries.DeferredHolder;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.capabilities.ModCapabilities;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.containers.MysticCodeInventoryType;
import stepsword.mahoutsukai.dataattachments.DataAttachments;
import stepsword.mahoutsukai.dataattachments.chunks.ChunkMahou;
import stepsword.mahoutsukai.dataattachments.chunks.IChunkMahou;
import stepsword.mahoutsukai.dataattachments.livingmahou.ILivingMahou;
import stepsword.mahoutsukai.dataattachments.mahou.IMahou;
import stepsword.mahoutsukai.dataattachments.settingsmahou.ISettingsMahou;
import stepsword.mahoutsukai.dataattachments.worldsave.MahouSavedData;
import stepsword.mahoutsukai.dataattachments.worldsave.WorldMahou;
import stepsword.mahoutsukai.datacomponents.CopyComponent;
import stepsword.mahoutsukai.datacomponents.DataComponents;
import stepsword.mahoutsukai.datacomponents.fog.FogProjectorEnchant;
import stepsword.mahoutsukai.datacomponents.gemmahou.GemMahou;
import stepsword.mahoutsukai.datacomponents.itemcolor.ColorMahou;
import stepsword.mahoutsukai.datacomponents.kodoku.KodokuMahou;
import stepsword.mahoutsukai.datacomponents.lance.LanceMahou;
import stepsword.mahoutsukai.datacomponents.modemahou.ModeMahou;
import stepsword.mahoutsukai.datacomponents.mysticcode.MysticCodeData;
import stepsword.mahoutsukai.datacomponents.projected.ProjectedMahou;
import stepsword.mahoutsukai.datacomponents.projectorenchant.ProjectorEnchant;
import stepsword.mahoutsukai.datacomponents.replica.ReplicaMahou;
import stepsword.mahoutsukai.datacomponents.rulebreaker.RuleBreakerMahou;
import stepsword.mahoutsukai.datacomponents.scrollmahou.ScrollMahou;
import stepsword.mahoutsukai.datacomponents.selectedtarget.SelectedTargetMahou;
import stepsword.mahoutsukai.datacomponents.stackholder.StackHolderMahou;
import stepsword.mahoutsukai.datacomponents.strengthening.StrengtheningMahou;
import stepsword.mahoutsukai.datacomponents.sword.SwordMahou;
import stepsword.mahoutsukai.entity.WeaponProjectileEntity;
import stepsword.mahoutsukai.fluids.ModFluids;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.MahouColor;

public class Utils {
    public static int[] primes = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337, 347, 349, 353, 359, 367, 373, 379, 383, 389, 397, 401, 409, 419, 421, 431, 433, 439, 443, 449, 457, 461, 463, 467, 479, 487, 491, 499, 503, 509, 521, 523, 541, 547, 557, 563, 569, 571, 577, 587, 593, 599, 601, 607, 613, 617, 619, 631, 641, 643, 647, 653, 659, 661, 673, 677, 683, 691, 701, 709, 719, 727, 733, 739, 743, 751, 757, 761, 769, 773, 787, 797, 809, 811, 821, 823, 827, 829, 839, 853, 857, 859, 863, 877, 881, 883, 887, 907, 911, 919, 929, 937, 941, 947, 953, 967, 971, 977, 983, 991, 997, 1009, 1013, 1019, 1021, 1031, 1033, 1039, 1049, 1051, 1061, 1063, 1069, 1087, 1091, 1093, 1097, 1103, 1109, 1117, 1123, 1129, 1151, 1153, 1163, 1171, 1181, 1187, 1193, 1201, 1213, 1217, 1223, 1229, 1231, 1237, 1249, 1259, 1277, 1279, 1283, 1289, 1291, 1297, 1301, 1303, 1307, 1319, 1321, 1327, 1361, 1367, 1373, 1381, 1399, 1409, 1423, 1427, 1429, 1433, 1439, 1447, 1451, 1453, 1459, 1471, 1481, 1483, 1487, 1489, 1493, 1499, 1511, 1523, 1531, 1543, 1549, 1553, 1559, 1567, 1571, 1579, 1583, 1597, 1601, 1607, 1609, 1613, 1619, 1621, 1627, 1637, 1657, 1663, 1667, 1669, 1693, 1697, 1699, 1709, 1721, 1723, 1733, 1741, 1747, 1753, 1759, 1777, 1783, 1787, 1789, 1801, 1811, 1823, 1831, 1847, 1861, 1867, 1871, 1873, 1877, 1879, 1889, 1901, 1907, 1913, 1931, 1933, 1949, 1951, 1973, 1979, 1987, 1993, 1997, 1999, 2003, 2011, 2017, 2027, 2029, 2039, 2053, 2063, 2069, 2081, 2083, 2087, 2089, 2099, 2111, 2113, 2129, 2131, 2137, 2141, 2143, 2153, 2161, 2179, 2203, 2207, 2213, 2221, 2237, 2239, 2243, 2251, 2267, 2269, 2273, 2281, 2287, 2293, 2297, 2309, 2311, 2333, 2339, 2341, 2347, 2351, 2357, 2371, 2377, 2381, 2383, 2389, 2393, 2399, 2411, 2417, 2423, 2437, 2441, 2447, 2459, 2467, 2473, 2477, 2503, 2521, 2531, 2539, 2543, 2549, 2551, 2557, 2579, 2591, 2593, 2609, 2617, 2621, 2633, 2647, 2657, 2659, 2663, 2671, 2677, 2683, 2687, 2689, 2693, 2699, 2707, 2711, 2713, 2719, 2729, 2731, 2741, 2749, 2753, 2767, 2777, 2789, 2791, 2797, 2801, 2803, 2819, 2833, 2837, 2843, 2851, 2857, 2861, 2879, 2887, 2897, 2903, 2909, 2917, 2927, 2939, 2953, 2957, 2963, 2969, 2971, 2999, 3001, 3011, 3019, 3023, 3037, 3041, 3049, 3061, 3067, 3079, 3083, 3089, 3109, 3119, 3121, 3137, 3163, 3167, 3169, 3181, 3187, 3191, 3203, 3209, 3217, 3221, 3229, 3251, 3253, 3257, 3259, 3271, 3299, 3301, 3307, 3313, 3319, 3323, 3329, 3331, 3343, 3347, 3359, 3361, 3371, 3373, 3389, 3391, 3407, 3413, 3433, 3449, 3457, 3461, 3463, 3467, 3469, 3491, 3499, 3511, 3517, 3527, 3529, 3533, 3539, 3541, 3547, 3557, 3559, 3571};
    public static Random random = null;

    public static IMahou getPlayerMahou(Player player) {
        if (player != null) {
            return (IMahou)player.getData(DataAttachments.PLAYER_ATTACHMENTS);
        }
        return null;
    }

    public static void updateMahou(Player player) {
        if (player == null || player.hasData(DataAttachments.PLAYER_ATTACHMENTS)) {
            // empty if block
        }
    }

    public static Vec3 vecFromPitchYaw(float pitch, float yaw) {
        float f = Mth.cos((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = Mth.sin((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -Mth.cos((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = Mth.sin((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public static ResourceLocation holderToKey(Holder<?> h) {
        return h.unwrapKey().map(ResourceKey::location).orElse(null);
    }

    public static String holderToName(Holder<?> h) {
        return h.getRegisteredName();
    }

    public static String getRegistryName(Entity e) {
        return Utils.getRegistryKey(e, e.level()).toString();
    }

    public static String getRegistryName(Block block, Level level) {
        return Utils.getRegistryKey(block, level).toString();
    }

    public static String getRegistryName(Item item, Level level) {
        return Utils.getRegistryKey(item, level).toString();
    }

    public static String getRegistryName(MobEffect effect, Level level) {
        return Utils.getRegistryKey(effect, level).toString();
    }

    public static ResourceLocation getRegistryKey(Entity e, Level level) {
        if (BuiltInRegistries.ENTITY_TYPE.containsValue((Object)e.getType())) {
            return BuiltInRegistries.ENTITY_TYPE.getKey((Object)e.getType());
        }
        return ((Registry)level.registryAccess().registry(Registries.ENTITY_TYPE).get()).getKey((Object)e.getType());
    }

    public static ResourceLocation getRegistryKey(Block block, Level level) {
        if (BuiltInRegistries.BLOCK.containsValue((Object)block)) {
            return BuiltInRegistries.BLOCK.getKey((Object)block);
        }
        return ((Registry)level.registryAccess().registry(Registries.BLOCK).get()).getKey((Object)block);
    }

    public static ResourceLocation getRegistryKey(Item item, Level level) {
        if (BuiltInRegistries.ITEM.containsValue((Object)item)) {
            return BuiltInRegistries.ITEM.getKey((Object)item);
        }
        return ((Registry)level.registryAccess().registry(Registries.ITEM).get()).getKey((Object)item);
    }

    public static ResourceLocation getRegistryKey(MobEffect e, Level level) {
        if (BuiltInRegistries.MOB_EFFECT.containsValue((Object)e)) {
            return BuiltInRegistries.MOB_EFFECT.getKey((Object)e);
        }
        return ((Registry)level.registryAccess().registry(Registries.MOB_EFFECT).get()).getKey((Object)e);
    }

    public static ILivingMahou getLivingMahou(LivingEntity player) {
        return (ILivingMahou)player.getData(DataAttachments.LIVING_ATTACHMENTS);
    }

    public static ISettingsMahou getSettingsMahou(LivingEntity player) {
        return (ISettingsMahou)player.getData(DataAttachments.SETTINGS_ATTACHMENTS);
    }

    public static IItemHandler getInventory(ItemStack stack) {
        return (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
    }

    public static IItemHandler getInventory(LivingEntity e) {
        return (IItemHandler)e.getCapability(Capabilities.ItemHandler.ENTITY);
    }

    public static ComponentItemHandler getMCInventory(ItemStack stack) {
        return (ComponentItemHandler)stack.getCapability(ModCapabilities.MYSTIC_CODE, (Object)new MysticCodeInventoryType());
    }

    public static IItemHandler getInventory(Level level, BlockPos pos, BlockState state, BlockEntity be) {
        return (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, state, be, (Object)Direction.NORTH);
    }

    public static IItemHandler getInventory(Level level, BlockPos pos) {
        return (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)Direction.NORTH);
    }

    public static <T> T getDefaultMahou(ItemStack stack, DeferredHolder<DataComponentType<?>, DataComponentType<T>> component, T def) {
        Object ret = stack.get(component);
        if (ret == null) {
            stack.set(component, def);
            ret = def;
        } else if (ret instanceof CopyComponent) {
            ret = ((CopyComponent)ret).copy();
        }
        return (T)ret;
    }

    public static void removeAllEnchants(ItemStack stack) {
        EnchantmentHelper.updateEnchantments((ItemStack)stack, m -> m.removeIf(a -> true));
    }

    public static SwordMahou getSwordMahou(ItemStack stack) {
        return Utils.getDefaultMahou(stack, DataComponents.SWORD_COMPONENT, new SwordMahou());
    }

    public static LanceMahou getLanceMahou(ItemStack stack) {
        return Utils.getDefaultMahou(stack, DataComponents.LANCE_COMPONENT, new LanceMahou());
    }

    public static KodokuMahou getKodokuMahou(ItemStack stack) {
        return Utils.getDefaultMahou(stack, DataComponents.KODOKU_COMPONENT, new KodokuMahou());
    }

    public static ScrollMahou getScrollMahou(ItemStack stack) {
        return Utils.getDefaultMahou(stack, DataComponents.SCROLL_COMPONENT, new ScrollMahou());
    }

    public static GemMahou getGemMahou(ItemStack stack) {
        return Utils.getDefaultMahou(stack, DataComponents.GEM_COMPONENT, new GemMahou());
    }

    public static ColorMahou getColorMahou(ItemStack stack) {
        return Utils.getDefaultMahou(stack, DataComponents.COLORS_COMPONENT, new ColorMahou());
    }

    public static StackHolderMahou getStackHolderMahou(ItemStack stack) {
        return Utils.getDefaultMahou(stack, DataComponents.STACK_HOLDERS_COMPONENT, new StackHolderMahou());
    }

    public static ProjectedMahou getProjectedMahou(ItemStack stack) {
        return Utils.getDefaultMahou(stack, DataComponents.PROJECTED_COMPONENT, new ProjectedMahou());
    }

    public static MysticCodeData getMysticCodeData(ItemStack stack) {
        return Utils.getDefaultMahou(stack, DataComponents.MYSTIC_CODE_COMPONENT, new MysticCodeData());
    }

    public static ModeMahou getModeMahou(ItemStack stack) {
        return Utils.getDefaultMahou(stack, DataComponents.MODE_COMPONENT, new ModeMahou());
    }

    public static ReplicaMahou getReplicaMahou(ItemStack stack) {
        return Utils.getDefaultMahou(stack, DataComponents.REPLICA_COMPONENT, new ReplicaMahou());
    }

    public static StrengtheningMahou getStrengtheningMahou(ItemStack stack) {
        return Utils.getDefaultMahou(stack, DataComponents.STRENGTHENING_COMPONENT, new StrengtheningMahou());
    }

    public static boolean hasStrengtheningMahou(ItemStack stack) {
        return stack.has(DataComponents.STRENGTHENING_COMPONENT);
    }

    public static boolean hasProjectedMahou(ItemStack stack) {
        return stack.has(DataComponents.PROJECTED_COMPONENT);
    }

    public static RuleBreakerMahou getRuleBreakerMahou(ItemStack stack) {
        return Utils.getDefaultMahou(stack, DataComponents.RULE_BREAKER_COMPONENT, new RuleBreakerMahou());
    }

    public static ProjectorEnchant getProjectorEnchant(ItemStack stack) {
        return (ProjectorEnchant)stack.get(DataComponents.PROJECTOR_ENCHANT_COMPONENT);
    }

    public static SelectedTargetMahou getSelectedTarget(ItemStack stack) {
        return Utils.getDefaultMahou(stack, DataComponents.SELECTED_TARGET_COMPONENT, new SelectedTargetMahou());
    }

    public static boolean hasProjectorEnchant(ItemStack stack) {
        return stack.has(DataComponents.PROJECTOR_ENCHANT_COMPONENT);
    }

    public static FogProjectorEnchant getFogProjectorEnchant(ItemStack stack) {
        return (FogProjectorEnchant)stack.get(DataComponents.FOG_PROJECTOR_ENCHANT_COMPONENT);
    }

    public static boolean hasFogProjectorEnchant(ItemStack stack) {
        return stack.has(DataComponents.FOG_PROJECTOR_ENCHANT_COMPONENT);
    }

    public static SwordMahou setSwordMahou(ItemStack stack, SwordMahou m) {
        return (SwordMahou)stack.set(DataComponents.SWORD_COMPONENT, (Object)m);
    }

    public static LanceMahou setLanceMahou(ItemStack stack, LanceMahou m) {
        return (LanceMahou)stack.set(DataComponents.LANCE_COMPONENT, (Object)m);
    }

    public static KodokuMahou setKodokuMahou(ItemStack stack, KodokuMahou m) {
        return (KodokuMahou)stack.set(DataComponents.KODOKU_COMPONENT, (Object)m);
    }

    public static ScrollMahou setScrollMahou(ItemStack stack, ScrollMahou m) {
        return (ScrollMahou)stack.set(DataComponents.SCROLL_COMPONENT, (Object)m);
    }

    public static GemMahou setGemMahou(ItemStack stack, GemMahou m) {
        return (GemMahou)stack.set(DataComponents.GEM_COMPONENT, (Object)m);
    }

    public static ColorMahou setColorMahou(ItemStack stack, ColorMahou m) {
        return (ColorMahou)stack.set(DataComponents.COLORS_COMPONENT, (Object)m);
    }

    public static StackHolderMahou setStackHolderMahou(ItemStack stack, StackHolderMahou m) {
        return (StackHolderMahou)stack.set(DataComponents.STACK_HOLDERS_COMPONENT, (Object)m);
    }

    public static ProjectedMahou setProjectedMahou(ItemStack stack, ProjectedMahou m) {
        return (ProjectedMahou)stack.set(DataComponents.PROJECTED_COMPONENT, (Object)m);
    }

    public static MysticCodeData setMysticCodeData(ItemStack stack, MysticCodeData m) {
        return (MysticCodeData)stack.set(DataComponents.MYSTIC_CODE_COMPONENT, (Object)m);
    }

    public static ModeMahou setModeMahou(ItemStack stack, ModeMahou m) {
        return (ModeMahou)stack.set(DataComponents.MODE_COMPONENT, (Object)m);
    }

    public static ReplicaMahou setReplicaMahou(ItemStack stack, ReplicaMahou m) {
        return (ReplicaMahou)stack.set(DataComponents.REPLICA_COMPONENT, (Object)m);
    }

    public static StrengtheningMahou setStrengtheningMahou(ItemStack stack, StrengtheningMahou m) {
        return (StrengtheningMahou)stack.set(DataComponents.STRENGTHENING_COMPONENT, (Object)m);
    }

    public static RuleBreakerMahou setRuleBreakerMahou(ItemStack stack, RuleBreakerMahou m) {
        return (RuleBreakerMahou)stack.set(DataComponents.RULE_BREAKER_COMPONENT, (Object)m);
    }

    public static ProjectorEnchant setProjectorEnchant(ItemStack stack, ProjectorEnchant m) {
        return (ProjectorEnchant)stack.set(DataComponents.PROJECTOR_ENCHANT_COMPONENT, (Object)m);
    }

    public static FogProjectorEnchant setFogProjectorEnchant(ItemStack stack, FogProjectorEnchant m) {
        return (FogProjectorEnchant)stack.set(DataComponents.FOG_PROJECTOR_ENCHANT_COMPONENT, (Object)m);
    }

    public static SelectedTargetMahou setSelectedTarget(ItemStack stack, SelectedTargetMahou m) {
        return (SelectedTargetMahou)stack.set(DataComponents.SELECTED_TARGET_COMPONENT, (Object)m);
    }

    public static void setMode(ItemStack s, int mode) {
        ModeMahou mahou = Utils.getModeMahou(s);
        mahou.setMode(mode);
        Utils.setModeMahou(s, mahou);
    }

    public static int getMode(ItemStack s) {
        ModeMahou mahou = Utils.getModeMahou(s);
        return mahou.getMode();
    }

    public static float colorConvert(int c) {
        return (float)c / 255.0f;
    }

    public static void deleteAmmoStack(ItemStack stack) {
        StackHolderMahou mahou = Utils.getStackHolderMahou(stack);
        mahou.setStack(new ItemStack((ItemLike)Items.AIR));
        Utils.setStackHolderMahou(stack, mahou);
    }

    public static void setAmmoStack(ItemStack holder, ItemStack holdee) {
        StackHolderMahou mahou = Utils.getStackHolderMahou(holder);
        mahou.setStack(holdee.copy());
        Utils.setStackHolderMahou(holder, mahou);
    }

    public static ItemStack getAmmoStack(ItemStack stack) {
        StackHolderMahou mahou = Utils.getStackHolderMahou(stack);
        Optional<ItemStack> s = mahou.getStack();
        if (s.isEmpty()) {
            return null;
        }
        return s.get().copy();
    }

    public static MahouSavedData getWorldMahou(Level level) {
        if (level != null && level.getServer() != null) {
            return new WorldMahou((Level)level).data;
        }
        return null;
    }

    public static IChunkMahou getChunkMahou(LevelChunk chunk) {
        if (!chunk.hasData(DataAttachments.CHUNK_ATTACHMENTS)) {
            chunk.setData(DataAttachments.CHUNK_ATTACHMENTS, (Object)new ChunkMahou());
        }
        return (IChunkMahou)chunk.getData(DataAttachments.CHUNK_ATTACHMENTS);
    }

    @Nullable
    public static <T> T getThingFromRegistryName(Registry<T> reg, String s) {
        ResourceLocation rl = ResourceLocation.parse((String)s);
        return (T)reg.get(ResourceLocation.parse((String)s));
    }

    public static Block getBlockFromRegistryName(String s) {
        return (Block)Utils.getThingFromRegistryName(BuiltInRegistries.BLOCK, s);
    }

    public static Iterable<Holder<Block>> getBlockTagFromRegistryName(String s) {
        TagKey key = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)s));
        return BuiltInRegistries.BLOCK.getTagOrEmpty(key);
    }

    public static Iterable<Holder<Item>> getItemsFromTag(TagKey<Item> tag) {
        return BuiltInRegistries.ITEM.getTagOrEmpty(tag);
    }

    public static Iterable<Holder<EntityType<?>>> getEntitiesFromTag(TagKey<EntityType<?>> tag) {
        return BuiltInRegistries.ENTITY_TYPE.getTagOrEmpty(tag);
    }

    public static boolean isBlockAir(Level world, BlockPos pos) {
        Block b = world.getBlockState(pos).getBlock();
        return world.getBlockState(pos).isAir() || b == Blocks.AIR || b == Blocks.CAVE_AIR || b == Blocks.VOID_AIR;
    }

    public static HitResult rayTraceEyes(LivingEntity entity, double length) {
        Vec3 startPos = new Vec3(entity.getX(), entity.getY() + (double)entity.getEyeHeight(), entity.getZ());
        Vec3 endPos = startPos.add(new Vec3(entity.getLookAngle().x * length, entity.getLookAngle().y * length, entity.getLookAngle().z * length));
        return entity.level().clip(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, (Entity)entity));
    }

    public static boolean isInMurkyWater(Entity entity) {
        double eyes = entity.getY() + (double)entity.getEyeHeight();
        BlockState state = entity.level().getBlockState(Utils.toBlockPos(entity.getEyePosition(1.0f)));
        Block block = state.getBlock();
        double filled = 0.0;
        if (block instanceof LiquidBlock && (((LiquidBlock)block).fluid == ModFluids.MURKY_FLOW.get() || ((LiquidBlock)block).fluid == ModFluids.MURKY_STILL.get())) {
            double h;
            filled = h = (double)state.getFluidState().getOwnHeight() + 0.1111111111111111;
        }
        return eyes - Math.floor(eyes) < filled;
    }

    public static Level getWorldFromDimension(ResourceKey<Level> dim, ServerLevel world) {
        return world.getServer().getLevel(dim);
    }

    public static boolean GetIntersection(double fDst1, double fDst2, Vec3 P12, Vec3 P22, Vec3H Hit) {
        if (fDst1 * fDst2 >= 0.0) {
            return false;
        }
        if (fDst1 == fDst2) {
            return false;
        }
        Hit.v = P12.add(P22.subtract(P12).scale(-fDst1 / (fDst2 - fDst1)));
        return true;
    }

    public static boolean InBox(Vec3 Hit, Vec3 B1, Vec3 B2, int Axis2) {
        if (Axis2 == 1 && Hit.z > B1.z && Hit.z < B2.z && Hit.y > B1.y && Hit.y < B2.y) {
            return true;
        }
        if (Axis2 == 2 && Hit.z > B1.z && Hit.z < B2.z && Hit.x > B1.x && Hit.x < B2.x) {
            return true;
        }
        return Axis2 == 3 && Hit.x > B1.x && Hit.x < B2.x && Hit.y > B1.y && Hit.y < B2.y;
    }

    public static boolean CheckLineBox(Vec3 B1, Vec3 B2, Vec3 L1, Vec3 L2, Vec3H Hit) {
        if (L2.x < B1.x && L1.x < B1.x) {
            return false;
        }
        if (L2.x > B2.x && L1.x > B2.x) {
            return false;
        }
        if (L2.y < B1.y && L1.y < B1.y) {
            return false;
        }
        if (L2.y > B2.y && L1.y > B2.y) {
            return false;
        }
        if (L2.z < B1.z && L1.z < B1.z) {
            return false;
        }
        if (L2.z > B2.z && L1.z > B2.z) {
            return false;
        }
        if (L1.x > B1.x && L1.x < B2.x && L1.y > B1.y && L1.y < B2.y && L1.z > B1.z && L1.z < B2.z) {
            Hit.v = L1;
            return true;
        }
        return Utils.GetIntersection(L1.x - B1.x, L2.x - B1.x, L1, L2, Hit) && Utils.InBox(Hit.v, B1, B2, 1) || Utils.GetIntersection(L1.y - B1.y, L2.y - B1.y, L1, L2, Hit) && Utils.InBox(Hit.v, B1, B2, 2) || Utils.GetIntersection(L1.z - B1.z, L2.z - B1.z, L1, L2, Hit) && Utils.InBox(Hit.v, B1, B2, 3) || Utils.GetIntersection(L1.x - B2.x, L2.x - B2.x, L1, L2, Hit) && Utils.InBox(Hit.v, B1, B2, 1) || Utils.GetIntersection(L1.y - B2.y, L2.y - B2.y, L1, L2, Hit) && Utils.InBox(Hit.v, B1, B2, 2) || Utils.GetIntersection(L1.z - B2.z, L2.z - B2.z, L1, L2, Hit) && Utils.InBox(Hit.v, B1, B2, 3);
    }

    public static boolean CheckLineBox(Vec3 B1, Vec3 B2, Vec3 L1, Vec3 L2) {
        return Utils.CheckLineBox(B1, B2, L1, L2, new Vec3H(L1));
    }

    @Deprecated
    public static CompoundTag blockposToNBT(BlockPos p, String name) {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt(name + "_x", p.getX());
        nbt.putInt(name + "_y", p.getY());
        nbt.putInt(name + "_z", p.getZ());
        return nbt;
    }

    @Deprecated
    public static BlockPos NBTtoBlockPos(CompoundTag nbt, String name) {
        BlockPos ret = null;
        if (nbt.contains(name + "_x") && nbt.contains(name + "_y") && nbt.contains(name + "_z")) {
            ret = new BlockPos(nbt.getInt(name + "_x"), nbt.getInt(name + "_y"), nbt.getInt(name + "_z"));
        }
        return ret;
    }

    public static void writeIntListToBuffer(ByteBuf buf, List<Integer> lst) {
        buf.writeInt(lst.size());
        for (Integer i : lst) {
            buf.writeInt(i.intValue());
        }
    }

    public static List<Integer> readIntListFromBuffer(ByteBuf buf) {
        ArrayList<Integer> lst = new ArrayList<Integer>();
        int sz = buf.readInt();
        for (int i = 0; i < sz; ++i) {
            lst.add(buf.readInt());
        }
        return lst;
    }

    public static void color(ItemStack stack, float r, float g, float b, float r2, float g2, float b2) {
        ArrayList<MahouColor> colors = new ArrayList<MahouColor>();
        colors.add(new MahouColor(r, g, b));
        colors.add(new MahouColor(r2, g2, b2));
        Utils.setColorMahou(stack, new ColorMahou(colors));
    }

    public static float[] getColor(ItemStack stack) {
        ColorMahou mahou = Utils.getColorMahou(stack);
        if (mahou == null) {
            return null;
        }
        if (mahou.colors == null || mahou.colors.isEmpty()) {
            return null;
        }
        if (mahou.colors.size() > 1) {
            MahouColor c1 = mahou.colors.get(0);
            MahouColor c2 = mahou.colors.get(1);
            return new float[]{c1.r, c1.g, c1.b, c2.r, c2.g, c2.b};
        }
        return null;
    }

    public static float avgStep(float a, float b, float steps, float step) {
        float diff = Math.abs(b - a);
        float onestep = diff / steps;
        if (a < b) {
            return a + onestep * step;
        }
        return a - onestep * step;
    }

    public static float[][] permute(float[][] in, int offset) {
        float[][] ret = new float[in.length][in[0].length];
        for (int i = 0; i < in.length; ++i) {
            for (int j = 0; j < in[0].length; ++j) {
                ret[Math.floorMod((int)(i + offset), (int)in.length)][j] = in[i][j];
            }
        }
        return ret;
    }

    public static ArrayList<BlockPos> findTilesInRange(LivingEntity player, int range, Predicate<BlockEntity> pred) {
        int bx = (int)(player.position().x - (double)range);
        int bz = (int)(player.position().z - (double)range);
        int tx = (int)(player.position().x + (double)range);
        int tz = (int)(player.position().z + (double)range);
        ChunkPos bp = new ChunkPos(new BlockPos(bx, 0, bz));
        ChunkPos tp = new ChunkPos(new BlockPos(tx, 0, tz));
        ArrayList<BlockPos> lst = new ArrayList<BlockPos>();
        for (int x = bp.x; x <= tp.x; ++x) {
            for (int z = bp.z; z <= tp.z; ++z) {
                LevelChunk c = player.level().getChunk(x, z);
                Map m = c.getBlockEntities();
                for (BlockPos pos : m.keySet()) {
                    if (!pred.test((BlockEntity)m.get(pos))) continue;
                    lst.add(pos);
                }
            }
        }
        return lst;
    }

    public static double distanceToLine(Vec3 v, Vec3 w, Vec3 p) {
        Vec3 VW = v.subtract(w);
        if (VW.lengthSqr() == 0.0) {
            return p.distanceTo(v);
        }
        Vec3 z = v.subtract(VW.scale(v.subtract(p).dot(VW) / VW.dot(VW)));
        double dv = z.distanceToSqr(v);
        double dw = z.distanceToSqr(w);
        double dvw = v.distanceToSqr(w);
        if (dv > dvw) {
            return p.distanceTo(w);
        }
        if (dw > dvw) {
            return p.distanceTo(v);
        }
        return p.distanceTo(z);
    }

    public static Entity selectEntityNearCursor(Player player, double distance, Level world, Predicate<Entity> pred, boolean nearAllowed) {
        ArrayList<Entity> ret = Utils.selectEntitiesNearCursor(1, player, distance, 45.0, world, pred, nearAllowed);
        return ret == null || ret.isEmpty() ? null : (Entity)ret.getFirst();
    }

    public static ArrayList<Entity> selectEntitiesNearCursor(int limit, Player player, double distance, double distanceFromLook, Level world, Predicate<Entity> pred, boolean nearAllowed) {
        ArrayList<Entity> ret = null;
        if (player != null) {
            List lst = world.getEntities((Entity)player, player.getBoundingBox().inflate(distance), pred);
            Vec3 eyes = player.getEyePosition(1.0f);
            Vec3 look = player.getLookAngle();
            Vec3 sightEnd = eyes.add(look.scale(distance));
            ArrayList<Entity> candidates = new ArrayList<Entity>();
            for (Entity e : lst) {
                AABB aabb = e.getBoundingBox();
                boolean qualifies = false;
                boolean lookingDirectly = Utils.CheckLineBox(new Vec3(aabb.minX, aabb.minY, aabb.minZ), new Vec3(aabb.maxX, aabb.maxY, aabb.maxZ), eyes, sightEnd);
                boolean blockBetween = Utils.blockBetween(eyes, e.getBoundingBox().getCenter(), e.level());
                boolean lookingAtMe = EffectUtil.isLookingAtMe(e, (LivingEntity)player, (int)distanceFromLook);
                qualifies = lookingDirectly && !blockBetween || lookingAtMe && !blockBetween && nearAllowed;
                if (!qualifies) continue;
                candidates.add(e);
            }
            if (nearAllowed) {
                candidates.sort(Comparator.comparingDouble(a -> Utils.distanceToLine(eyes, sightEnd, a.getBoundingBox().getCenter())));
            } else {
                candidates.sort(Comparator.comparingDouble(a -> a.position().distanceTo(eyes)));
            }
            ret = candidates;
            if (limit < ret.size() && !ret.isEmpty()) {
                ret = new ArrayList(ret.subList(0, limit));
            }
        }
        return ret;
    }

    public static boolean blockBetween(Vec3 e1, Vec3 e2, Level world) {
        Vec3 subtracted = e2.subtract(e1);
        Vec3 unit = subtracted.normalize();
        if (subtracted.length() > 1.0) {
            int i = 0;
            while ((double)i < subtracted.length()) {
                BlockPos pos = Utils.toBlockPos(e1.add(unit.scale((double)i)));
                BlockState bs = world.getBlockState(pos);
                if (!bs.isAir() && !bs.propagatesSkylightDown((BlockGetter)world, pos)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return false;
    }

    public static boolean getPredicate(MAHOU_SELECTION s, Entity e, Player player) {
        return Utils.getPredicate(new HashSet<MAHOU_SELECTION>(Collections.singleton(s)), e, player);
    }

    public static boolean getPredicate(HashSet<MAHOU_SELECTION> set, Entity e, Player player) {
        if (set.contains((Object)MAHOU_SELECTION.SELECTIVE_DISPLACEMENT)) {
            return e != player;
        }
        if (set.contains((Object)MAHOU_SELECTION.SCROLL_PROJECTION)) {
            return e != player && (e instanceof LivingEntity || e instanceof ItemEntity || e instanceof ThrownTrident || e instanceof ItemFrame || e instanceof WeaponProjectileEntity);
        }
        if (set.contains((Object)MAHOU_SELECTION.SCROLL_GEAS)) {
            return e != player && !EffectUtil.inEntityBlacklist(e, MTConfig.GEAS_BLACKLIST) && (e instanceof LivingEntity || e instanceof ItemEntity);
        }
        if (set.size() > 0) {
            return e != player && e instanceof LivingEntity;
        }
        return false;
    }

    public static boolean nearAllowed(MAHOU_SELECTION s) {
        return Utils.nearAllowed(new HashSet<MAHOU_SELECTION>(Collections.singleton(s)));
    }

    public static boolean nearAllowed(HashSet<MAHOU_SELECTION> set) {
        return set.contains((Object)MAHOU_SELECTION.SELECTIVE_DISPLACEMENT) || set.contains((Object)MAHOU_SELECTION.SCROLL_RETRIBUTION) || set.contains((Object)MAHOU_SELECTION.SCROLL_POSSESS_ENTITY) || set.contains((Object)MAHOU_SELECTION.SCROLL_DAMAGE_REPLICATION) || set.contains((Object)MAHOU_SELECTION.INSIGHT) || set.contains((Object)MAHOU_SELECTION.WEAPON);
    }

    public static Random getRandom(Level level) {
        if (random == null) {
            random = new Random(level.getDayTime());
        }
        return random;
    }

    public static void debug(Object s) {
        if (MTConfig.RHO_AIAS_KILL_DEBUG) {
            MahouTsukaiMod.logger.info(s);
        }
    }

    public static void err(Object s) {
        MahouTsukaiMod.logger.error(s);
    }

    public static boolean damageSourceAny(DamageSource src, ResourceKey<DamageType> ... types) {
        for (int i = 0; i < types.length; ++i) {
            if (!src.is(types[i])) continue;
            return true;
        }
        return false;
    }

    public static BlockPos toBlockPos(Vec3 v) {
        return new BlockPos(Mth.floor((double)v.x), Mth.floor((double)v.y), Mth.floor((double)v.z));
    }

    public static BlockPos toBlockPos(float x, float y, float z) {
        return new BlockPos(Mth.floor((float)x), Mth.floor((float)y), Mth.floor((float)z));
    }

    public static BlockPos toBlockPos(double x, double y, double z) {
        return new BlockPos(Mth.floor((double)x), Mth.floor((double)y), Mth.floor((double)z));
    }

    public static Holder<Enchantment> getEnchant(ResourceKey<Enchantment> enchant, Level level) {
        return (Holder)((HolderLookup.RegistryLookup)level.registryAccess().lookup(Registries.ENCHANTMENT).get()).get(enchant).get();
    }

    public static class Vec3H {
        public Vec3 v;

        public Vec3H(Vec3 vec) {
            this.v = vec;
        }
    }

    public static enum MAHOU_SELECTION {
        SELECTIVE_DISPLACEMENT,
        SCROLL_PROJECTION,
        SCROLL_RETRIBUTION,
        SCROLL_POSSESS_ENTITY,
        SCROLL_DAMAGE_REPLICATION,
        SCROLL_IMMUNITY_EXCHANGE,
        SCROLL_GEAS,
        SCROLL_REALITY_MARBLE,
        WEAPON,
        WEAPON_NO_NEAR,
        INSIGHT,
        RIPPER_FOG;

    }
}

