/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.network.Utf8String;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.render.enchant.ProjectorValues;
import stepsword.mahoutsukai.util.FogProjectorValues;
import stepsword.mahoutsukai.util.MahouColor;

public class Codecs {
    public static StreamCodec<ByteBuf, ArrayList<String>> STRING_ARRAY_LIST = new StreamCodec<ByteBuf, ArrayList<String>>(){

        public ArrayList<String> decode(ByteBuf b) {
            int sz = b.readInt();
            ArrayList<String> ret = new ArrayList<String>();
            for (int m = 0; m < sz; ++m) {
                String s = Utf8String.read((ByteBuf)b, (int)Short.MAX_VALUE);
                ret.add(s);
            }
            return ret;
        }

        public void encode(ByteBuf b, ArrayList<String> s) {
            b.writeInt(s.size());
            for (int m = 0; m < s.size(); ++m) {
                Utf8String.write((ByteBuf)b, (CharSequence)s.get(m), (int)Short.MAX_VALUE);
            }
        }
    };
    public static StreamCodec<ByteBuf, Vec3> VEC3_STREAM = new StreamCodec<ByteBuf, Vec3>(){

        public Vec3 decode(ByteBuf b) {
            double x = b.readDouble();
            double y = b.readDouble();
            double z = b.readDouble();
            Vec3 ret = new Vec3(x, y, z);
            return ret;
        }

        public void encode(ByteBuf b, Vec3 s) {
            b.writeDouble(s.x);
            b.writeDouble(s.y);
            b.writeDouble(s.z);
        }
    };
    public static Codec<MahouColor> COLOR_CODEC = Codec.FLOAT.listOf().comapFlatMap(m -> Util.fixedSize((List)m, (int)3).map(c -> new MahouColor(((Float)c.get(0)).floatValue(), ((Float)c.get(1)).floatValue(), ((Float)c.get(2)).floatValue())), color -> List.of(Float.valueOf(color.r), Float.valueOf(color.g), Float.valueOf(color.b)));
    public static StreamCodec<ByteBuf, MahouColor> COLOR_STREAM_CODEC = new StreamCodec<ByteBuf, MahouColor>(){

        public MahouColor decode(ByteBuf buf) {
            float r = buf.readFloat();
            float g = buf.readFloat();
            float b = buf.readFloat();
            MahouColor ret = new MahouColor(r, g, b);
            return ret;
        }

        public void encode(ByteBuf b, MahouColor s) {
            b.writeFloat(s.r);
            b.writeFloat(s.g);
            b.writeFloat(s.b);
        }
    };
    public static StreamCodec<ByteBuf, ArrayList<MahouColor>> COLOR_ARRAY_LIST = new StreamCodec<ByteBuf, ArrayList<MahouColor>>(){

        public ArrayList<MahouColor> decode(ByteBuf b) {
            int sz = b.readInt();
            ArrayList<MahouColor> ret = new ArrayList<MahouColor>();
            for (int m = 0; m < sz; ++m) {
                ret.add(new MahouColor(b.readFloat(), b.readFloat(), b.readFloat()));
            }
            return ret;
        }

        public void encode(ByteBuf b, ArrayList<MahouColor> s) {
            b.writeInt(s.size());
            for (int m = 0; m < s.size(); ++m) {
                MahouColor c = s.get(m);
                b.writeFloat(c.r);
                b.writeFloat(c.g);
                b.writeFloat(c.b);
            }
        }
    };
    public static Codec<ProjectorValues> PROJECTOR_VALUES_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.listOf().fieldOf("ints").forGetter(ProjectorValues::getAllInts), (App)Codec.FLOAT.listOf().fieldOf("floats").forGetter(ProjectorValues::getAllFloats), (App)Codec.BOOL.listOf().fieldOf("bools").forGetter(ProjectorValues::getAllBools)).apply((Applicative)instance, ProjectorValues::new));
    public static StreamCodec<ByteBuf, ProjectorValues> PROJECTOR_VALUES_STREAM_CODEC = new StreamCodec<ByteBuf, ProjectorValues>(){

        public ProjectorValues decode(ByteBuf b) {
            ProjectorValues ret = new ProjectorValues();
            ret.decode(b);
            return ret;
        }

        public void encode(ByteBuf b, ProjectorValues s) {
            s.encode(b);
        }
    };
    public static StreamCodec<ByteBuf, List<ProjectorValues>> PROJECTOR_VALUES_ARRAY_LIST = new StreamCodec<ByteBuf, List<ProjectorValues>>(){

        public List<ProjectorValues> decode(ByteBuf b) {
            int sz = b.readInt();
            ArrayList<ProjectorValues> ret = new ArrayList<ProjectorValues>();
            for (int m = 0; m < sz; ++m) {
                ProjectorValues pv = new ProjectorValues();
                pv.decode(b);
                ret.add(pv);
            }
            return ret;
        }

        public void encode(ByteBuf b, List<ProjectorValues> s) {
            b.writeInt(s.size());
            for (int m = 0; m < s.size(); ++m) {
                ProjectorValues pv = s.get(m);
                pv.encode(b);
            }
        }
    };
    public static Codec<FogProjectorValues> FOG_PROJECTOR_VALUES_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.listOf().fieldOf("ints").forGetter(FogProjectorValues::getAllInts), (App)Codec.FLOAT.listOf().fieldOf("floats").forGetter(FogProjectorValues::getAllFloats), (App)Codec.BOOL.listOf().fieldOf("bools").forGetter(FogProjectorValues::getAllBools)).apply((Applicative)instance, FogProjectorValues::new));
    public static StreamCodec<ByteBuf, FogProjectorValues> FOG_PROJECTOR_VALUES_STREAM_CODEC = new StreamCodec<ByteBuf, FogProjectorValues>(){

        public FogProjectorValues decode(ByteBuf b) {
            FogProjectorValues ret = new FogProjectorValues();
            ret.decode(b);
            return ret;
        }

        public void encode(ByteBuf b, FogProjectorValues s) {
            s.encode(b);
        }
    };
}

