/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.boundary;

import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.dataattachments.mahou.IMahou;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.tile.AboveChecker;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.tile.boundary.BoundaryMahoujinTileEntity;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class DrainLifeBoundaryMahoujinTileEntity
extends BoundaryMahoujinTileEntity
implements AboveChecker {
    String whitelistName = null;

    public DrainLifeBoundaryMahoujinTileEntity(BlockPos p, BlockState bs) {
        super((BlockEntityType)ModTileEntities.drainLifeBoundary.get(), p, bs);
    }

    @Override
    public int getManaCost() {
        return MTConfig.DRAIN_LIFE_BARRIER_MANA_COST;
    }

    @Override
    public int getManaCycle() {
        return MTConfig.DRAIN_LIFE_BARRIER_MANA_CYCLE;
    }

    @Override
    public int getBarrierCycle() {
        return MTConfig.DRAIN_LIFE_BARRIER_CYCLE;
    }

    @Override
    public int getBarrierRadius() {
        return MTConfig.DRAIN_LIFE_BARRIER_RADIUS;
    }

    @Override
    public void doBarrier(List<LivingEntity> entities) {
        int limit = MTConfig.DRAIN_LIFE_AFFECTED_LIMIT;
        int current = 0;
        final Player caster = this.getCaster();
        for (final LivingEntity e : entities) {
            final float tmpHealth = e.getHealth();
            if (EffectUtil.inEntityBlacklist((Entity)e, MTConfig.DRAIN_LIFE_ENTITY_BLACKLIST) || !this.drainLife(e) || caster == null) continue;
            if (this.level instanceof ServerLevel && this.level.getServer() != null) {
                ((ServerLevel)this.level).getServer().tell((Runnable)new TickTask(1, new Runnable(){

                    @Override
                    public void run() {
                        float newHealth = e.getHealth();
                        if ((double)(tmpHealth - newHealth) >= MTConfig.DRAIN_LIFE_DAMAGE || !e.isAlive()) {
                            DrainLifeBoundaryMahoujinTileEntity.this.giveLife(caster);
                        } else {
                            EffectUtil.genericAttack(e, (float)(MTConfig.DRAIN_LIFE_DAMAGE * MTConfig.DRAIN_LIFE_PUNISH_RESIST), e.damageSources().generic(), (LivingEntity)caster);
                            Brain brain = e.getBrain();
                            brain.eraseMemory(MemoryModuleType.IS_PANICKING);
                            brain.eraseMemory(MemoryModuleType.HURT_BY);
                            brain.eraseMemory(MemoryModuleType.HURT_BY_ENTITY);
                            DrainLifeBoundaryMahoujinTileEntity.this.giveLife(caster);
                        }
                    }
                }));
            }
            if (++current <= limit) continue;
            break;
        }
    }

    public boolean drainLife(LivingEntity entityIn) {
        if (!(ContractMahoujinTileEntity.isImmuneToSpell(this.level, this.getCasterUUID(), (Entity)entityIn) || this.whitelistName != null && entityIn.getDisplayName() != null && this.whitelistName.equals(entityIn.getDisplayName().getString()))) {
            EffectUtil.magicAttack(entityIn, (float)MTConfig.DRAIN_LIFE_DAMAGE, (LivingEntity)this.getCaster());
            if (MTConfig.DRAIN_LIFE_DAMAGE < (double)entityIn.getHealth()) {
                entityIn.lastDamageSource = null;
            }
            Brain brain = entityIn.getBrain();
            brain.eraseMemory(MemoryModuleType.IS_PANICKING);
            brain.eraseMemory(MemoryModuleType.HURT_BY);
            brain.eraseMemory(MemoryModuleType.HURT_BY_ENTITY);
            return true;
        }
        return false;
    }

    public void giveLife(Player caster) {
        if (caster.getHealth() >= caster.getMaxHealth()) {
            FoodData casterFS = caster.getFoodData();
            if (casterFS.getFoodLevel() >= 20 || MTConfig.DRAIN_LIFE_IGNORE_HUNGER) {
                IMahou mahou = Utils.getPlayerMahou(caster);
                mahou.setStoredMana(Math.min(mahou.getMaxMana(), mahou.getStoredMana() + MTConfig.DRAIN_LIFE_MANA_REGEN));
            } else {
                casterFS.setFoodLevel(casterFS.getFoodLevel() + 1);
            }
        } else {
            caster.heal((float)MTConfig.DRAIN_LIFE_HEAL_FACTOR);
        }
    }

    @Override
    public ItemStack getItemToGive() {
        return new ItemStack((ItemLike)ModItems.boundaryDrainLifeScroll.get());
    }

    @Override
    public List<Item> checkForItem() {
        return Arrays.asList(Items.NAME_TAG);
    }

    @Override
    public int checkTicks() {
        return MTConfig.DRAIN_LIFE_BARRIER_CYCLE;
    }

    @Override
    public boolean firstEntityOnly() {
        return true;
    }

    @Override
    public boolean preConditions() {
        return !this.level.isClientSide;
    }

    @Override
    public boolean ifItemFoundAbove(ItemEntity item) {
        if (item.thrower != null && item.thrower.equals(this.getCasterUUID())) {
            this.whitelistName = item.getItem().getHoverName().getString();
            this.sendUpdates();
        }
        return false;
    }

    public String getWhitelistName() {
        return this.whitelistName;
    }

    @Override
    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        if (this.getWhitelistName() != null) {
            compound.putString("whitelist_name", this.whitelistName);
        }
        super.saveAdditional(compound, provider);
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        if (compound.contains("whitelist_name")) {
            this.whitelistName = compound.getString("whitelist_name");
        }
        super.loadAdditional(compound, provider);
    }
}

