/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.gui;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.networking.MahoujinProjectorUpdatePacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.render.gui.MahouEditBox;
import stepsword.mahoutsukai.render.gui.NoActionCheckbox;
import stepsword.mahoutsukai.tile.MahoujinProjectorTileEntity;

public class MahoujinProjectorScreen
extends Screen {
    private MahouEditBox rvalue;
    private MahouEditBox gvalue;
    private MahouEditBox bvalue;
    private MahouEditBox avalue;
    private MahouEditBox xvalue;
    private MahouEditBox yvalue;
    private MahouEditBox zvalue;
    private MahouEditBox sizevalue;
    private MahouEditBox yawvalue;
    private MahouEditBox speedvalue;
    private MahouEditBox yspeedvalue;
    private MahouEditBox pspeedvalue;
    private MahouEditBox pitchvalue;
    private MahouEditBox ringvalue;
    private MahouEditBox imagevalue;
    private MahouEditBox runesvalue;
    private MahouEditBox ringheightvalue;
    private MahouEditBox rotationoffsetvalue;
    private MahouEditBox prepitchvalue;
    private MahouEditBox preyawvalue;
    private MahouEditBox orbitspeedvalue;
    private MahouEditBox gifspeedvalue;
    private Checkbox showcirclevalue;
    private Checkbox showringvalue;
    private Checkbox giflayervalue;
    private ArrayList<MahouEditBox> boxes = new ArrayList();
    private ArrayList<Checkbox> toggles = new ArrayList();
    Level world;
    BlockPos pos;

    public MahoujinProjectorScreen(Level w, BlockPos p) {
        super((Component)Component.literal((String)"projector.screen"));
        this.world = w;
        this.pos = p;
    }

    public void init() {
        MahoujinProjectorTileEntity projector = null;
        int sw = Minecraft.getInstance().getWindow().getGuiScaledWidth();
        int x1 = 70;
        int x2 = 280;
        int startery = 4;
        int distance = 5;
        int h = 20;
        int w = 137;
        int guiwidth = 420;
        if (guiwidth <= sw) {
            x1 = (sw - guiwidth) / 2 + 60;
            x2 = sw / 2 + 60;
        }
        if (this.world.getBlockEntity(this.pos) instanceof MahoujinProjectorTileEntity) {
            projector = (MahoujinProjectorTileEntity)this.world.getBlockEntity(this.pos);
        }
        this.rvalue = new MahouEditBox(this.font, x1, startery + (distance + h) * 0, w, h, (Component)Component.translatable((String)"mahoutsukai.projector.rvalue"));
        this.gvalue = new MahouEditBox(this.font, x1, startery + (distance + h) * 1, w, h, (Component)Component.translatable((String)"mahoutsukai.projector.gvalue"));
        this.bvalue = new MahouEditBox(this.font, x1, startery + (distance + h) * 2, w, h, (Component)Component.translatable((String)"mahoutsukai.projector.bvalue"));
        this.avalue = new MahouEditBox(this.font, x1, startery + (distance + h) * 3, w, h, (Component)Component.translatable((String)"mahoutsukai.projector.avalue"));
        this.xvalue = new MahouEditBox(this.font, x2, startery + (distance + h) * 0, w, h, (Component)Component.translatable((String)"mahoutsukai.projector.xvalue"));
        this.yvalue = new MahouEditBox(this.font, x2, startery + (distance + h) * 1, w, h, (Component)Component.translatable((String)"mahoutsukai.projector.yvalue"));
        this.zvalue = new MahouEditBox(this.font, x2, startery + (distance + h) * 2, w, h, (Component)Component.translatable((String)"mahoutsukai.projector.zvalue"));
        this.sizevalue = new MahouEditBox(this.font, x2, startery + (distance + h) * 3, w, h, (Component)Component.translatable((String)"mahoutsukai.projector.sizevalue"));
        this.yawvalue = new MahouEditBox(this.font, x1, startery + (distance + h) * 4, w, h, (Component)Component.translatable((String)"mahoutsukai.projector.yawvalue"));
        this.pitchvalue = new MahouEditBox(this.font, x1, startery + (distance + h) * 5, w, h, (Component)Component.translatable((String)"mahoutsukai.projector.pitchvalue"));
        this.speedvalue = new MahouEditBox(this.font, x2, startery + (distance + h) * 4, w, h, (Component)Component.translatable((String)"mahoutsukai.projector.speedvalue"));
        this.ringvalue = new MahouEditBox(this.font, x2, startery + (distance + h) * 5, w, h, (Component)Component.translatable((String)"mahoutsukai.projector.ringvalue"));
        this.ringheightvalue = new MahouEditBox(this.font, x2, startery + (distance + h) * 6, w, h, (Component)Component.translatable((String)"mahoutsukai.projector.ringheightvalue"));
        this.rotationoffsetvalue = new MahouEditBox(this.font, x1, startery + (distance + h) * 6, w, h, (Component)Component.translatable((String)"mahoutsukai.projector.rotationoffsetvalue"));
        this.showcirclevalue = new Checkbox(x1, startery + (distance + h) * 7, w, (Component)Component.literal((String)"Show Circle"), this.font, true, (Checkbox.OnValueChange)new NoActionCheckbox());
        this.showringvalue = new Checkbox(x2, startery + (distance + h) * 7, w, (Component)Component.literal((String)"Show Ring"), this.font, true, (Checkbox.OnValueChange)new NoActionCheckbox());
        this.giflayervalue = new Checkbox(x1, startery + (distance + h) * 8, w, (Component)Component.literal((String)"Gif Layer"), this.font, false, (Checkbox.OnValueChange)new NoActionCheckbox());
        this.imagevalue = new MahouEditBox(this.font, x2, startery + (distance + h) * 8 - 2, w, h, (Component)Component.translatable((String)"mahoutsukai.projector.imagevalue"));
        this.runesvalue = new MahouEditBox(this.font, x2, startery + (distance + h) * 9 - 2, w, h, (Component)Component.translatable((String)"mahoutsukai.projector.runesvalue"));
        this.pspeedvalue = new MahouEditBox(this.font, x1, startery + (distance + h) * 10, w, h, (Component)Component.translatable((String)"mahoutsukai.projector.yspeedvalue"));
        this.yspeedvalue = new MahouEditBox(this.font, x2, startery + (distance + h) * 10, w, h, (Component)Component.translatable((String)"mahoutsukai.projector.pspeedvalue"));
        this.prepitchvalue = new MahouEditBox(this.font, x1, startery + (distance + h) * 11, w, h, (Component)Component.translatable((String)"mahoutsukai.projector.prepitchvalue"));
        this.preyawvalue = new MahouEditBox(this.font, x2, startery + (distance + h) * 11, w, h, (Component)Component.translatable((String)"mahoutsukai.projector.preyawvalue"));
        this.orbitspeedvalue = new MahouEditBox(this.font, x1, startery + (distance + h) * 12, w, h, (Component)Component.translatable((String)"mahoutsukai.projector.orbitspeedvalue"));
        this.gifspeedvalue = new MahouEditBox(this.font, x2, startery + (distance + h) * 12, w, h, (Component)Component.translatable((String)"mahoutsukai.projector.gifspeedvalue"));
        if (projector != null) {
            this.rvalue.setValue("" + projector.pv.getCr());
            this.gvalue.setValue("" + projector.pv.getCg());
            this.bvalue.setValue("" + projector.pv.getCb());
            this.avalue.setValue("" + projector.pv.getCa());
            this.xvalue.setValue("" + projector.pv.getCx());
            this.yvalue.setValue("" + projector.pv.getCy());
            this.zvalue.setValue("" + projector.pv.getCz());
            this.sizevalue.setValue("" + projector.pv.getCsize());
            this.yawvalue.setValue("" + projector.pv.getCyaw());
            this.pitchvalue.setValue("" + projector.pv.getCpitch());
            this.speedvalue.setValue("" + projector.pv.getCspeed());
            this.yspeedvalue.setValue("" + projector.pv.getCyspeed());
            this.pspeedvalue.setValue("" + projector.pv.getCpspeed());
            this.ringvalue.setValue("" + projector.pv.getCringangle());
            this.imagevalue.setValue("" + projector.pv.getImage());
            this.runesvalue.setValue("" + projector.pv.getRunes());
            this.ringheightvalue.setValue("" + projector.pv.getHeight());
            this.rotationoffsetvalue.setValue("" + projector.pv.getRotationOffset());
            this.orbitspeedvalue.setValue("" + projector.pv.getCorbitspeed());
            this.preyawvalue.setValue("" + projector.pv.getCpreyaw());
            this.prepitchvalue.setValue("" + projector.pv.getCprepitch());
            this.gifspeedvalue.setValue("" + projector.pv.getGifSpeed());
            if (projector.pv.getShowCircle() != this.showcirclevalue.selected()) {
                this.showcirclevalue.onPress();
            }
            if (projector.pv.getShowRing() != this.showringvalue.selected()) {
                this.showringvalue.onPress();
            }
            if (projector.pv.getGifLayer() != this.giflayervalue.selected()) {
                this.giflayervalue.onPress();
            }
        }
        this.boxes.addAll(Arrays.asList(this.rvalue, this.gvalue, this.bvalue, this.avalue, this.xvalue, this.yvalue, this.zvalue, this.sizevalue, this.yawvalue, this.pitchvalue, this.speedvalue, this.yspeedvalue, this.pspeedvalue, this.ringvalue, this.imagevalue, this.runesvalue, this.ringheightvalue, this.rotationoffsetvalue, this.orbitspeedvalue, this.preyawvalue, this.prepitchvalue, this.gifspeedvalue));
        this.toggles.addAll(Arrays.asList(this.showcirclevalue, this.showringvalue, this.giflayervalue));
        this.renderables.addAll(this.boxes);
        this.renderables.addAll(this.toggles);
        super.init();
    }

    public boolean charTyped(char c1, int c2) {
        boolean ret = false;
        for (EditBox editBox : this.boxes) {
            ret |= editBox.charTyped(c1, c2);
        }
        this.updateTE();
        return ret || super.charTyped(c1, c2);
    }

    public void tick() {
        super.tick();
    }

    public boolean keyPressed(int k1, int k2, int k3) {
        boolean ret = false;
        for (EditBox editBox : this.boxes) {
            ret |= editBox.keyPressed(k1, k2, k3);
        }
        this.updateTE();
        return ret || super.keyPressed(k1, k2, k3);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        for (EditBox editBox : this.boxes) {
            editBox.mouseClicked(mouseX, mouseY, mouseButton);
        }
        for (Checkbox checkbox : this.toggles) {
            checkbox.mouseClicked(mouseX, mouseY, mouseButton);
        }
        this.updateTE();
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void render(GuiGraphics s, int a, int b, float c) {
        for (MahouEditBox mahouEditBox : this.boxes) {
        }
        for (Checkbox checkbox : this.toggles) {
        }
        for (MahouEditBox mahouEditBox : this.boxes) {
            this.drawStringForMessage(s, mahouEditBox);
        }
        super.render(s, a, b, c);
    }

    public void drawStringForMessage(GuiGraphics graphics, MahouEditBox w) {
        int offset1 = -1;
        this.drawRightAligned(graphics, this.font, w.getMessage().getString(), w.x + offset1, w.y + w.getHeight() / 4, 0xE0E0E0);
    }

    public void drawRightAligned(GuiGraphics graphics, Font font, String text, int x, int y, int color) {
        font.drawInBatch(text, (float)(x - font.width(text)), (float)y, color, true, graphics.pose().last().pose(), (MultiBufferSource)graphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public void updateTE() {
        float offsetcap = (float)MTConfig.PROJECTOR_OFFSET_CAP;
        float sizecap = (float)MTConfig.PROJECTOR_SIZE_CAP;
        int r = this.parseIntLimit(this.rvalue.getValue(), 0, 255);
        int g = this.parseIntLimit(this.gvalue.getValue(), 0, 255);
        int b = this.parseIntLimit(this.bvalue.getValue(), 0, 255);
        int a = this.parseIntLimit(this.avalue.getValue(), 0, 255);
        float x = this.parseFloatLimit(this.xvalue.getValue(), -offsetcap, offsetcap);
        float y = this.parseFloatLimit(this.yvalue.getValue(), -offsetcap, offsetcap);
        float z = this.parseFloatLimit(this.zvalue.getValue(), -offsetcap, offsetcap);
        float size = this.parseFloatLimit(this.sizevalue.getValue(), 0.0f, sizecap);
        float speed = this.parseFloatLimit(this.speedvalue.getValue(), -360.0f, 360.0f);
        float yspeed = this.parseFloatLimit(this.yspeedvalue.getValue(), -360.0f, 360.0f);
        float pspeed = this.parseFloatLimit(this.pspeedvalue.getValue(), -360.0f, 360.0f);
        float yaw = this.parseFloatLimit(this.yawvalue.getValue(), 0.0f, 360.0f);
        float pitch = this.parseFloatLimit(this.pitchvalue.getValue(), 0.0f, 360.0f);
        float ring = this.parseFloatLimit(this.ringvalue.getValue(), 0.0f, 90.0f);
        int image = this.parseIntLimit(this.imagevalue.getValue(), -1, 255);
        int runes = this.parseIntLimit(this.runesvalue.getValue(), -1, 255);
        float height = this.parseFloatLimit(this.ringheightvalue.getValue(), -200.0f, 200.0f);
        float roffset = this.parseFloatLimit(this.rotationoffsetvalue.getValue(), -360.0f, 360.0f);
        float preyaw = this.parseFloatLimit(this.preyawvalue.getValue(), 0.0f, 360.0f);
        float prepitch = this.parseFloatLimit(this.prepitchvalue.getValue(), 0.0f, 360.0f);
        float orbitspeed = this.parseFloatLimit(this.orbitspeedvalue.getValue(), -360.0f, 360.0f);
        float gifspeed = this.parseFloatLimit(this.gifspeedvalue.getValue(), -360.0f, 360.0f);
        boolean sc = this.showcirclevalue.selected();
        boolean sr = this.showringvalue.selected();
        boolean gl = this.giflayervalue.selected();
        PacketHandler.sendToServer(new MahoujinProjectorUpdatePacket(r, g, b, a, x, y, z, size, speed, yaw, pitch, ring, sc, sr, this.pos, image, runes, height, yspeed, pspeed, roffset, prepitch, preyaw, orbitspeed, gifspeed, gl));
    }

    public int parseIntLimit(String s, int bottom, int top) {
        try {
            return Math.min(top, Math.max(Integer.parseInt(s), bottom));
        }
        catch (Exception e) {
            return 0;
        }
    }

    public float parseFloatLimit(String s, float bottom, float top) {
        try {
            return Math.min(top, Math.max(Float.parseFloat(s), bottom));
        }
        catch (Exception e) {
            return 0.0f;
        }
    }
}

