/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Vector3f;
import stepsword.mahoutsukai.entity.WeaponProjectileEntity;
import stepsword.mahoutsukai.render.RenderUtils;

public class RenderWeaponProjectile
extends EntityRenderer<WeaponProjectileEntity> {
    public RenderWeaponProjectile(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public void render(WeaponProjectileEntity weapon, float yaw, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int packedLight) {
        matrix.pushPose();
        float s = 2.5f;
        float ryaw = 90.0f + weapon.yRotO + (weapon.yRot - weapon.yRotO) * partialTicks;
        float rpitch = 135.0f - weapon.xRotO + (weapon.xRot - weapon.xRotO) * partialTicks;
        matrix.mulPose(RenderUtils.getQuaternion(new Vector3f(0.0f, 1.0f, 0.0f), ryaw, true));
        matrix.mulPose(RenderUtils.getQuaternion(new Vector3f(0.0f, 0.0f, 1.0f), rpitch, true));
        matrix.translate(-0.59, -0.59, 0.0);
        matrix.scale(s, s, s);
        ItemStack stack = weapon.getStack();
        BakedModel bakedModel = Minecraft.getInstance().getItemRenderer().getModel(stack, null, null, weapon.getId());
        try {
            Minecraft.getInstance().getItemRenderer().render(stack, ItemDisplayContext.GROUND, false, matrix, buffer, packedLight, OverlayTexture.NO_OVERLAY, bakedModel);
        }
        catch (Exception exception) {
            // empty catch block
        }
        matrix.popPose();
        super.render((Entity)weapon, yaw, partialTicks, matrix, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(WeaponProjectileEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

