/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import stepsword.mahoutsukai.entity.mahoujin.RhoAiasMahoujinEntity;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;

public class RenderRhoAiasMahoujinEntity
extends EntityRenderer<RhoAiasMahoujinEntity> {
    private static final ResourceLocation mahoujin = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/block/mahoujin_casting.png");

    public RenderRhoAiasMahoujinEntity(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public ResourceLocation getTextureLocation(RhoAiasMahoujinEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    public void render(RhoAiasMahoujinEntity entity, float eyaw, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int packedLight) {
    }

    public static void renderRhoAias(RhoAiasMahoujinEntity entity, double x, double y, double z, PoseStack matrix, float partialTicks) {
        float flatness;
        float prevYaw;
        matrix.pushPose();
        matrix.translate(x, y, z);
        int life = entity.getLife();
        float size = entity.getCircleSize();
        float yaw = entity.yRot % 360.0f;
        float roll = entity.getRotationRoll();
        float pitch = entity.getRotationPitch();
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        if ((prevYaw = entity.yRotO % 360.0f) < 0.0f) {
            prevYaw += 360.0f;
        }
        if (prevYaw - yaw > 300.0f) {
            yaw += 360.0f;
        }
        if (prevYaw - yaw < 300.0f && prevYaw - yaw > 0.0f) {
            prevYaw = yaw;
        }
        yaw = entity.yRotO + partialTicks * (yaw - prevYaw);
        matrix.scale(size, size, size);
        RenderUtils.rotateQ(roll, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(pitch, 1.0f, 0.0f, 0.0f, matrix);
        RenderUtils.rotateQ(yaw, 0.0f, 1.0f, 0.0f, matrix);
        int lightmapX = 240;
        int lightmapY = 240;
        float[] colors = entity.getColor();
        float r = colors[0];
        float g = colors[1];
        float b = colors[2];
        float a = colors[3];
        float r2 = colors[4];
        float g2 = colors[5];
        float b2 = colors[6];
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        RenderType type = MahoujinRenderType.createMahoujinRenderType(mahoujin, 0, false);
        VertexConsumer bb = buffer.getBuffer(type);
        Matrix4f m = matrix.last().pose();
        bb.addVertex(m, -0.5f, 0.0f, -0.5f).setColor(r2, g2, b2, a).setUv(0.0f, 0.0f).setUv2(lightmapX, lightmapY);
        bb.addVertex(m, -0.5f, 0.0f, 0.5f).setColor(r2, g2, b2, a).setUv(0.0f, 1.0f).setUv2(lightmapX, lightmapY);
        bb.addVertex(m, 0.5f, 0.0f, 0.5f).setColor(r2, g2, b2, a).setUv(1.0f, 1.0f).setUv2(lightmapX, lightmapY);
        bb.addVertex(m, 0.5f, 0.0f, -0.5f).setColor(r2, g2, b2, a).setUv(1.0f, 0.0f).setUv2(lightmapX, lightmapY);
        buffer.endBatch(type);
        float height = 0.125f;
        float space = height / 4.0f;
        float ringsize = 0.5f + space;
        float ff = flatness = 10.0f;
        double yOffset = (double)(height + space) * Math.sin(flatness);
        float yy = 0.0f;
        float innersizeOffset = 0.2f;
        int index = 0;
        RenderType t2 = RenderUtils.renderRing(matrix, (MultiBufferSource)buffer, (double)yy, ff * 1.8f, ringsize, height, 128, lightmapX, lightmapY, r2, g2, b2, a, index++);
        buffer.endBatch(t2);
        ringsize = (float)((double)ringsize + ((double)(height + space) + 0.08));
        yy = (float)((double)yy + yOffset);
        t2 = RenderUtils.renderRing(matrix, (MultiBufferSource)buffer, (double)yy, ff += flatness, ringsize, height, 128, lightmapX, lightmapY, r2, g2, b2, a, index++);
        buffer.endBatch(t2);
        t2 = RenderUtils.renderRing(matrix, (MultiBufferSource)buffer, (double)yy, ff, ringsize - innersizeOffset, height, 128, lightmapX, lightmapY, r, g, b, a, index++);
        buffer.endBatch(t2);
        RenderUtils.rotateQ(-yaw, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(-yaw, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(15.0f, 0.0f, 1.0f, 0.0f, matrix);
        type = MahoujinRenderType.createMahoujinRenderType(mahoujin, 1, false);
        bb = buffer.getBuffer(type);
        m = matrix.last().pose();
        bb.addVertex(m, -0.5f, yy, -0.5f).setColor(r, g, b, a).setUv(0.0f, 0.0f).setUv2(lightmapX, lightmapY);
        bb.addVertex(m, -0.5f, yy, 0.5f).setColor(r, g, b, a).setUv(0.0f, 1.0f).setUv2(lightmapX, lightmapY);
        bb.addVertex(m, 0.5f, yy, 0.5f).setColor(r, g, b, a).setUv(1.0f, 1.0f).setUv2(lightmapX, lightmapY);
        bb.addVertex(m, 0.5f, yy, -0.5f).setColor(r, g, b, a).setUv(1.0f, 0.0f).setUv2(lightmapX, lightmapY);
        RenderUtils.rotateQ(15.0f, 0.0f, 1.0f, 0.0f, matrix);
        ringsize = (float)((double)ringsize + ((double)(height + space) + 0.08));
        yy = (float)((double)yy + yOffset);
        t2 = RenderUtils.renderRing(matrix, (MultiBufferSource)buffer, (double)yy, ff += flatness, ringsize, height, 128, lightmapX, lightmapY, r2, g2, b2, a, index++);
        buffer.endBatch(t2);
        t2 = RenderUtils.renderRing(matrix, (MultiBufferSource)buffer, (double)yy, ff, ringsize - innersizeOffset, height, 128, lightmapX, lightmapY, r, g, b, a, index++);
        buffer.endBatch(t2);
        RenderUtils.rotateQ(15.0f, 0.0f, 1.0f, 0.0f, matrix);
        yy = (float)((double)yy + yOffset);
        t2 = RenderUtils.renderRing(matrix, (MultiBufferSource)buffer, (double)yy, ff += flatness, ringsize += height + space, height, 128, lightmapX, lightmapY, r2, g2, b2, a, index++);
        buffer.endBatch(t2);
        t2 = RenderUtils.renderRing(matrix, (MultiBufferSource)buffer, (double)yy, ff, ringsize - innersizeOffset, height, 128, lightmapX, lightmapY, r, g, b, a, index++);
        buffer.endBatch(t2);
        RenderUtils.rotateQ(15.0f, 0.0f, 1.0f, 0.0f, matrix);
        yy = (float)((double)yy + yOffset * 2.0);
        t2 = RenderUtils.renderRing(matrix, (MultiBufferSource)buffer, (double)yy, ff += flatness, ringsize += height + space * 2.0f, height, 128, lightmapX, lightmapY, r2, g2, b2, a, index++);
        buffer.endBatch(t2);
        t2 = RenderUtils.renderRing(matrix, (MultiBufferSource)buffer, (double)yy, ff, ringsize - innersizeOffset, height, 128, lightmapX, lightmapY, r, g, b, a, index++);
        buffer.endBatch(t2);
        matrix.popPose();
    }
}

