/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import stepsword.mahoutsukai.client.ClientHandler;
import stepsword.mahoutsukai.entity.MorganBallEntity;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;

public class RenderMorganBallEntity
extends EntityRenderer<MorganBallEntity> {
    private static final ResourceLocation beam = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/block/white.png");

    public RenderMorganBallEntity(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public ResourceLocation getTextureLocation(MorganBallEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    public void render(MorganBallEntity entity, float eyaw, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int packedLight) {
    }

    public static void renderMorganBall(MorganBallEntity entity, double x, double y, double z, PoseStack matrix, float partialTicks) {
        float spike_len = entity.prev_spike_len + (entity.getSpikeLength() - entity.prev_spike_len) * partialTicks;
        float sphere_size = entity.prev_sphere_size + (entity.getSphereSize() - entity.prev_sphere_size) * partialTicks;
        matrix.pushPose();
        matrix.translate(x, y, z);
        matrix.scale(sphere_size, sphere_size, sphere_size);
        float[] colors = entity.getColor();
        float outeralpha = 0.06f;
        float beam_y_off = 0.0f;
        int lightmapX = 240;
        int lightmapY = 240;
        float r = colors[0];
        float g = colors[1];
        float b = colors[2];
        float a = colors[3];
        float r2 = colors[4];
        float g2 = colors[5];
        float b2 = colors[6];
        RenderMorganBallEntity.rotate(0.0f, 0.0f, 0.0f, matrix);
        matrix.translate(0.0f, beam_y_off, 0.0f);
        RenderType ringtype = MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createSphereRenderType(RenderUtils.runes, 0));
        RenderType spheretype2 = MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createSphereRenderType(beam, 1));
        MultiBufferSource.BufferSource buf = Minecraft.getInstance().renderBuffers().bufferSource();
        RenderUtils.renderSphere(matrix, (MultiBufferSource)buf, sphere_size, 20, 240, 240, r2, g2, b2, 1.0f, spheretype2);
        buf.endBatch(spheretype2);
        float unscalesphere = 1.0f / sphere_size;
        matrix.scale(unscalesphere, unscalesphere, unscalesphere);
        float scalef = 1.2f;
        float unscalef = 1.0f / scalef;
        if (entity.yaws != null && entity.pitchs != null && entity.ds != null) {
            for (int i = 0; i < entity.yaws.size(); ++i) {
                if (i >= entity.pitchs.size() || i >= entity.ds.size()) continue;
                RenderUtils.rotateQ(entity.yaws.get(i).floatValue(), 0.0f, 1.0f, 0.0f, matrix);
                RenderUtils.rotateQ(entity.pitchs.get(i).floatValue(), 1.0f, 0.0f, 0.0f, matrix);
                matrix.scale(0.2f, spike_len / 2.0f * entity.ds.get(i).floatValue(), 0.2f);
                matrix.translate(0.0f, 1.0f, 0.0f);
                matrix.scale(unscalef, unscalef, unscalef);
                RenderMorganBallEntity.renderPyramid(matrix, buf, r2, g2, b2, 1.0f, beam);
                matrix.scale(scalef, scalef, scalef);
                RenderMorganBallEntity.renderPyramid(matrix, buf, r, g, b, 1.0f, RenderUtils.runes);
                matrix.translate(0.0f, -1.0f, 0.0f);
                matrix.scale(5.0f, 2.0f / (spike_len * entity.ds.get(i).floatValue()), 5.0f);
                RenderUtils.rotateQ(-entity.pitchs.get(i).floatValue(), 1.0f, 0.0f, 0.0f, matrix);
                RenderUtils.rotateQ(-entity.yaws.get(i).floatValue(), 0.0f, 1.0f, 0.0f, matrix);
            }
        }
        float sz = 0.5f * sphere_size / entity.maxsize;
        float ht = 0.2f * sphere_size / entity.maxsize;
        float roll = ClientHandler.clientTickCounter;
        RenderUtils.rotateQ(80.0f, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(45.0f, 1.0f, 0.0f, 0.0f, matrix);
        RenderUtils.rotateQ(roll, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.renderRing(matrix, (MultiBufferSource)buf, 0.0, 90.0f, sphere_size + sz, ht, 32, 240, 240, r, g, b, 1.0f, ringtype);
        buf.endBatch(ringtype);
        RenderUtils.rotateQ(-roll, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(-45.0f, 1.0f, 0.0f, 0.0f, matrix);
        RenderUtils.rotateQ(-80.0f, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(80.0f, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(-45.0f, 1.0f, 0.0f, 0.0f, matrix);
        RenderUtils.rotateQ(roll, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.renderRing(matrix, (MultiBufferSource)buf, 0.0, 90.0f, sphere_size + sz, ht, 32, 240, 240, r, g, b, 1.0f, ringtype);
        buf.endBatch(ringtype);
        RenderUtils.rotateQ(-roll, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(45.0f, 1.0f, 0.0f, 0.0f, matrix);
        RenderUtils.rotateQ(-80.0f, 0.0f, 1.0f, 0.0f, matrix);
        matrix.popPose();
    }

    public static void renderPyramid(PoseStack stack, MultiBufferSource.BufferSource buf, float r, float g, float b, float a, ResourceLocation loc) {
        RenderType type = MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createTriangleRenderType(loc, 0));
        VertexConsumer bb = buf.getBuffer(type);
        Matrix4f m = stack.last().pose();
        int lx = 240;
        int ly = 240;
        bb.addVertex(m, 0.0f, 1.0f, 0.0f).setColor(r, g, b, a).setUv(0.0f, 0.0f).setUv2(lx, ly);
        bb.addVertex(m, -1.0f, -1.0f, 1.0f).setColor(r, g, b, a).setUv(0.5f, 0.5f).setUv2(lx, ly);
        bb.addVertex(m, 1.0f, -1.0f, 1.0f).setColor(r, g, b, a).setUv(1.0f, 1.0f).setUv2(lx, ly);
        bb.addVertex(m, 0.0f, 1.0f, 0.0f).setColor(r, g, b, a).setUv(0.0f, 0.0f).setUv2(lx, ly);
        bb.addVertex(m, 1.0f, -1.0f, 1.0f).setColor(r, g, b, a).setUv(0.5f, 0.5f).setUv2(lx, ly);
        bb.addVertex(m, 1.0f, -1.0f, -1.0f).setColor(r, g, b, a).setUv(1.0f, 1.0f).setUv2(lx, ly);
        bb.addVertex(m, 0.0f, 1.0f, 0.0f).setColor(r, g, b, a).setUv(0.0f, 0.0f).setUv2(lx, ly);
        bb.addVertex(m, 1.0f, -1.0f, -1.0f).setColor(r, g, b, a).setUv(0.5f, 0.5f).setUv2(lx, ly);
        bb.addVertex(m, -1.0f, -1.0f, -1.0f).setColor(r, g, b, a).setUv(1.0f, 1.0f).setUv2(lx, ly);
        bb.addVertex(m, 0.0f, 1.0f, 0.0f).setColor(r, g, b, a).setUv(0.0f, 0.0f).setUv2(lx, ly);
        bb.addVertex(m, -1.0f, -1.0f, -1.0f).setColor(r, g, b, a).setUv(0.5f, 0.5f).setUv2(lx, ly);
        bb.addVertex(m, -1.0f, -1.0f, 1.0f).setColor(r, g, b, a).setUv(1.0f, 1.0f).setUv2(lx, ly);
        buf.endBatch(type);
    }

    public static void rotate(float yaw, float pitch, float roll, PoseStack matrix) {
        RenderUtils.rotateQ(roll, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(pitch, 1.0f, 0.0f, 0.0f, matrix);
        RenderUtils.rotateQ(yaw, 0.0f, 1.0f, 0.0f, matrix);
    }
}

