/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.proxy;

import com.mojang.authlib.GameProfile;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.PlayLevelSoundEvent;
import stepsword.mahoutsukai.Keybinds;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.client.ClientHandler;
import stepsword.mahoutsukai.client.ClientHandlerModEventBus;
import stepsword.mahoutsukai.dataattachments.mahou.IMahou;
import stepsword.mahoutsukai.entity.mahoujin.GandrEntity;
import stepsword.mahoutsukai.entity.mahoujin.GunBeamProjectileEntity;
import stepsword.mahoutsukai.entity.mahoujin.ReplicaTeleportMahoujinEntity;
import stepsword.mahoutsukai.item.guide.ContentsPage;
import stepsword.mahoutsukai.item.guide.DoubleInfoPage;
import stepsword.mahoutsukai.item.guide.GuidebookInstance;
import stepsword.mahoutsukai.item.guide.InfoPage;
import stepsword.mahoutsukai.item.guide.Page;
import stepsword.mahoutsukai.item.guide.SpellPage;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.networking.ProjectorRightClickPacket;
import stepsword.mahoutsukai.proxy.CommonProxy;
import stepsword.mahoutsukai.render.gui.FogProjectorScreen;
import stepsword.mahoutsukai.render.gui.MahoujinProjectorScreen;
import stepsword.mahoutsukai.render.gui.PlayerSettingsGUI;
import stepsword.mahoutsukai.render.gui.ReplicaGui;
import stepsword.mahoutsukai.render.gui.WheelGui;
import stepsword.mahoutsukai.render.gui.guide.ContentsPageGui;
import stepsword.mahoutsukai.render.gui.guide.DoubleInfoPageGui;
import stepsword.mahoutsukai.render.gui.guide.InfoPageGui;
import stepsword.mahoutsukai.render.gui.guide.PageGui;
import stepsword.mahoutsukai.render.gui.guide.SpellPageGui;
import stepsword.mahoutsukai.render.particle.FogParticleType;
import stepsword.mahoutsukai.render.particle.LightningParticleType;
import stepsword.mahoutsukai.render.particle.MagicParticleType;
import stepsword.mahoutsukai.render.particle.ModParticles;
import stepsword.mahoutsukai.render.particle.ParticleFog;
import stepsword.mahoutsukai.render.particle.ParticleLightning;
import stepsword.mahoutsukai.render.particle.ParticleMagic;
import stepsword.mahoutsukai.render.particle.ParticleSmokeRing;
import stepsword.mahoutsukai.render.particle.PetalParticleType;
import stepsword.mahoutsukai.render.tile.MahouRenderRL;
import stepsword.mahoutsukai.tile.displacement.ScryingMahoujinTileEntity;
import stepsword.mahoutsukai.util.Utils;

public class ClientProxy
extends CommonProxy {
    boolean sensechanged = false;
    double oldsense;
    static Field entities;
    static Field particles;
    static Map<ParticleRenderType, Queue<Particle>> ps;

    public ClientProxy(ModContainer container) {
        super(container);
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    @Override
    public void openProjectorGUI(Level w, BlockPos p) {
        Minecraft.getInstance().setScreen((Screen)new MahoujinProjectorScreen(w, p));
    }

    @Override
    public void openSettingsGUI(Level w, UUID uuid) {
        Minecraft.getInstance().setScreen((Screen)new PlayerSettingsGUI(w, uuid));
    }

    @Override
    public void openFogProjectorGUI(Level w, BlockPos p) {
        Minecraft.getInstance().setScreen((Screen)new FogProjectorScreen(w, p));
    }

    @Override
    public void spawnFog(BlockPos blockPos, float particle_fog_size, float r, float g, float b, float a, float particle_fog_thickness, float particle_fog_speed, boolean particle_fog_random_x, boolean particle_fog_random_y, boolean particle_fog_random_z, float particle_fog_direction_x, float particle_fog_direction_y, float particle_fog_direction_z, boolean particle_fog_shaders, int particle_fog_frequency_num) {
        Vec3 direction = new Vec3((double)particle_fog_direction_x, (double)particle_fog_direction_y, (double)particle_fog_direction_z);
        direction = direction.normalize();
        Random random = Utils.getRandom((Level)Minecraft.getInstance().level);
        for (int i = 0; i < particle_fog_frequency_num; ++i) {
            double newX = direction.x;
            double newY = direction.y;
            double newZ = direction.z;
            if (particle_fog_random_x) {
                newX = random.nextDouble() * 2.0 - 1.0;
            }
            if (particle_fog_random_y) {
                newY = random.nextDouble() * 2.0 - 1.0;
            }
            if (particle_fog_random_z) {
                newZ = random.nextDouble() * 2.0 - 1.0;
            }
            direction = new Vec3(newX, newY, newZ);
            direction = direction.normalize();
            direction = direction.scale((double)particle_fog_speed);
            ParticleFog p = new ParticleFog(Minecraft.getInstance().level, MahouRenderRL.fog, (float)blockPos.getX() + 0.5f, (float)blockPos.getY() + 0.5f, (float)blockPos.getZ() + 0.5f, 2.0f, direction.x, direction.y, direction.z, particle_fog_shaders, r, g, b, a, particle_fog_thickness, particle_fog_size);
            Minecraft.getInstance().particleEngine.add((Particle)p);
        }
    }

    @Override
    public void openWheelGUI(Level w, ItemStack s) {
        Minecraft.getInstance().setScreen((Screen)new WheelGui(w, s));
    }

    @Override
    public void openReplicaWheelGUI(Level w, ItemStack s) {
        Minecraft.getInstance().setScreen((Screen)new ReplicaGui(w, s));
    }

    @Override
    public void init() {
        ClientHandler client = new ClientHandler();
        NeoForge.EVENT_BUS.register((Object)client);
        ClientHandlerModEventBus clientMod = new ClientHandlerModEventBus();
        MahouTsukaiMod.MOD_EVENT_BUS.register((Object)clientMod);
        super.init();
    }

    @Override
    public Player getPlayerForScry(Level world, String viewTarget, CompoundTag scryNBT, UUID uuid) {
        Player playertarget = ScryingMahoujinTileEntity.getPlayerByName(viewTarget, world);
        if (playertarget == null && uuid != null) {
            RemotePlayer player = new RemotePlayer((ClientLevel)world, new GameProfile(uuid, viewTarget));
            try {
                player.load(scryNBT);
            }
            catch (Exception e) {
                System.err.println("Mahou Tsukai: Could not read player NBT:" + e.toString());
            }
            return player;
        }
        if (playertarget != null && scryNBT != null) {
            RemotePlayer player = new RemotePlayer((ClientLevel)world, playertarget.getGameProfile());
            try {
                player.load(scryNBT);
            }
            catch (Exception e) {
                System.err.println("Mahou Tsukai: Could not read player NBT:" + e.toString());
            }
            return player;
        }
        return null;
    }

    @Override
    public void revertPlayer() {
        super.revertPlayer();
    }

    public static HashSet<Entity> getAllEntities(ClientLevel world) {
        return new HashSet<Entity>(StreamSupport.stream(world.getEntities().getAll().spliterator(), false).collect(Collectors.toSet()));
    }

    @Override
    public void openGuideGUI(GuidebookInstance book, Player playerIn) {
        IMahou mahou = Utils.getPlayerMahou(playerIn);
        int savedPage = 0;
        savedPage = mahou.getGuidePage();
        book.setCurrentPage(savedPage);
        if (book.getPage() instanceof ContentsPage) {
            Minecraft.getInstance().setScreen((Screen)new ContentsPageGui(book, (ContentsPage)book.getPage()));
        } else if (book.getPage() instanceof InfoPage) {
            Minecraft.getInstance().setScreen((Screen)new InfoPageGui(book, (InfoPage)book.getPage()));
        } else if (book.getPage() instanceof SpellPage) {
            Minecraft.getInstance().setScreen((Screen)new SpellPageGui(book, (SpellPage)book.getPage()));
        } else if (book.getPage() instanceof DoubleInfoPage) {
            Minecraft.getInstance().setScreen((Screen)new DoubleInfoPageGui(book, (DoubleInfoPage)book.getPage()));
        } else if (book.getPage() instanceof Page) {
            Minecraft.getInstance().setScreen((Screen)new PageGui(book));
        }
    }

    @Override
    public void slowDown() {
        if (!this.sensechanged) {
            this.oldsense = (Double)Minecraft.getInstance().options.sensitivity().get();
            Minecraft.getInstance().options.sensitivity().set((Object)(this.oldsense * (double)0.34f));
            this.sensechanged = true;
        }
    }

    @Override
    public void speedUp() {
        if (this.sensechanged) {
            Minecraft.getInstance().options.sensitivity().set((Object)this.oldsense);
            this.sensechanged = false;
        }
    }

    @Override
    public boolean isMahouTsukai() {
        IMahou mahou = Utils.getPlayerMahou((Player)Minecraft.getInstance().player);
        if (mahou != null) {
            return mahou.hasMagic();
        }
        return false;
    }

    @Override
    public void playSound(Entity e, double x, double y, double z, SoundEvent soundIn, SoundSource category, float volume, float pitch) {
        PlayLevelSoundEvent.AtEntity event = EventHooks.onPlaySoundAtEntity((Entity)e, (Holder)new Holder.Direct((Object)soundIn), (SoundSource)category, (float)volume, (float)pitch);
        if (event.isCanceled() || event.getSound() == null) {
            return;
        }
        soundIn = (SoundEvent)event.getSound().value();
        category = event.getSource();
        volume = event.getNewVolume();
        this.playSound(x, y, z, soundIn, category, volume, pitch, false);
    }

    public void playSound(double x, double y, double z, SoundEvent soundIn, SoundSource category, float volume, float pitch, boolean distanceDelay) {
        double d0 = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().distanceToSqr(x, y, z);
        SimpleSoundInstance simplesound = new SimpleSoundInstance(soundIn, category, volume, pitch, RandomSource.create(), x, y, z);
        if (distanceDelay && d0 > 100.0) {
            double d1 = Math.sqrt(d0) / 40.0;
            Minecraft.getInstance().getSoundManager().playDelayed((SoundInstance)simplesound, (int)(d1 * 20.0));
        } else {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)simplesound);
        }
    }

    @Override
    public void registerFactories() {
        Minecraft.getInstance().particleEngine.register((ParticleType)ModParticles.PETAL.get(), PetalParticleType.PetalFactory::new);
        Minecraft.getInstance().particleEngine.register((ParticleType)ModParticles.RED_LIGHTNING.get(), (ParticleProvider)new LightningParticleType.LightningFactory(new Color(255, 0, 0, 255), new Color(255, 120, 120)));
        Minecraft.getInstance().particleEngine.register((ParticleType)ModParticles.YELLOW_LIGHTNING.get(), (ParticleProvider)new LightningParticleType.LightningFactory(new Color(255, 255, 0, 255), new Color(255, 255, 70)));
        Minecraft.getInstance().particleEngine.register((ParticleType)ModParticles.FOG1.get(), (ParticleProvider)new FogParticleType.FogFactory(MahouRenderRL.fog));
        Minecraft.getInstance().particleEngine.register((ParticleType)ModParticles.RED_MAGIC.get(), (ParticleProvider)new MagicParticleType.MagicParticleFactory("textures/particle/white_magic_particle", 0.2f, 1.0f, 0.0f, 0.0f, 1.0f, true));
        Minecraft.getInstance().particleEngine.register((ParticleType)ModParticles.YELLOW_MAGIC.get(), (ParticleProvider)new MagicParticleType.MagicParticleFactory("textures/particle/white_magic_particle", 0.6f, 1.0f, 1.0f, 0.2f, 0.9f, false));
        Minecraft.getInstance().particleEngine.register((ParticleType)ModParticles.BLACK_MAGIC.get(), (ParticleProvider)new MagicParticleType.MagicParticleFactory("textures/particle/white_magic_particle", 0.2f, 0.0f, 0.0f, 0.0f, 1.0f, true));
        Minecraft.getInstance().particleEngine.register((ParticleType)ModParticles.RED_MAGIC_BIG.get(), (ParticleProvider)new MagicParticleType.MagicParticleFactory("textures/particle/white_magic_particle", 1.2f, 1.0f, 0.0f, 0.0f, 0.0f, true));
        Minecraft.getInstance().particleEngine.register((ParticleType)ModParticles.BLACK_MAGIC_BIG.get(), (ParticleProvider)new MagicParticleType.MagicParticleFactory("textures/particle/white_magic_particle", 1.2f, 0.0f, 0.0f, 0.0f, 1.0f, true));
    }

    public static HashSet<Particle> getNoRenderParticles(ParticleEngine manager) {
        Queue<Particle> q;
        if (ps == null) {
            ps = (Map)ObfuscationReflectionHelper.getPrivateValue(ParticleEngine.class, (Object)manager, (String)"particles");
        }
        if (ps != null && (q = ps.get(ParticleRenderType.NO_RENDER)) != null) {
            return new HashSet<Particle>(q);
        }
        return new HashSet<Particle>();
    }

    @Override
    public void smiteParticles(double x, double y, double z, RandomSource rand, boolean boom, float size, float r, float g, float b) {
        block4: {
            double range = 0.0;
            if (Minecraft.getInstance().level == null) break block4;
            if (!boom) {
                for (int i = 0; i < 6; ++i) {
                    double xoff = (rand.nextDouble() - 0.5) * range;
                    double yoff = (rand.nextDouble() - 0.5) * 1.2;
                    double zoff = (rand.nextDouble() - 0.5) * range;
                    ParticleMagic p = new ParticleMagic(Minecraft.getInstance().level, x + xoff, y + (double)i * 0.16, z + zoff, 0.5f, 0.0, 0.0, 0.0, "textures/particle/white_magic_particle", size, r, g, b, 1.0f, 36.0f);
                    Minecraft.getInstance().particleEngine.add((Particle)p);
                }
            } else {
                for (int i = 0; i < 30; ++i) {
                    double xoff = 0.0;
                    double yoff = 0.0;
                    double zoff = 0.0;
                    Vec3 vec = new Vec3(rand.nextDouble() - 0.5, 0.0, rand.nextDouble() - 0.5).normalize();
                    ParticleMagic p = new ParticleMagic(Minecraft.getInstance().level, x, y, z, 0.5f, vec.x, 0.0, vec.z, "textures/particle/white_magic_particle", size, r, g, b, 1.0f, 27.0f);
                    Minecraft.getInstance().particleEngine.add((Particle)p);
                }
            }
        }
    }

    @Override
    public void spawnGandrParticle(GandrEntity entity) {
        float[] rgb = entity.getColor();
        ParticleMagic p = new ParticleMagic(Minecraft.getInstance().level, entity.getX(), entity.getY(), entity.getZ(), 0.5f, 0.0, 0.0, 0.0, "textures/particle/white_magic_particle", 0.2f, rgb[0], rgb[1], rgb[2], 1.0f, true);
        Minecraft.getInstance().particleEngine.add((Particle)p);
    }

    @Override
    public void spawnReplicaTeleportParticles(ReplicaTeleportMahoujinEntity entity) {
        float[] rgb = entity.getColor();
        float radius = entity.getCircleSize();
        ParticleStatus particlestatus = (ParticleStatus)Minecraft.getInstance().options.particles().get();
        int particles = 22;
        if (particlestatus == ParticleStatus.DECREASED) {
            particles = 10;
        } else if (particlestatus == ParticleStatus.MINIMAL) {
            particles = 5;
        }
        int i = 0;
        while ((float)i < radius * (float)particles) {
            if (Math.random() < 0.03) {
                double r = (double)radius * Math.sqrt(Math.random());
                double theta = Math.random() * 2.0 * Math.PI;
                double x = entity.getX() + r * Math.cos(theta);
                double z = entity.getZ() + r * Math.sin(theta);
                double y = entity.getY() + Math.random() * 0.4;
                ParticleMagic p = new ParticleMagic(Minecraft.getInstance().level, x, y, z, (float)(Math.random() * 0.4) + 0.2f, 0.0, Math.random() * 0.03 + 0.01, 0.0, "textures/particle/white_magic_particle", (float)Math.random() * 0.6f + 0.1f, rgb[0], rgb[1], rgb[2], 1.0f, true, 0.99);
                Minecraft.getInstance().particleEngine.add((Particle)p);
            }
            ++i;
        }
    }

    @Override
    public boolean projectorArmorClick(Player player, BlockPos pos) {
        if (player.getMainHandItem().getItem() instanceof ArmorItem) {
            ProjectorRightClickPacket.ARMOR_ACTION action = ProjectorRightClickPacket.ARMOR_ACTION.REPLACE;
            if (Keybinds.changeMysticCode.isDown()) {
                action = ProjectorRightClickPacket.ARMOR_ACTION.ADD;
            } else if (Keybinds.drawMahoujin.isDown()) {
                action = ProjectorRightClickPacket.ARMOR_ACTION.REMOVE;
            }
            ProjectorRightClickPacket packet = new ProjectorRightClickPacket(action, pos);
            PacketHandler.sendToServer(packet);
            return true;
        }
        return false;
    }

    @Override
    public Player getPlayer() {
        return Minecraft.getInstance().player;
    }

    @Override
    public void spawnGunBeamLightning(GunBeamProjectileEntity beam) {
        float[] colors = beam.getColor();
        Vec3 v = beam.getPosition(1.0f);
        RandomSource rand = beam.getRandom();
        if (!beam.getFired()) {
            Vec3 q = new Vec3(1.0, 1.0, 1.0).normalize();
            q = q.yRot(org.joml.Math.toRadians((float)rand.nextInt(360))).xRot(org.joml.Math.toRadians((float)rand.nextInt(360))).scale(0.3);
            q = q.add(v);
            ParticleLightning p = new ParticleLightning(Minecraft.getInstance().level, new Color(colors[0], colors[1], colors[2]), new Color(colors[4], colors[5], colors[6]), q.x, q.y, q.z, beam.getLength(), v.x, v.y, v.z);
            p.yawrot = beam.random.nextInt(360);
            Minecraft.getInstance().particleEngine.add((Particle)p);
        }
    }

    @Override
    public void spawnSmokeRings(GunBeamProjectileEntity beam) {
        float[] colors = beam.getColor();
        Vec3 v = beam.getPosition(1.0f);
        ParticleSmokeRing p = new ParticleSmokeRing(Minecraft.getInstance().level, new Color(colors[0], colors[1], colors[2]), v.x, v.y, v.z);
        p.yaw = beam.getRotationYaw();
        p.pitch = beam.getRotationPitch();
        Minecraft.getInstance().particleEngine.add((Particle)p);
    }

    static {
        ps = null;
    }
}

