/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.potion;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.items.IItemHandler;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.datacomponents.kodoku.KodokuMahou;
import stepsword.mahoutsukai.handlers.ServerHandler;
import stepsword.mahoutsukai.item.kodoku.KodokuItem;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class MisfortunePotion
extends MobEffect {
    protected MisfortunePotion() {
        super(MobEffectCategory.NEUTRAL, ModEffects.getColorNumber(22, 22, 22));
        EffectUtil.effectIcon = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/effects/misfortune.png");
    }

    public static void kodokuPotionRemove(MobEffectEvent.Remove event) {
        if (event.getEffectInstance().getEffect() == ModEffects.MISFORTUNE.get() && !event.getEntity().getMainHandItem().isEmpty()) {
            event.setCanceled(true);
        }
    }

    public static void misfortuneLivingUpdate(LivingEntity living) {
        if (EffectUtil.hasBuff(living, ModEffects.MISFORTUNE) && !living.level().isClientSide && ServerHandler.tickCounter % 4L == 0L) {
            int level = EffectUtil.getBuffLevel(living, ModEffects.MISFORTUNE);
            if ((level -= MisfortunePotion.getMaxKodoku(living)) > 0) {
                ItemStack s;
                IItemHandler inv;
                double lightningchance = MTConfig.KODOKU_MISFORTUNE_LIGHTNING_CHANCE;
                double dropitemchance = MTConfig.KODOKU_MISFORTUNE_DROP_CHANCE;
                double aggrochance = MTConfig.KODOKU_MISFORTUNE_AGGRO_CHANCE;
                double tripchance = MTConfig.KODOKU_MISFORTUNE_TRIP_CHANCE;
                float aggro = living.getRandom().nextFloat();
                float trip = living.getRandom().nextFloat();
                float drop = living.getRandom().nextFloat();
                float lightning = living.getRandom().nextFloat();
                if ((double)aggro < aggrochance * (double)level) {
                    int range = 40;
                    AABB aabb = new AABB(living.getX() - (double)range, living.getY() - 10.0, living.getZ() - (double)range, living.getX() + (double)range, living.getY() + 10.0, living.getZ() + (double)range);
                    List lst = living.level().getEntitiesOfClass(Mob.class, aabb);
                    if (lst.size() > 0) {
                        ((Mob)lst.get(living.getRandom().nextInt(lst.size()))).setLastHurtByMob(living);
                    }
                }
                if ((double)drop < dropitemchance * (double)level && (inv = Utils.getInventory(living)) != null && inv.getSlots() > 0 && Utils.getInventory(s = inv.getStackInSlot(living.getRandom().nextInt(inv.getSlots()))) == null) {
                    living.spawnAtLocation((ItemLike)s.getItem(), 1);
                    s.shrink(1);
                }
                if ((double)trip < tripchance * (double)level) {
                    Vec3 motion = living.getDeltaMovement();
                    double motionX = motion.x;
                    double motionY = motion.y;
                    double motionZ = motion.z;
                    living.hurtMarked = true;
                    living.setDeltaMovement(motionX += living.getLookAngle().x * 2.0, motionY, motionZ += living.getLookAngle().z * 2.0);
                }
                if ((double)lightning < lightningchance * (double)level) {
                    LightningBolt lightningb = (LightningBolt)EntityType.LIGHTNING_BOLT.create(living.level());
                    lightningb.moveTo(new Vec3(living.getX(), living.getY(), living.getZ()));
                    lightningb.setVisualOnly(false);
                    ((ServerLevel)living.level()).addFreshEntity((Entity)lightningb);
                }
            }
        }
    }

    public static void misfortuneBreakEvent(BlockEvent.BreakEvent event) {
        if (EffectUtil.hasBuff((LivingEntity)event.getPlayer(), ModEffects.MISFORTUNE) && !event.getPlayer().level().isClientSide) {
            int level = EffectUtil.getBuffLevel((LivingEntity)event.getPlayer(), ModEffects.MISFORTUNE) / MTConfig.KODOKU_TOOL_BREAK_DIVISOR;
            event.getPlayer().getItemInHand(InteractionHand.MAIN_HAND).hurtAndBreak(level, (LivingEntity)event.getPlayer(), EquipmentSlot.MAINHAND);
        }
    }

    public static void misfortuneLootEvent(LivingDropsEvent event) {
        Entity base = event.getSource().getEntity();
        if (base instanceof LivingEntity && !base.level().isClientSide && EffectUtil.hasBuff((LivingEntity)base, ModEffects.MISFORTUNE)) {
            int level = EffectUtil.getBuffLevel((LivingEntity)base, ModEffects.MISFORTUNE) / MTConfig.KODOKU_LOOT_DIVISOR;
            for (int i = 0; i < level; ++i) {
                if (event.getDrops().size() <= 0) continue;
                int ind = ((LivingEntity)base).getRandom().nextInt(event.getDrops().size());
                event.getDrops().remove(ind);
            }
        }
    }

    public static int getMaxKodoku(LivingEntity living) {
        IItemHandler inventory = Utils.getInventory(living);
        int maxkodoku = 0;
        if (inventory != null) {
            for (int i = 0; i < inventory.getSlots(); ++i) {
                KodokuMahou mahou;
                ItemStack s = inventory.getStackInSlot(i);
                if (s.isEmpty() || !(s.getItem() instanceof KodokuItem) || (mahou = Utils.getKodokuMahou(s)) == null || mahou.getKodoku() <= maxkodoku) continue;
                maxkodoku = mahou.getKodoku();
            }
        }
        return maxkodoku;
    }
}

