/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import stepsword.mahoutsukai.dataattachments.settingsmahou.ISettingsMahou;
import stepsword.mahoutsukai.networking.MahouPackets;
import stepsword.mahoutsukai.util.Utils;

public class SettingsUpdatePacket
implements CustomPacketPayload {
    int spell;
    List<Integer> valuesInt;
    public static final StreamCodec<ByteBuf, SettingsUpdatePacket> STREAM_CODEC = new StreamCodec<ByteBuf, SettingsUpdatePacket>(){

        public SettingsUpdatePacket decode(ByteBuf buf) {
            SettingsUpdatePacket packet = new SettingsUpdatePacket();
            packet.decode(buf);
            return packet;
        }

        public void encode(ByteBuf buf, SettingsUpdatePacket packet) {
            packet.encode(buf);
        }
    };

    public SettingsUpdatePacket() {
    }

    public SettingsUpdatePacket(int spell, List<Integer> valuesInt) {
        this.spell = spell;
        this.valuesInt = valuesInt;
    }

    public void decode(ByteBuf buf) {
        this.spell = buf.readInt();
        int sz = buf.readInt();
        this.valuesInt = new ArrayList<Integer>();
        for (int i = 0; i < sz; ++i) {
            this.valuesInt.add(buf.readInt());
        }
    }

    public void encode(ByteBuf buf) {
        buf.writeInt(this.spell);
        buf.writeInt(this.valuesInt.size());
        for (int i = 0; i < this.valuesInt.size(); ++i) {
            buf.writeInt(this.valuesInt.get(i).intValue());
        }
    }

    public static void handle(SettingsUpdatePacket message, IPayloadContext context) {
        Player player = context.player();
        ISettingsMahou mahou = Utils.getSettingsMahou((LivingEntity)player);
        mahou.setIntSettings(message.spell, message.valuesInt);
    }

    public CustomPacketPayload.Type<SettingsUpdatePacket> type() {
        return MahouPackets.SETTINGS_UPDATE_TYPE;
    }
}

