/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.mahoujin.GunBeamProjectileEntity;
import stepsword.mahoutsukai.entity.mahoujin.GunEntity;
import stepsword.mahoutsukai.item.nobu.Nobu;
import stepsword.mahoutsukai.networking.MahouPackets;
import stepsword.mahoutsukai.sounds.ModSounds;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class NobuBeamCreatePacket
implements CustomPacketPayload {
    public List<Integer> eids = new ArrayList<Integer>();
    public int fire = 0;
    public static final StreamCodec<ByteBuf, NobuBeamCreatePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT.apply(ByteBufCodecs.list()), p -> p.eids, (StreamCodec)ByteBufCodecs.INT, p -> p.fire, NobuBeamCreatePacket::new);

    public NobuBeamCreatePacket(List<Integer> i, int b) {
        this.eids = new ArrayList<Integer>(i);
        this.fire = b;
    }

    public NobuBeamCreatePacket(List<Integer> i, NobuFirePacket b) {
        this.eids = new ArrayList<Integer>(i);
        this.fire = b.ordinal();
    }

    public static void handle(NobuBeamCreatePacket message, IPayloadContext context) {
        Player player = context.player();
        Level world = player.level();
        if (message.fire == NobuFirePacket.CREATE_BEAM.ordinal()) {
            for (Integer i : message.eids) {
                Entity e = world.getEntity(i.intValue());
                if (e == null) continue;
                NobuBeamCreatePacket.summonBeamAt(player, e);
            }
        } else if (message.fire == NobuFirePacket.FIRE_BEAM.ordinal()) {
            if (MTConfig.NOBU_PERSONAL_DRUM) {
                int drum = player.random.nextInt(3);
                SoundEvent sound = (new SoundEvent[]{(SoundEvent)ModSounds.TAIKO1.get(), (SoundEvent)ModSounds.TAIKO2.get(), (SoundEvent)ModSounds.TAIKO3.get()})[drum];
                player.level().playSound(null, Utils.toBlockPos(player.position()), sound, SoundSource.NEUTRAL, (float)MTConfig.NOBU_DRUM_VOLUME, 1.0f);
            }
            NobuBeamCreatePacket.fireBeamAt(player);
        } else if (message.fire == NobuFirePacket.FIRE_GUN.ordinal()) {
            if (NobuBeamCreatePacket.fireGuns(player)) {
                player.level().playSound(null, Utils.toBlockPos(player.position()), (SoundEvent)ModSounds.TAIKOFIRE.get(), SoundSource.NEUTRAL, (float)MTConfig.NOBU_DRUM_VOLUME, 1.0f);
            }
        } else if (message.fire == NobuFirePacket.RAISE_ANGLE.ordinal()) {
            player.level().playSound(null, Utils.toBlockPos(player.position()), (SoundEvent)ModSounds.TAIKOBOSS.get(), SoundSource.NEUTRAL, (float)MTConfig.NOBU_DRUM_VOLUME, 1.0f);
            NobuBeamCreatePacket.pitchGuns(player, true);
        } else if (message.fire == NobuFirePacket.LOWER_ANGLE.ordinal()) {
            player.level().playSound(null, Utils.toBlockPos(player.position()), (SoundEvent)ModSounds.TAIKOBOSS.get(), SoundSource.NEUTRAL, (float)MTConfig.NOBU_DRUM_VOLUME, 1.0f);
            NobuBeamCreatePacket.pitchGuns(player, false);
        }
    }

    public static void summonBeamAt(Player player, Entity entity) {
        List beams = player.level().getEntities((Entity)player, player.getBoundingBox().inflate(4.0), a -> a instanceof GunBeamProjectileEntity);
        for (Entity e : beams) {
            GunBeamProjectileEntity beam;
            if (!(e instanceof GunBeamProjectileEntity) || (beam = (GunBeamProjectileEntity)e).getCasterUUID() == null || !beam.getCasterUUID().equals(player.getUUID()) || beam.getTarget() != entity.getId()) continue;
            return;
        }
        float beamHeight = player.random.nextFloat() * 2.0f;
        Vec3 target = entity.getEyePosition();
        Vec3 caster = player.position();
        Vec3 spawn = new Vec3(caster.x, (double)(0.8f + beamHeight) + caster.y, caster.z);
        Vec3 aim = target.subtract(spawn).normalize();
        spawn = spawn.add(aim.scale(2.0)).add(aim.yRot(Math.toRadians((float)90.0f)).normalize().scale((double)(player.random.nextFloat() * 4.0f - 2.0f)));
        aim = target.subtract(spawn).normalize();
        float[] colors = Nobu.getColor(player, 0);
        GunBeamProjectileEntity beam = new GunBeamProjectileEntity(player.level(), player.getUUID(), colors[0], colors[1], colors[2], 0.6f, colors[3], colors[4], colors[5], 1.0f, 0.15f, 0.0f, entity.getId());
        beam.setPos(spawn);
        beam.setRotationPitch(EffectUtil.toDegrees((float)java.lang.Math.asin(-aim.y)) + 90.0f);
        beam.setRotationYaw(EffectUtil.toDegrees((float)java.lang.Math.atan2(aim.x, aim.z)));
        player.level().addFreshEntity((Entity)beam);
    }

    public static void fireBeamAt(@NotNull Player player) {
        player.getCooldowns().addCooldown(player.getUseItem().getItem(), 20);
        player.releaseUsingItem();
        List beams = player.level().getEntities((Entity)player, player.getBoundingBox().inflate(30.0), a -> a instanceof GunBeamProjectileEntity);
        for (Entity e : beams) {
            GunBeamProjectileEntity beam;
            if (!(e instanceof GunBeamProjectileEntity) || (beam = (GunBeamProjectileEntity)e).getCasterUUID() == null || !beam.getCasterUUID().equals(player.getUUID()) || beam.getFired() || beam.owner != null) continue;
            Vec3 spawn = beam.position();
            if (!Nobu.doShotMana(player)) continue;
            beam.setFired(true);
            if (beam.getTarget() > 0) {
                Entity target = beam.level().getEntity(beam.getTarget());
                if (target == null || target == player) continue;
                Vec3 targetPos = target.getEyePosition();
                Vec3 aim = targetPos.subtract(spawn).normalize();
                beam.setDeltaMovement(aim.x * 5.0, aim.y * 5.0, aim.z * 5.0);
                beam.aimAt(targetPos);
                continue;
            }
            beam.discard();
        }
    }

    public static boolean fireGuns(@NotNull Player player) {
        if (Nobu.player_storage.containsKey(player.getUUID())) {
            Nobu.NobuUserStorage storage = Nobu.player_storage.get(player.getUUID());
            if (!storage.isFiring) {
                storage.isFiring = true;
                return !storage.guns.isEmpty();
            }
        }
        return false;
    }

    public static void pitchGuns(@NotNull Player player, boolean up) {
        if (Nobu.player_storage.containsKey(player.getUUID())) {
            Nobu.NobuUserStorage storage = Nobu.player_storage.get(player.getUUID());
            for (GunEntity ge : storage.guns.values()) {
                ge.adjustPitch(up);
            }
        }
    }

    public CustomPacketPayload.Type<NobuBeamCreatePacket> type() {
        return MahouPackets.NOBU_BEAM_CREATE_TYPE;
    }

    public static enum NobuFirePacket {
        CREATE_BEAM,
        FIRE_BEAM,
        FIRE_GUN,
        RAISE_ANGLE,
        LOWER_ANGLE;

    }
}

