/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import stepsword.mahoutsukai.item.spells.projection.ProximityProjection.ProximityProjectionKeys;
import stepsword.mahoutsukai.networking.MahouPackets;

public class LongDistanceAttackPacket
implements CustomPacketPayload {
    public int entityId;
    public static final StreamCodec<ByteBuf, LongDistanceAttackPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, p -> p.entityId, LongDistanceAttackPacket::new);

    public LongDistanceAttackPacket(Entity e) {
        this.entityId = e.getId();
    }

    public LongDistanceAttackPacket(int i) {
        this.entityId = i;
    }

    public static void handle(LongDistanceAttackPacket message, IPayloadContext context) {
        Player player = context.player();
        Level world = player.level();
        Entity e = world.getEntity(message.entityId);
        LongDistanceAttackPacket.doAttack(player, e);
    }

    public static void doAttack(Player player, Entity entity) {
        if (entity != null && player != null) {
            ItemStack held = player.getMainHandItem();
            if (entity != player && entity instanceof LivingEntity && held != null && !held.isEmpty() && held.getItem() instanceof ProximityProjectionKeys && entity.isAlive()) {
                player.attack(entity);
            }
        }
    }

    public CustomPacketPayload.Type<LongDistanceAttackPacket> type() {
        return MahouPackets.LONG_DISTANCE_ATTACK_TYPE;
    }
}

