/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.SynchedEntityData;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import stepsword.mahoutsukai.networking.ClientPacketHandler;
import stepsword.mahoutsukai.networking.MahouPackets;
import stepsword.mahoutsukai.util.Utils;

public class DataManagerPacket
implements CustomPacketPayload {
    public BlockPos pos;
    public List<SynchedEntityData.DataValue<?>> dataManagerEntries;
    public static final StreamCodec<RegistryFriendlyByteBuf, DataManagerPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, DataManagerPacket>(){

        public DataManagerPacket decode(RegistryFriendlyByteBuf buf) {
            DataManagerPacket packet = new DataManagerPacket();
            packet.decode(buf);
            return packet;
        }

        public void encode(RegistryFriendlyByteBuf buf, DataManagerPacket packet) {
            packet.encode(buf);
        }
    };

    public DataManagerPacket() {
    }

    public DataManagerPacket(BlockPos pos, List<SynchedEntityData.DataValue<?>> dataManagerEntries) {
        this.pos = pos;
        this.dataManagerEntries = dataManagerEntries;
    }

    public void decode(RegistryFriendlyByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        try {
            short i;
            ArrayList list = new ArrayList();
            while ((i = buf.readUnsignedByte()) != 255) {
                list.add(SynchedEntityData.DataValue.read((RegistryFriendlyByteBuf)buf, (int)i));
            }
            this.dataManagerEntries = list;
        }
        catch (Exception e) {
            Utils.err(e.toString());
        }
    }

    public void encode(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.pos.getX());
        buf.writeInt(this.pos.getY());
        buf.writeInt(this.pos.getZ());
        for (SynchedEntityData.DataValue<?> datavalue : this.dataManagerEntries) {
            datavalue.write(buf);
        }
        buf.writeByte(255);
    }

    public static void handle(DataManagerPacket message, IPayloadContext context) {
        ClientPacketHandler.updateTE(message);
    }

    public CustomPacketPayload.Type<DataManagerPacket> type() {
        return MahouPackets.DATA_MANAGER_TYPE;
    }
}

