/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells.projection;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.datacomponents.DataComponents;
import stepsword.mahoutsukai.datacomponents.scrollmahou.ScrollMahou;
import stepsword.mahoutsukai.datacomponents.stackholder.StackHolderMahou;
import stepsword.mahoutsukai.effects.projection.ProjectionSpellEffect;
import stepsword.mahoutsukai.item.spells.SpellScroll;
import stepsword.mahoutsukai.util.Utils;

public class ProjectionSpellScroll
extends SpellScroll {
    public static final String MEMORIZED_WEAPON = "MAHOUTSUKAI_MEMORIZED_WEAPON";

    public ProjectionSpellScroll() {
        super(new Item.Properties().component(DataComponents.STACK_HOLDERS_COMPONENT, (Object)new StackHolderMahou()));
    }

    @Override
    public int getInitialManaCost() {
        return MTConfig.PROJECTION_MANA_COST;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        Optional<ItemStack> weapon;
        StackHolderMahou stackHolderMahou;
        super.appendHoverText(stack, context, tooltip, flagIn);
        Object s = "";
        Item item = stack.getItem();
        if (item instanceof ProjectionSpellScroll && (stackHolderMahou = Utils.getStackHolderMahou(stack)) != null && (weapon = stackHolderMahou.getStack()).isPresent() && !weapon.get().isEmpty()) {
            Item i = weapon.get().getItem();
            if (weapon.get().isEnchanted()) {
                s = (String)s + "Enchanted ";
            }
            s = (String)s + i.getName(weapon.get()).getString();
            tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GREEN) + (String)s)));
        }
    }

    @Override
    public boolean doSpell(Player user, ScrollMahou scrollMahou, ItemStack stack) {
        StackHolderMahou mahou = Utils.getStackHolderMahou(stack);
        Optional<ItemStack> memorized = mahou.getStack();
        if (memorized.isEmpty() || memorized.get().getItem() == Items.AIR) {
            ItemStack mem = ProjectionSpellEffect.memorize(user);
            if (mem != null && !mem.isEmpty()) {
                user.displayClientMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Memorized!")), true);
                mahou.setStack(mem);
                Utils.setStackHolderMahou(stack, mahou);
                ((ServerPlayer)user).connection.send((Packet)new ClientboundSetCarriedItemPacket(user.getInventory().selected));
            }
        } else {
            return ProjectionSpellEffect.projection(user, memorized.orElse(null));
        }
        return false;
    }
}

