/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells.mystic.MysticStaff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.mahoujin.MysticStaffMahoujinEntity;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.FakeExplosion;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class Bakuretsu {
    private int radius;
    private float posX;
    private float posY;
    private float posZ;
    public HashMap<Player, Vec3> knockback = new HashMap();
    private float damage;

    public Bakuretsu() {
    }

    public Bakuretsu(int r, float x, float y, float z, float damage) {
        this();
        this.radius = r;
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.damage = damage;
    }

    public Bakuretsu(int r, BlockPos pos) {
        this();
        this.radius = r;
        this.posX = pos.getX();
        this.posY = pos.getY();
        this.posZ = pos.getZ();
    }

    public void explosionA(Level world, Player entity) {
        ArrayList<BlockPos> affected = new ArrayList<BlockPos>();
        FakeExplosion fake = EffectUtil.createFakeExplosion((Entity)entity, entity, entity.position(), affected);
        List<Entity> lst = this.playerKnockback(world, entity, fake);
        if (MTConfig.MYSTIC_STAFF_WORLD_DAMAGE) {
            for (float x = this.posX - (float)this.radius; x < this.posX + (float)this.radius + 1.0f; x += 1.0f) {
                for (float y = this.posY - (float)this.radius; y < this.posY + (float)this.radius + 1.0f; y += 1.0f) {
                    for (float z = this.posZ - (float)this.radius; z < this.posZ + (float)this.radius + 1.0f; z += 1.0f) {
                        BlockPos tmp;
                        Block b;
                        float cmp = (float)(this.radius * this.radius) - (this.posX - x) * (this.posX - x) - (this.posY - y) * (this.posY - y) - (this.posZ - z) * (this.posZ - z);
                        if (!(cmp > 0.0f) || EffectUtil.unchangableBlock(b = world.getBlockState(tmp = Utils.toBlockPos(x, y, z)).getBlock(), Arrays.asList(Blocks.CAVE_AIR, Blocks.VOID_AIR, Blocks.OBSIDIAN, Blocks.AIR)) || !(b.getExplosionResistance(world.getBlockState(tmp), (BlockGetter)world, tmp, (Explosion)fake) < 4000.0f)) continue;
                        affected.add(tmp);
                    }
                }
            }
            EffectUtil.tryFakeExplosion(fake, affected, (Entity)entity, entity, "bakuretsu", false, new ArrayList<Entity>(lst));
        }
        Vec3 boom = new Vec3((double)this.posX, (double)this.posY, (double)this.posZ);
        for (Entity e : lst) {
            this.hurt(e, boom, entity);
        }
    }

    public List<Entity> playerKnockback(Level world, Player player, Explosion explosion) {
        AABB aabb = new AABB((double)(this.posX - (float)this.radius), (double)(this.posY - (float)this.radius), (double)(this.posZ - (float)this.radius), (double)(this.posX + (float)this.radius), (double)(this.posY + (float)this.radius), (double)(this.posZ + (float)this.radius));
        List entities = world.getEntities((Entity)null, aabb, Entity::isAlive);
        ArrayList<Entity> ret = new ArrayList<Entity>();
        Vec3 boom = new Vec3((double)this.posX, (double)this.posY, (double)this.posZ);
        for (Entity entity : entities) {
            double z;
            double y;
            double x;
            double cmp;
            if (entity.ignoreExplosion(explosion) || entity instanceof MysticStaffMahoujinEntity || !((cmp = (double)(this.radius * this.radius) - ((double)this.posX - (x = entity.getX())) * ((double)this.posX - x) - ((double)this.posY - (y = entity.getY())) * ((double)this.posY - y) - ((double)this.posZ - (z = entity.getZ())) * ((double)this.posZ - z)) > 0.0)) continue;
            ret.add(entity);
        }
        return ret;
    }

    public void hurt(Entity entity, Vec3 boom, Player player) {
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        double cmp = (double)(this.radius * this.radius) - ((double)this.posX - x) * ((double)this.posX - x) - ((double)this.posY - y) * ((double)this.posY - y) - ((double)this.posZ - z) * ((double)this.posZ - z);
        float density = Bakuretsu.getBlockDensity(boom, entity);
        entity.hurt(player.damageSources().explosion((Entity)player, null), this.damage * density);
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).lastHurtByPlayerTime = 100;
        }
        Vec3 kb = new Vec3(x, y, z).add(new Vec3((double)(-this.posX), (double)(-this.posY), (double)(-this.posZ))).normalize().scale(Math.sqrt(cmp) / 4.0);
        double motionX = entity.getDeltaMovement().x;
        double motionY = entity.getDeltaMovement().y;
        double motionZ = entity.getDeltaMovement().z;
        entity.setDeltaMovement(motionX += kb.x, motionY += kb.y, motionZ += kb.z);
        if (entity instanceof Player) {
            this.knockback.put((Player)entity, kb);
        }
    }

    public void explosionB(Level world, Player player) {
        Random rand = Utils.getRandom(world);
        world.playSound((Player)null, (double)this.posX, (double)this.posY, (double)this.posZ, (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.BLOCKS, 4.0f, (1.0f + (rand.nextFloat() - rand.nextFloat()) * 0.2f) * 0.7f);
        for (float x = this.posX - (float)this.radius; x < this.posX + (float)this.radius + 1.0f; x += 1.0f) {
            for (float y = this.posY - (float)this.radius; y < this.posY + (float)this.radius + 1.0f; y += 1.0f) {
                for (float z = this.posZ - (float)this.radius; z < this.posZ + (float)this.radius + 1.0f; z += 1.0f) {
                    float cmp = (float)(this.radius * this.radius) - (this.posX - x) * (this.posX - x) - (this.posY - y) * (this.posY - y) - (this.posZ - z) * (this.posZ - z);
                    if (!(cmp > 0.0f) || !(cmp < 7.1f)) continue;
                    world.addParticle((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, true, (double)x, (double)y, (double)z, 1.0, 0.0, 0.0);
                }
            }
        }
    }

    public static float getBlockDensity(Vec3 explosionVector, Entity entity) {
        AABB AABB2 = entity.getBoundingBox();
        double d0 = 1.0 / ((AABB2.maxX - AABB2.minX) * 2.0 + 1.0);
        double d1 = 1.0 / ((AABB2.maxY - AABB2.minY) * 2.0 + 1.0);
        double d2 = 1.0 / ((AABB2.maxZ - AABB2.minZ) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (!(d0 < 0.0 || d1 < 0.0 || d2 < 0.0)) {
            int i = 0;
            int j = 0;
            float f = 0.0f;
            while (f <= 1.0f) {
                float f1 = 0.0f;
                while (f1 <= 1.0f) {
                    float f2 = 0.0f;
                    while (f2 <= 1.0f) {
                        double d5 = Mth.lerp((double)f, (double)AABB2.minX, (double)AABB2.maxX);
                        double d6 = Mth.lerp((double)f1, (double)AABB2.minY, (double)AABB2.maxY);
                        double d7 = Mth.lerp((double)f2, (double)AABB2.minZ, (double)AABB2.maxZ);
                        Vec3 Vec32 = new Vec3(d5 + d3, d6, d7 + d4);
                        if (entity.level().clip(new ClipContext(Vec32, explosionVector, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, entity)).getType() == HitResult.Type.MISS) {
                            ++i;
                        }
                        ++j;
                        f2 = (float)((double)f2 + d2);
                    }
                    f1 = (float)((double)f1 + d1);
                }
                f = (float)((double)f + d0);
            }
            return (float)i / (float)j;
        }
        return 0.0f;
    }
}

