/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.mysticcode;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ComponentItemHandler;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.containers.MysticCodeInventory;
import stepsword.mahoutsukai.datacomponents.mysticcode.MysticCodeData;
import stepsword.mahoutsukai.item.ItemBase;
import stepsword.mahoutsukai.item.spells.SpellScroll;
import stepsword.mahoutsukai.item.spells.boundary.BoundarySpellScroll;
import stepsword.mahoutsukai.item.spells.secret.FallenDownSpellScroll;
import stepsword.mahoutsukai.item.spells.secret.GandrSpellScroll;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class MysticCode
extends ItemBase
implements MenuProvider {
    public MysticCode(String name, Item.Properties prop) {
        super(name, prop);
        this.addPropertyOverrides();
    }

    public MysticCode() {
        super("mystic_code", new Item.Properties().stacksTo(1));
        this.addPropertyOverrides();
    }

    public void addPropertyOverrides() {
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (playerIn.isDiscrete()) {
            if (!worldIn.isClientSide) {
                playerIn.openMenu((MenuProvider)this);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.getItemInHand(handIn));
        }
        playerIn.startUsingItem(handIn);
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)playerIn.getItemInHand(handIn));
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public void releaseUsing(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        Item item;
        ItemStack ammo;
        int slot;
        ComponentItemHandler inventory;
        if (!worldIn.isClientSide && (inventory = Utils.getMCInventory(stack)) != null && (slot = MysticCode.getSlot(stack)) >= 0 && slot < 3 && !EffectUtil.inItemBlacklist((ammo = inventory.getStackInSlot(slot)).getItem(), this.getBlacklist(), worldIn) && (item = ammo.getItem()) instanceof SpellScroll) {
            SpellScroll s = (SpellScroll)item;
            s.useAction(ammo, worldIn, entityLiving, this.consumesScroll());
            inventory.setStackInSlot(slot, ammo);
            if (this.requiresDura()) {
                stack.hurtAndBreak(1, entityLiving, EquipmentSlot.MAINHAND);
            }
            this.saveCapabilityToStack(stack);
        }
        if (!worldIn.isClientSide) {
            MysticCode.triggerUpdate((ServerPlayer)entityLiving, stack);
        }
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Player player = ctx.getPlayer();
        if (player != null) {
            ItemStack ammo;
            int slot;
            Level worldIn = player.level();
            InteractionHand hand = ctx.getHand();
            BlockPos pos = ctx.getClickedPos();
            Direction facing = ctx.getClickedFace();
            ItemStack stack = player.getItemInHand(hand);
            if (player.isDiscrete()) {
                if (!worldIn.isClientSide) {
                    player.openMenu((MenuProvider)this);
                }
                return InteractionResult.SUCCESS;
            }
            ComponentItemHandler inventory = Utils.getMCInventory(stack);
            if (inventory != null && (slot = MysticCode.getSlot(stack)) >= 0 && slot < 3 && !EffectUtil.inItemBlacklist((ammo = inventory.getStackInSlot(slot)).getItem(), this.getBlacklist(), worldIn)) {
                Item item = ammo.getItem();
                if (item instanceof BoundarySpellScroll) {
                    BoundarySpellScroll b = (BoundarySpellScroll)item;
                    InteractionResult s = b.boundaryScrollUse(player, worldIn, ammo, pos, facing, this.consumesScroll());
                    inventory.setStackInSlot(slot, ammo);
                    if (this.requiresDura()) {
                        stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                    }
                    if (!worldIn.isClientSide) {
                        this.saveCapabilityToStack(stack);
                    }
                    return s;
                }
                player.startUsingItem(hand);
            }
            if (!worldIn.isClientSide) {
                MysticCode.triggerUpdate((ServerPlayer)player, stack);
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.FAIL;
    }

    public ArrayList<? extends String> getBlacklist() {
        return new ArrayList();
    }

    public boolean requiresDura() {
        return false;
    }

    public boolean consumesScroll() {
        return true;
    }

    public static void setSlot(ItemStack stack, int g) {
        MysticCodeData data = Utils.getMysticCodeData(stack);
        data.setSlot(g);
        Utils.setMysticCodeData(stack, data);
    }

    public static int getSlot(ItemStack stack) {
        MysticCodeData data = Utils.getMysticCodeData(stack);
        return data.getSlot();
    }

    public void setRandomColor(ItemStack stack, RandomSource rand) {
        this.setColor(stack, rand.nextInt(8));
    }

    public void setColor(ItemStack stack, int z) {
        MysticCodeData data = Utils.getMysticCodeData(stack);
        data.setColor(z);
        Utils.setMysticCodeData(stack, data);
    }

    public int getColor(ItemStack stack) {
        MysticCodeData data = Utils.getMysticCodeData(stack);
        return data.getColor();
    }

    public void setSlotsForWheel(ItemStack code, ItemStack s1, ItemStack s2, ItemStack s3) {
        MysticCodeData data = Utils.getMysticCodeData(code);
        data.setSlot1(MysticCode.convertStackToString(s1));
        data.setSlot2(MysticCode.convertStackToString(s2));
        data.setSlot3(MysticCode.convertStackToString(s3));
        Utils.setMysticCodeData(code, data);
    }

    public List<String> getSlotsForWheel(ItemStack code) {
        ArrayList<String> lst = new ArrayList<String>();
        MysticCodeData data = Utils.getMysticCodeData(code);
        lst.add(data.getSlot1());
        lst.add(data.getSlot2());
        lst.add(data.getSlot3());
        return lst;
    }

    public static String convertStackToString(ItemStack s) {
        if (s.isEmpty()) {
            return "SLOT EMPTY";
        }
        return s.getItem().getName(s).getString();
    }

    public void onUseTick(Level level, LivingEntity player, ItemStack stack, int count) {
        ItemStack ammo;
        int slot;
        ComponentItemHandler inventory = Utils.getMCInventory(stack);
        if (inventory != null && (slot = MysticCode.getSlot(stack)) >= 0 && slot < 3 && ((ammo = inventory.getStackInSlot(slot)).getItem() instanceof GandrSpellScroll || ammo.getItem() instanceof FallenDownSpellScroll)) {
            ammo.getItem().onUseTick(level, player, ammo, count);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public static void triggerUpdate(ServerPlayer player, ItemStack stack) {
        player.connection.send((Packet)new ClientboundSetCarriedItemPacket(player.getInventory().selected));
    }

    public boolean isPrimaryItemFor(ItemStack stack, Holder<Enchantment> enchantment) {
        if (EffectUtil.inEnchantBlacklist(enchantment, MTConfig.MYSTIC_CODE_ENCHANT_BLACKLIST)) {
            return false;
        }
        return super.isPrimaryItemFor(stack, enchantment);
    }

    public Component getDisplayName() {
        return Component.literal((String)"Mystic Code");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player Player2) {
        ItemStack stack = Player2.getMainHandItem().getItem() instanceof MysticCode ? Player2.getMainHandItem() : Player2.getOffhandItem();
        return new MysticCodeInventory(i, Utils.getMCInventory(stack), (Container)playerInventory, stack);
    }

    public void saveCapabilityToStack(ItemStack stack) {
        ComponentItemHandler inventory;
        if (stack != null && !stack.isEmpty() && stack.getItem() instanceof MysticCode && (inventory = Utils.getMCInventory(stack)) != null) {
            this.setSlotsForWheel(stack, inventory.getStackInSlot(0), inventory.getStackInSlot(1), inventory.getStackInSlot(2));
        }
    }
}

